/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.spi.RubyDebuggerImplementation;
import org.openide.util.Lookup;

public final class RubyProcessCreator
implements Callable<Process> {
    private static final Logger LOGGER = Logger.getLogger(RubyProcessCreator.class.getName());
    private static final boolean SYNC_RUBY_STDIO = System.getProperty("ruby.no.sync-stdio") == null;
    private static final boolean LAUNCH_JRUBY_SCRIPT = System.getProperty("ruby.use.jruby.script") != null;
    private final RubyExecutionDescriptor descriptor;
    private final String charsetName;

    public RubyProcessCreator(RubyExecutionDescriptor descriptor) {
        this(descriptor, descriptor.getEncoding());
    }

    public RubyProcessCreator(RubyExecutionDescriptor descriptor, String charsetName) {
        if (descriptor.getCmd() == null) {
            descriptor.cmd(descriptor.getPlatform().getInterpreterFile());
        }
        descriptor.addBinPath(true);
        this.descriptor = descriptor;
        this.charsetName = charsetName;
    }

    public boolean isAbleToCreateProcess() {
        if (this.descriptor.debug) {
            RubyDebuggerImplementation debugger = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            if (debugger == null) {
                LOGGER.severe("RubyDebuggerImplementation implementation is not available");
                return false;
            }
            debugger.describeProcess(this.descriptor);
            return debugger.prepare();
        }
        return true;
    }

    @Override
    public Process call() throws Exception {
        if (this.descriptor.debug) {
            RubyDebuggerImplementation debugger = (RubyDebuggerImplementation)Lookup.getDefault().lookup(RubyDebuggerImplementation.class);
            if (debugger == null) {
                throw new IllegalStateException("RubyDebuggerImplementation implementation is not available.");
            }
            debugger.describeProcess(this.descriptor);
            if (!debugger.prepare()) {
                throw new IllegalStateException("Cannot prepare application to debug. Should be checked before.");
            }
            return debugger.debug();
        }
        ExternalProcessBuilder builder = null;
        List<? extends String> args = this.buildArgs();
        if (!this.descriptor.cmd.getName().startsWith("jruby") || LAUNCH_JRUBY_SCRIPT) {
            builder = new ExternalProcessBuilder(this.descriptor.cmd.getPath());
        } else {
            builder = new ExternalProcessBuilder(args.get(0));
            args.remove(0);
        }
        for (String string : args) {
            if (string == null) continue;
            builder = builder.addArgument(string);
        }
        if (this.descriptor.getPwd() != null) {
            builder = builder.workingDirectory(this.descriptor.getPwd());
        }
        for (Map.Entry entry : this.descriptor.getAdditionalEnvironment().entrySet()) {
            builder = builder.addEnvironmentVariable((String)entry.getKey(), (String)entry.getValue());
        }
        return builder.call();
    }

    private List<? extends String> getCommonArgs() {
        ArrayList<String> argvList = new ArrayList<String>();
        File cmd = this.descriptor.cmd;
        assert (cmd != null);
        if (this.descriptor.getInitialArgs() != null) {
            argvList.addAll(Arrays.asList(this.descriptor.getInitialArgs()));
        }
        if (this.descriptor.getScriptPrefix() != null) {
            argvList.add(this.descriptor.getScriptPrefix());
        }
        if (this.descriptor.script != null) {
            argvList.add(this.descriptor.script);
        }
        if (this.descriptor.getAdditionalArgs() != null) {
            argvList.addAll(Arrays.asList(this.descriptor.getAdditionalArgs()));
        }
        return argvList;
    }

    protected List<? extends String> buildArgs() {
        ArrayList<String> argvList = new ArrayList<String>();
        String rubyHome = this.descriptor.getCmd().getParentFile().getParent();
        String cmdName = this.descriptor.getCmd().getName();
        if (this.descriptor.isRunThroughRuby()) {
            argvList.addAll(ExecutionUtils.getRubyArgs(rubyHome, cmdName, this.descriptor, this.charsetName));
        }
        argvList.addAll(this.getCommonArgs());
        return argvList;
    }
}

