/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import javax.swing.KeyStroke;
import org.openide.util.Utilities;

class Utils {
    Utils() {
    }

    static String getKeyStrokesAsText(KeyStroke[] keyStrokes, String delim) {
        if (keyStrokes == null) {
            return "";
        }
        if (keyStrokes.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(Utils.getKeyStrokeAsText(keyStrokes[0]));
        int k = keyStrokes.length;
        for (int i = 1; i < k; ++i) {
            sb.append(delim).append(Utils.getKeyStrokeAsText(keyStrokes[i]));
        }
        return new String(sb);
    }

    static KeyStroke getKeyStroke(String keyStroke) {
        KeyStroke ks;
        int modifiers = 0;
        if (keyStroke.startsWith("Ctrl+")) {
            modifiers |= 0x80;
            keyStroke = keyStroke.substring(5);
        }
        if (keyStroke.startsWith("Alt+")) {
            modifiers |= 0x200;
            keyStroke = keyStroke.substring(4);
        }
        if (keyStroke.startsWith("Shift+")) {
            modifiers |= 0x40;
            keyStroke = keyStroke.substring(6);
        }
        if (keyStroke.startsWith("Meta+")) {
            modifiers |= 0x100;
            keyStroke = keyStroke.substring(5);
        }
        if ((ks = Utilities.stringToKey((String)keyStroke)) == null) {
            return null;
        }
        KeyStroke result = KeyStroke.getKeyStroke(ks.getKeyCode(), modifiers);
        return result;
    }

    static String getKeyStrokeAsText(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuilder sb = new StringBuilder();
        if ((modifiers & 0x80) > 0) {
            sb.append("Ctrl+");
        }
        if ((modifiers & 0x200) > 0) {
            sb.append("Alt+");
        }
        if ((modifiers & 0x40) > 0) {
            sb.append("Shift+");
        }
        if ((modifiers & 0x100) > 0) {
            sb.append("Meta+");
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return sb.toString();
    }
}

