/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.j2meunit;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.mobility.j2meunit.TestCreator;
import org.netbeans.modules.mobility.j2meunit.TestUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2MEUnitPlugin
extends JUnitPlugin {
    private Project p;
    private AntProjectHelper aph;

    public J2MEUnitPlugin(Project project, AntProjectHelper antProjectHelper) {
        this.p = project;
        this.aph = antProjectHelper;
    }

    protected JUnitPlugin.Location getTestLocation(JUnitPlugin.Location location) {
        ClassPath classPath;
        FileObject fileObject = location.getFileObject();
        if (fileObject.isFolder() || (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = J2MEUnitPlugin.getTestResName(string, fileObject.getExt());
        assert (string2 != null);
        return J2MEUnitPlugin.getOppositeLocation(location, classPath, string2, true);
    }

    protected JUnitPlugin.Location getTestedLocation(JUnitPlugin.Location location) {
        ClassPath classPath;
        FileObject fileObject = location.getFileObject();
        if (fileObject.isFolder() || (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = J2MEUnitPlugin.getSrcResName(string, fileObject.getExt());
        if (string2 == null) {
            return null;
        }
        return J2MEUnitPlugin.getOppositeLocation(location, classPath, string2, false);
    }

    private static String getTestResName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 10);
        stringBuilder.append(string).append("Test");
        if (string2.length() != 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    private static String getSrcResName(String string, String string2) {
        if (!string.endsWith("Test")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
        stringBuilder.append(string.substring(0, string.length() - 4));
        if (string2.length() != 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    private static JUnitPlugin.Location getOppositeLocation(JUnitPlugin.Location location, ClassPath classPath, String string, boolean bl) {
        URL[] uRLArray;
        FileObject fileObject = location.getFileObject();
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        URL[] uRLArray2 = uRLArray = bl ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2) : UnitTestForSourceQuery.findSources((FileObject)fileObject2);
        if (uRLArray == null || uRLArray.length == 0) {
            return null;
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])uRLArray);
        List list = classPath2.findAllResources(string);
        if (list.isEmpty()) {
            return null;
        }
        return new JUnitPlugin.Location((FileObject)list.get(0));
    }

    public boolean canCreateTests(FileObject ... fileObjectArray) {
        TestUtils.TestableTypeFinder testableTypeFinder = new TestUtils.TestableTypeFinder();
        for (FileObject fileObject : fileObjectArray) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) continue;
            try {
                javaSource.runUserActionTask((Task)testableTypeFinder, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
            if (testableTypeFinder.isTestable()) continue;
            return false;
        }
        return true;
    }

    protected FileObject[] createTests(FileObject[] fileObjectArray, FileObject fileObject, Map<JUnitPlugin.CreateTestParam, Object> map) {
        Library library;
        ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)this.p.getLookup().lookup(ProjectClassPathExtender.class);
        if (projectClassPathExtender != null) {
            library = LibraryManager.getDefault().getLibrary("JMUnit4CLDC10");
            try {
                projectClassPathExtender.addLibrary(library);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
        library = (AntProjectHelper)this.p.getLookup().lookup(AntProjectHelper.class);
        try {
            TestUtils.addTestRunnerMIDletProperty(this.p, (AntProjectHelper)library);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        TestCreator testCreator = new TestCreator(map, fileObject, this.p, this.aph);
        FileObject[] fileObjectArray2 = testCreator.generateTests(fileObjectArray);
        return fileObjectArray2;
    }

    public static void main(String[] stringArray) {
        try {
            TestCreator testCreator = new TestCreator(Collections.EMPTY_MAP, FileUtil.createData((File)new File("./")), null, null);
            if (stringArray.length > 0) {
                FileObject[] fileObjectArray = new FileObject[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    fileObjectArray[i] = FileUtil.createData((File)new File(stringArray[i]));
                }
                FileObject[] fileObjectArray2 = testCreator.generateTests(fileObjectArray);
            } else {
                System.out.println("Usage: J2MEUnitPlugin FILES...");
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            iOException.printStackTrace();
        }
    }
}

