/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceLevelQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SourceLevelQueryImpl
implements SourceLevelQueryImplementation,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private final Map<FileObject, String> sourceLevels = new WeakHashMap<FileObject, String>();

    public SourceLevelQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    public String getSourceLevel(final FileObject file) {
        return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

            public String run() {
                return SourceLevelQueryImpl.this.getSourceLevelImpl(file);
            }
        });
    }

    private synchronized String getSourceLevelImpl(FileObject file) {
        for (Map.Entry<FileObject, String> entry : this.sourceLevels.entrySet()) {
            FileObject root = entry.getKey();
            if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return entry.getValue();
        }
        Element java = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/3", true);
        if (java == null) {
            return null;
        }
        for (Element compilationUnitEl : XMLUtil.findSubElements((Element)java)) {
            assert (compilationUnitEl.getLocalName().equals("compilation-unit")) : compilationUnitEl;
            List<FileObject> packageRoots = Classpaths.findPackageRoots(this.helper, this.evaluator, compilationUnitEl);
            for (FileObject root : packageRoots) {
                if (root != file && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
                String lvl = this.getLevel(compilationUnitEl);
                for (FileObject root2 : packageRoots) {
                    this.sourceLevels.put(root2, lvl);
                }
                return lvl;
            }
        }
        return null;
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationXmlChanged(AntProjectEvent ev) {
        SourceLevelQueryImpl sourceLevelQueryImpl = this;
        synchronized (sourceLevelQueryImpl) {
            this.sourceLevels.clear();
        }
    }

    private String getLevel(Element compilationUnitEl) {
        Element sourceLevelEl = XMLUtil.findElement((Element)compilationUnitEl, (String)"source-level", (String)"http://www.netbeans.org/ns/freeform-project-java/3");
        if (sourceLevelEl != null) {
            return XMLUtil.findText((Node)sourceLevelEl);
        }
        return null;
    }
}

