/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.JoinColumn;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.PrimaryKeyJoinColumn;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.IdClassImpl;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.JoinColumnImpl;
import org.netbeans.modules.j2ee.persistenceapi.metadata.orm.annotation.PrimaryKeyJoinColumnImpl;

public class EntityMappingsUtilities {
    private static final Set<String> ORM_ANNOTATIONS = new HashSet<String>();

    public static boolean isTransient(Map<String, ? extends AnnotationMirror> map, Set<Modifier> set) {
        return map.containsKey("javax.persistence.Transient") || set.contains((Object)Modifier.TRANSIENT);
    }

    public static boolean hasFieldAccess(AnnotationModelHelper annotationModelHelper, List<? extends Element> list) {
        for (ExecutableElement executableElement : ElementFilter.methodsIn(list)) {
            for (AnnotationMirror annotationMirror : executableElement.getAnnotationMirrors()) {
                String string = annotationModelHelper.getAnnotationTypeName(annotationMirror.getAnnotationType());
                if (string == null || !ORM_ANNOTATIONS.contains(string)) continue;
                return false;
            }
        }
        return true;
    }

    public static String getterNameToPropertyName(String string) {
        if (string.length() > 3 && string.startsWith("get")) {
            return EntityMappingsUtilities.toLowerCaseFirst(string.substring(3));
        }
        if (string.length() > 2 && string.startsWith("is")) {
            return EntityMappingsUtilities.toLowerCaseFirst(string.substring(2));
        }
        return null;
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase();
    }

    public static String getElementTypeName(Element element) {
        TypeMirror typeMirror = element.asType();
        if (TypeKind.DECLARED.equals((Object)typeMirror.getKind())) {
            return ((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName().toString();
        }
        return Void.TYPE.getName();
    }

    public static String getCollectionArgumentTypeName(AnnotationModelHelper annotationModelHelper, Element element) {
        TypeElement typeElement;
        TypeMirror typeMirror = element.asType();
        if (EntityMappingsUtilities.isCollectionType(annotationModelHelper, typeMirror) && (typeElement = EntityMappingsUtilities.getFirstTypeArgument(typeMirror)) != null) {
            return typeElement.getQualifiedName().toString();
        }
        return Void.TYPE.getName();
    }

    public static List<JoinColumn> getJoinColumns(final AnnotationModelHelper annotationModelHelper, Map<String, ? extends AnnotationMirror> map) {
        final ArrayList<JoinColumn> arrayList = new ArrayList<JoinColumn>();
        AnnotationMirror annotationMirror = map.get("javax.persistence.JoinColumn");
        if (annotationMirror != null) {
            arrayList.add(new JoinColumnImpl(annotationModelHelper, annotationMirror));
        } else {
            AnnotationMirror annotationMirror2 = map.get("javax.persistence.JoinColumns");
            if (annotationMirror2 != null) {
                AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
                annotationParser.expectAnnotationArray("value", annotationModelHelper.resolveType("javax.persistence.JoinColumn"), new ArrayValueHandler(){

                    public Object handleArray(List<AnnotationValue> list) {
                        for (AnnotationValue annotationValue : list) {
                            AnnotationMirror annotationMirror = (AnnotationMirror)annotationValue.getValue();
                            arrayList.add(new JoinColumnImpl(annotationModelHelper, annotationMirror));
                        }
                        return null;
                    }
                }, null);
                annotationParser.parse(annotationMirror2);
            }
        }
        return arrayList;
    }

    public static List<PrimaryKeyJoinColumn> getPrimaryKeyJoinColumns(final AnnotationModelHelper annotationModelHelper, Map<String, ? extends AnnotationMirror> map) {
        final ArrayList<PrimaryKeyJoinColumn> arrayList = new ArrayList<PrimaryKeyJoinColumn>();
        AnnotationMirror annotationMirror = map.get("javax.persistence.PrimaryKeyJoinColumn");
        if (annotationMirror != null) {
            arrayList.add(new PrimaryKeyJoinColumnImpl(annotationModelHelper, annotationMirror));
        } else {
            AnnotationMirror annotationMirror2 = map.get("javax.persistence.PrimaryKeyJoinColumns");
            if (annotationMirror2 != null) {
                AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
                annotationParser.expectAnnotationArray("value", annotationModelHelper.resolveType("javax.persistence.PrimaryKeyJoinColumn"), new ArrayValueHandler(){

                    public Object handleArray(List<AnnotationValue> list) {
                        for (AnnotationValue annotationValue : list) {
                            AnnotationMirror annotationMirror = (AnnotationMirror)annotationValue.getValue();
                            arrayList.add(new PrimaryKeyJoinColumnImpl(annotationModelHelper, annotationMirror));
                        }
                        return null;
                    }
                }, null);
                annotationParser.parse(annotationMirror2);
            }
        }
        return arrayList;
    }

    public static String getTemporalType(AnnotationModelHelper annotationModelHelper, AnnotationMirror annotationMirror) {
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectEnumConstant("value", annotationModelHelper.resolveType("javax.persistence.TemporalType"), null);
        return (String)annotationParser.parse(annotationMirror).get("value", String.class);
    }

    public static IdClassImpl getIdClass(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
        AnnotationMirror annotationMirror = (AnnotationMirror)annotationModelHelper.getAnnotationsByType(typeElement.getAnnotationMirrors()).get("javax.persistence.IdClass");
        if (annotationMirror == null) {
            return null;
        }
        AnnotationParser annotationParser = AnnotationParser.create((AnnotationModelHelper)annotationModelHelper);
        annotationParser.expectClass("value", null);
        String string = (String)annotationParser.parse(annotationMirror).get("value", String.class);
        return new IdClassImpl(string);
    }

    static TypeElement getFirstTypeArgument(TypeMirror typeMirror) {
        if (TypeKind.DECLARED != typeMirror.getKind()) {
            return null;
        }
        List<? extends TypeMirror> list = ((DeclaredType)typeMirror).getTypeArguments();
        if (list.size() != 1) {
            return null;
        }
        TypeMirror typeMirror2 = list.iterator().next();
        if (TypeKind.DECLARED != typeMirror2.getKind()) {
            return null;
        }
        Element element = ((DeclaredType)typeMirror2).asElement();
        if (ElementKind.CLASS != element.getKind()) {
            return null;
        }
        return (TypeElement)element;
    }

    static boolean isCollectionType(AnnotationModelHelper annotationModelHelper, TypeMirror typeMirror) {
        return annotationModelHelper.isSameRawType(typeMirror, "java.util.Collection") || annotationModelHelper.isSameRawType(typeMirror, "java.util.Set") || annotationModelHelper.isSameRawType(typeMirror, "java.util.List") || annotationModelHelper.isSameRawType(typeMirror, "java.util.Map");
    }

    private static String toLowerCaseFirst(String string) {
        if (string.length() > 0) {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            return new String(cArray);
        }
        return string;
    }

    static {
        ORM_ANNOTATIONS.add("javax.persistence.AssociationOverride");
        ORM_ANNOTATIONS.add("javax.persistence.AssociationOverrides");
        ORM_ANNOTATIONS.add("javax.persistence.AttributeOverride");
        ORM_ANNOTATIONS.add("javax.persistence.AttributeOverrides");
        ORM_ANNOTATIONS.add("javax.persistence.Basic");
        ORM_ANNOTATIONS.add("javax.persistence.Column");
        ORM_ANNOTATIONS.add("javax.persistence.DiscriminatorColumn");
        ORM_ANNOTATIONS.add("javax.persistence.DiscriminatorValue");
        ORM_ANNOTATIONS.add("javax.persistence.Embeddable");
        ORM_ANNOTATIONS.add("javax.persistence.Embedded");
        ORM_ANNOTATIONS.add("javax.persistence.EmbeddedId");
        ORM_ANNOTATIONS.add("javax.persistence.Enumerated");
        ORM_ANNOTATIONS.add("javax.persistence.GeneratedValue");
        ORM_ANNOTATIONS.add("javax.persistence.Id");
        ORM_ANNOTATIONS.add("javax.persistence.IdClass");
        ORM_ANNOTATIONS.add("javax.persistence.Inheritance");
        ORM_ANNOTATIONS.add("javax.persistence.JoinColumn");
        ORM_ANNOTATIONS.add("javax.persistence.JoinColumns");
        ORM_ANNOTATIONS.add("javax.persistence.JoinTable");
        ORM_ANNOTATIONS.add("javax.persistence.Lob");
        ORM_ANNOTATIONS.add("javax.persistence.ManyToMany");
        ORM_ANNOTATIONS.add("javax.persistence.ManyToOne");
        ORM_ANNOTATIONS.add("javax.persistence.MapKey");
        ORM_ANNOTATIONS.add("javax.persistence.MappedSuperclass");
        ORM_ANNOTATIONS.add("javax.persistence.OneToMany");
        ORM_ANNOTATIONS.add("javax.persistence.OneToOne");
        ORM_ANNOTATIONS.add("javax.persistence.OrderBy");
        ORM_ANNOTATIONS.add("javax.persistence.PrimaryKeyJoinColumn");
        ORM_ANNOTATIONS.add("javax.persistence.PrimaryKeyJoinColumns");
        ORM_ANNOTATIONS.add("javax.persistence.SecondaryTable");
        ORM_ANNOTATIONS.add("javax.persistence.SecondaryTables");
        ORM_ANNOTATIONS.add("javax.persistence.SequenceGenerator");
        ORM_ANNOTATIONS.add("javax.persistence.Table");
        ORM_ANNOTATIONS.add("javax.persistence.TableGenerator");
        ORM_ANNOTATIONS.add("javax.persistence.Temporal");
        ORM_ANNOTATIONS.add("javax.persistence.Transient");
        ORM_ANNOTATIONS.add("javax.persistence.UniqueConstraint");
        ORM_ANNOTATIONS.add("javax.persistence.Version");
    }
}

