/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.cnd.testrunner.spi.TestHandlerFactory;
import org.netbeans.modules.cnd.testrunner.spi.TestRecognizerHandler;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;

public final class TestRunnerLineConvertor
implements LineConvertor {
    private static final Logger LOGGER = Logger.getLogger(TestRunnerLineConvertor.class.getName());
    private final Manager manager;
    private TestSession session;
    private final List<TestRecognizerHandler> handlers;

    public TestRunnerLineConvertor(Manager manager, TestSession session, List<TestHandlerFactory> handlerFactories) {
        this.manager = manager;
        this.session = session;
        this.handlers = new ArrayList<TestRecognizerHandler>();
        for (TestHandlerFactory testHandlerFactory : handlerFactories) {
            this.handlers.addAll(testHandlerFactory.createHandlers());
        }
    }

    public synchronized void refreshSession() {
        RerunHandler handler = this.session.getRerunHandler();
        this.session = new TestSession(this.session.getName(), this.session.getProject(), this.session.getSessionType(), this.session.getNodeFactory());
        this.session.setRerunHandler(handler);
    }

    public synchronized List<ConvertedLine> convert(String line) {
        for (TestRecognizerHandler handler : this.handlers) {
            if (!handler.matches(line)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Handler [" + handler + "] matched line: " + line);
            }
            try {
                handler.updateUI(this.manager, this.session);
                return this.asConvertedLines(handler.getRecognizedOutput());
            }
            catch (IllegalStateException ise) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + line + " with handler: " + handler, ise);
                break;
            }
            catch (IndexOutOfBoundsException ioobe) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + line + " with handler: " + handler, ioobe);
                break;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No handler for line: " + line);
        }
        this.session.addOutput(line);
        this.manager.displayOutput(this.session, line, false);
        return null;
    }

    private List<ConvertedLine> asConvertedLines(List<String> lines) {
        ArrayList<ConvertedLine> result = new ArrayList<ConvertedLine>(lines.size());
        boolean handled = false;
        for (String line : lines) {
            if (handled) continue;
            result.add(ConvertedLine.forText((String)line, null));
        }
        return result;
    }
}

