/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.InheritedBooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public abstract class BasicCompilerConfiguration
implements AllOptionsProvider,
ConfigurationBase {
    private String baseDir;
    private BasicCompilerConfiguration master;
    public static final int DEVELOPMENT_MODE_FAST = 0;
    public static final int DEVELOPMENT_MODE_DEBUG = 1;
    public static final int DEVELOPMENT_MODE_DEBUG_PERF = 2;
    public static final int DEVELOPMENT_MODE_TEST = 3;
    public static final int DEVELOPMENT_MODE_RELEASE_DIAG = 4;
    public static final int DEVELOPMENT_MODE_RELEASE = 5;
    public static final int DEVELOPMENT_MODE_RELEASE_PERF = 6;
    private static final String[] DEVELOPMENT_MODE_NAMES = new String[]{BasicCompilerConfiguration.getString("FastBuildTxt"), BasicCompilerConfiguration.getString("DebugTxt"), BasicCompilerConfiguration.getString("PerformanceDebugTxt"), BasicCompilerConfiguration.getString("TestCoverageTxt"), BasicCompilerConfiguration.getString("DiagnosableReleaseTxt"), BasicCompilerConfiguration.getString("ReleaseTxt"), BasicCompilerConfiguration.getString("PerformanceReleaseTxt")};
    private IntConfiguration developmentMode;
    public static final int WARNING_LEVEL_NO = 0;
    public static final int WARNING_LEVEL_DEFAULT = 1;
    public static final int WARNING_LEVEL_MORE = 2;
    public static final int WARNING_LEVEL_TAGS = 3;
    public static final int WARNING_LEVEL_CONVERT = 4;
    public static final int WARNING_LEVEL_32_64 = 5;
    private static final String[] WARNING_LEVEL_NAMES = new String[]{BasicCompilerConfiguration.getString("NoWarningsTxt"), BasicCompilerConfiguration.getString("SomeWarningsTxt"), BasicCompilerConfiguration.getString("MoreWarningsTxt"), BasicCompilerConfiguration.getString("ConvertWarningsTxt")};
    private IntConfiguration warningLevel;
    public static final int BITS_DEFAULT = 0;
    public static final int BITS_32 = 1;
    public static final int BITS_64 = 2;
    private static final String[] BITS_NAMES = new String[]{BasicCompilerConfiguration.getString("BITS_DEFAULT"), BasicCompilerConfiguration.getString("BITS_32"), BasicCompilerConfiguration.getString("BITS_64")};
    private IntConfiguration sixtyfourBits;
    private InheritedBooleanConfiguration strip;
    public static final int MT_LEVEL_NONE = 0;
    public static final int MT_LEVEL_SAFE = 1;
    public static final int MT_LEVEL_AUTOMATIC = 2;
    public static final int MT_LEVEL_OPENMP = 3;
    private static final String[] MT_LEVEL_NAMES = new String[]{BasicCompilerConfiguration.getString("NoneTxt"), BasicCompilerConfiguration.getString("SafeTxt"), BasicCompilerConfiguration.getString("AutomaticTxt"), BasicCompilerConfiguration.getString("OpenMPTxt")};
    private static final String[] MT_LEVEL_OPTIONS = null;
    private IntConfiguration mpLevel;
    private StringConfiguration additionalDependencies;
    private StringConfiguration tool;
    private OptionsConfiguration commandLineConfiguration;

    protected BasicCompilerConfiguration(String baseDir, BasicCompilerConfiguration master) {
        this.baseDir = baseDir;
        this.master = master;
        this.developmentMode = new IntConfiguration(master != null ? master.getDevelopmentMode() : null, 1, DEVELOPMENT_MODE_NAMES, null);
        this.warningLevel = new IntConfiguration(master != null ? master.getWarningLevel() : null, 1, WARNING_LEVEL_NAMES, null);
        this.sixtyfourBits = new IntConfiguration(master != null ? master.getSixtyfourBits() : null, 0, BITS_NAMES, null);
        this.strip = new InheritedBooleanConfiguration(master != null ? master.getStrip() : null, false);
        this.mpLevel = new IntConfiguration(master != null ? master.getMTLevel() : null, 0, MT_LEVEL_NAMES, null);
        this.additionalDependencies = new StringConfiguration(master != null ? master.getAdditionalDependencies() : null, "");
        this.tool = new StringConfiguration(master != null ? master.getTool() : null, "");
        this.commandLineConfiguration = new OptionsConfiguration();
    }

    public void fixupMasterLinks(BasicCompilerConfiguration compilerConfiguration) {
        this.getDevelopmentMode().setMaster(compilerConfiguration.getDevelopmentMode());
        this.getWarningLevel().setMaster(compilerConfiguration.getWarningLevel());
        this.getSixtyfourBits().setMaster(compilerConfiguration.getSixtyfourBits());
        this.getStrip().setMaster(compilerConfiguration.getStrip());
        this.getAdditionalDependencies().setMaster(compilerConfiguration.getAdditionalDependencies());
        this.getTool().setMaster(compilerConfiguration.getTool());
    }

    @Override
    public boolean getModified() {
        return this.developmentMode.getModified() || this.mpLevel.getModified() || this.warningLevel.getModified() || this.sixtyfourBits.getModified() || this.strip.getModified() || this.additionalDependencies.getModified() || this.tool.getModified() || this.commandLineConfiguration.getModified();
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getOptions(AbstractCompiler compiler) {
        return "OVERRIDE";
    }

    public void setMaster(BasicCompilerConfiguration master) {
        this.master = master;
    }

    public BasicCompilerConfiguration getMaster() {
        return this.master;
    }

    public void setDevelopmentMode(IntConfiguration developmentMode) {
        this.developmentMode = developmentMode;
    }

    public IntConfiguration getDevelopmentMode() {
        return this.developmentMode;
    }

    public void setWarningLevel(IntConfiguration warningLevel) {
        this.warningLevel = warningLevel;
    }

    public IntConfiguration getWarningLevel() {
        return this.warningLevel;
    }

    public void setSixtyfourBits(IntConfiguration sixtyfourBits) {
        this.sixtyfourBits = sixtyfourBits;
    }

    public IntConfiguration getSixtyfourBits() {
        return this.sixtyfourBits;
    }

    public void setMTLevel(IntConfiguration mpLevel) {
        this.mpLevel = mpLevel;
    }

    public IntConfiguration getMTLevel() {
        return this.mpLevel;
    }

    protected String[] getMTLevelOptions() {
        return MT_LEVEL_OPTIONS;
    }

    public void setStrip(InheritedBooleanConfiguration strip) {
        this.strip = strip;
    }

    public InheritedBooleanConfiguration getStrip() {
        return this.strip;
    }

    public void setAdditionalDependencies(StringConfiguration additionalDependencies) {
        this.additionalDependencies = additionalDependencies;
    }

    public StringConfiguration getAdditionalDependencies() {
        return this.additionalDependencies;
    }

    public void setTool(StringConfiguration tool) {
        this.tool = tool;
    }

    public StringConfiguration getTool() {
        return this.tool;
    }

    public OptionsConfiguration getCommandLineConfiguration() {
        return this.commandLineConfiguration;
    }

    public void setCommandLineConfiguration(OptionsConfiguration commandLineConfiguration) {
        this.commandLineConfiguration = commandLineConfiguration;
    }

    public String getOutputFile(Item item, MakeConfiguration conf, boolean expanded) {
        int i;
        String filePath;
        String fileName = filePath = item.getPath(true);
        String suffix = ".o";
        boolean append = false;
        if (item.hasHeaderOrSourceExtension(false, false)) {
            AbstractCompiler compiler;
            suffix = ".pch";
            ItemConfiguration itemConf = item.getItemConfiguration(conf);
            if (conf.getCompilerSet().getCompilerSet() != null && (compiler = (AbstractCompiler)conf.getCompilerSet().getCompilerSet().getTool((ToolKind)itemConf.getTool())) != null) {
                suffix = compiler.getDescriptor().getPrecompiledHeaderSuffix();
                append = compiler.getDescriptor().getPrecompiledHeaderSuffixAppend();
            }
        }
        fileName = (i = fileName.lastIndexOf(46)) >= 0 && !append ? fileName.substring(0, i) + suffix : fileName + suffix;
        String dirName = expanded ? ConfigurationMakefileWriter.getObjectDir(conf) : "${OBJECTDIR}";
        if (CndPathUtilitities.isPathAbsolute((String)fileName) || filePath.startsWith("..")) {
            String ofileName = CndPathUtilitities.getBaseName((String)fileName);
            String odirName = CndPathUtilitities.getDirName((String)fileName);
            String absPath = dirName + '/' + "_ext" + '/' + Math.abs(odirName.hashCode()) + '/' + ofileName;
            absPath = CndPathUtilitities.replaceOddCharacters((String)absPath, (char)'_');
            return absPath;
        }
        fileName = CndPathUtilitities.escapeOddCharacters((String)fileName);
        return dirName + '/' + fileName;
    }

    protected void assign(BasicCompilerConfiguration conf) {
        this.setBaseDir(conf.getBaseDir());
        this.getDevelopmentMode().assign(conf.getDevelopmentMode());
        this.getWarningLevel().assign(conf.getWarningLevel());
        this.getSixtyfourBits().assign(conf.getSixtyfourBits());
        this.getStrip().assign(conf.getStrip());
        this.getMTLevel().assign(conf.getMTLevel());
        this.getAdditionalDependencies().assign(conf.getAdditionalDependencies());
        this.getTool().assign(conf.getTool());
        this.getCommandLineConfiguration().assign(conf.getCommandLineConfiguration());
    }

    protected Sheet.Set getBasicSet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("BasicOptions");
        set.setDisplayName(BasicCompilerConfiguration.getString("BasicOptionsTxt"));
        set.setShortDescription(BasicCompilerConfiguration.getString("BasicOptionsHint"));
        set.put((Node.Property)new IntNodeProp(this.getDevelopmentMode(), true, "DevelopmentMode", BasicCompilerConfiguration.getString("DevelopmentModeTxt"), BasicCompilerConfiguration.getString("DevelopmentModeHint")));
        set.put((Node.Property)new IntNodeProp(this.getWarningLevel(), true, "WarningLevel", BasicCompilerConfiguration.getString("WarningLevelTxt"), BasicCompilerConfiguration.getString("WarningLevelHint")));
        set.put((Node.Property)new IntNodeProp(this.getSixtyfourBits(), true, "64BitArchitecture", BasicCompilerConfiguration.getString("64BitArchitectureTxt"), BasicCompilerConfiguration.getString("64BitArchitectureHint")));
        set.put((Node.Property)new BooleanNodeProp(this.getStrip(), true, "StripSymbols", BasicCompilerConfiguration.getString("StripSymbolsTxt"), BasicCompilerConfiguration.getString("StripSymbolsHint")));
        return set;
    }

    protected Sheet.Set getInputSet() {
        Sheet.Set set = new Sheet.Set();
        set.setName("Input");
        set.setDisplayName(BasicCompilerConfiguration.getString("InputTxt"));
        set.setShortDescription(BasicCompilerConfiguration.getString("InputHint"));
        set.put((Node.Property)new StringNodeProp(this.getAdditionalDependencies(), "AdditionalDependencies", BasicCompilerConfiguration.getString("AdditionalDependenciesTxt1"), BasicCompilerConfiguration.getString("AdditionalDependenciesHint")));
        return set;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(BasicCompilerConfiguration.class, (String)s);
    }
}

