/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.rake;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RakeTask
implements Comparable<RakeTask> {
    private static final Pattern EXPLICIT_PARAMS = Pattern.compile("(\\w+)\\[.+\\]");
    private final String task;
    private final String description;
    private final String displayName;
    private final List<String> taskParameters = new ArrayList<String>();
    private final List<String> rakeParameters = new ArrayList<String>();
    private Set<RakeTask> children;

    public static RakeTask newNameSpace(String displayName) {
        return new RakeTask(null, displayName, null);
    }

    public RakeTask(String task, String name, String description) {
        this.task = task;
        this.displayName = name;
        this.description = description;
    }

    boolean isNameSpace() {
        return this.task == null;
    }

    public void addRakeParameters(String ... params) {
        for (String param : params) {
            this.rakeParameters.add(param);
        }
    }

    public void addTaskParameters(String ... params) {
        for (String param : params) {
            this.taskParameters.add(param);
        }
    }

    List<String> getTaskParameters() {
        return this.taskParameters;
    }

    List<String> getRakeParameters() {
        return this.rakeParameters;
    }

    boolean acceptsExplicitParameters() {
        return EXPLICIT_PARAMS.matcher(this.displayName).matches();
    }

    public String getTask() {
        Matcher matcher = EXPLICIT_PARAMS.matcher(this.task);
        return matcher.matches() ? matcher.group(1) : this.task;
    }

    public Set<RakeTask> getChildren() {
        return this.children;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void addChild(RakeTask child) {
        if (this.children == null) {
            this.children = new TreeSet<RakeTask>();
        }
        this.children.add(child);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RakeTask other = (RakeTask)obj;
        return this.task == other.task || this.task != null && this.task.equals(other.task);
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.task != null ? this.task.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RakeTask o) {
        if (this.isNameSpace() && !o.isNameSpace()) {
            return -1;
        }
        if (!this.isNameSpace() && o.isNameSpace()) {
            return 1;
        }
        if (this.task == null || o.getTask() == null) {
            assert (this.displayName != null) : "displayName not null";
            assert (o.getDisplayName() != null) : "other displayName not null";
            return this.displayName.compareTo(o.getDisplayName());
        }
        return this.getTask().compareTo(o.getTask());
    }

    public String toString() {
        return "RakeTask[task: " + this.getTask() + ", displayName: " + this.getDisplayName() + ", description: " + this.getDescription() + ']';
    }
}

