/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LNE;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LNS;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfLineInfoSection
extends ElfSection {
    private HashMap<Long, DwarfStatementList> statementLists = new HashMap();

    public DwarfLineInfoSection(DwarfReader reader, int sectionIdx) {
        super(reader, sectionIdx);
    }

    public DwarfStatementList getStatementList(long offset) {
        Long lOffset = offset;
        DwarfStatementList statementList = this.statementLists.get(lOffset);
        if (statementList == null) {
            try {
                statementList = this.readStatementList(offset);
                this.statementLists.put(lOffset, statementList);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return statementList;
    }

    private DwarfStatementList readStatementList(long offset) throws IOException {
        this.reader.seek(this.header.getSectionOffset() + offset);
        DwarfStatementList stmt_list = new DwarfStatementList(offset);
        stmt_list.total_length = this.reader.readDWlen();
        stmt_list.version = this.reader.readShort();
        stmt_list.prologue_length = this.reader.read3264();
        stmt_list.minimum_instruction_length = this.reader.readByte();
        stmt_list.default_is_stmt = this.reader.readByte();
        stmt_list.line_base = this.reader.readByte();
        stmt_list.line_range = this.reader.readByte();
        stmt_list.opcode_base = this.reader.readByte();
        stmt_list.standard_opcode_lengths = new long[stmt_list.opcode_base - 1];
        for (int i = 0; i < stmt_list.opcode_base - 1; ++i) {
            stmt_list.standard_opcode_lengths[i] = this.reader.readUnsignedLEB128();
        }
        String dirname = this.reader.readString();
        while (dirname.length() > 0) {
            stmt_list.includeDirs.add(dirname);
            dirname = this.reader.readString();
        }
        String fname = this.reader.readString();
        while (fname.length() > 0) {
            stmt_list.fileEntries.add(new FileEntry(fname, this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128(), this.reader.readUnsignedLEB128()));
            fname = this.reader.readString();
        }
        return stmt_list;
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        for (DwarfStatementList statementList : this.statementLists.values()) {
            statementList.dump(out);
        }
    }

    @Override
    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineNumber getLineNumber(long shift, long target) throws IOException {
        long currPos = this.reader.getFilePointer();
        try {
            DwarfStatementList statementList = this.getStatementList(shift);
            this.reader.seek(this.header.getSectionOffset() + shift + statementList.prologue_length + (long)(this.reader.is32Bit() ? 10 : 22));
            LineNumber lineNumber = this.interpret(target, statementList, shift);
            return lineNumber;
        }
        finally {
            this.reader.seek(currPos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LineNumber> getLineNumbers(long shift) throws IOException {
        long currPos = this.reader.getFilePointer();
        try {
            DwarfStatementList statementList = this.getStatementList(shift);
            this.reader.seek(this.header.getSectionOffset() + shift + statementList.prologue_length + (long)(this.reader.is32Bit() ? 10 : 22));
            Set<LineNumber> set = this.interpret(statementList, shift);
            return set;
        }
        finally {
            this.reader.seek(currPos);
        }
    }

    private Set<LineNumber> interpret(DwarfStatementList section, long shift) throws IOException {
        long address = 0L;
        long base_address = 0L;
        long prev_base_address = 0L;
        String define_file = null;
        int fileno = 0;
        int lineno = 1;
        int prev_fileno = 0;
        int prev_lineno = 1;
        int const_pc_add = 245 / section.line_range * section.minimum_instruction_length;
        int lineNumber = -1;
        String sourceFile = null;
        HashSet<LineNumber> result = new HashSet<LineNumber>();
        while (this.reader.getFilePointer() < this.header.getSectionOffset() + shift + section.total_length) {
            int opcode = this.reader.readByte() & 0xFF;
            if (opcode < section.opcode_base) {
                block0 : switch (LNS.get(opcode)) {
                    case DW_LNS_extended_op: {
                        int insn_len = this.reader.readUnsignedLEB128();
                        opcode = this.reader.readByte();
                        switch (LNE.get(opcode)) {
                            case DW_LNE_end_sequence: {
                                lineNumber = prev_lineno;
                                String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
                                if (sourceFile != null) {
                                    result.add(new LineNumber(sourceFile, lineNumber, prev_base_address, address));
                                }
                                lineno = 1;
                                prev_lineno = 1;
                                fileno = 0;
                                prev_fileno = 0;
                                address = 0L;
                                base_address = 0L;
                                break block0;
                            }
                            case DW_LNE_set_address: {
                                prev_base_address = base_address;
                                if (insn_len == 9) {
                                    base_address = this.reader.readNumber(8);
                                } else if (insn_len == 5) {
                                    base_address = this.reader.readNumber(4);
                                }
                                address = base_address;
                                if (prev_base_address != 0L) break block0;
                                prev_base_address = base_address;
                                break block0;
                            }
                            case DW_LNE_define_file: {
                                define_file = this.reader.readString();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                break block0;
                            }
                        }
                        this.reader.seek(this.reader.getFilePointer() + (long)insn_len);
                        break;
                    }
                    case DW_LNS_copy: {
                        lineNumber = prev_lineno == 1 ? lineno : prev_lineno;
                        String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
                        if (sourceFile != null) {
                            result.add(new LineNumber(sourceFile, lineNumber, prev_base_address, address));
                        }
                        prev_lineno = lineno;
                        prev_fileno = fileno;
                        break;
                    }
                    case DW_LNS_advance_pc: {
                        long amt = this.reader.readUnsignedLEB128();
                        address += amt * (long)section.minimum_instruction_length;
                        break;
                    }
                    case DW_LNS_advance_line: {
                        long amt = this.reader.readSignedLEB128();
                        prev_lineno = lineno;
                        lineno += (int)amt;
                        break;
                    }
                    case DW_LNS_set_file: {
                        prev_fileno = fileno;
                        fileno = this.reader.readUnsignedLEB128() - 1;
                        break;
                    }
                    case DW_LNS_set_column: {
                        this.reader.readUnsignedLEB128();
                        break;
                    }
                    case DW_LNS_negate_stmt: {
                        break;
                    }
                    case DW_LNS_set_basic_block: {
                        break;
                    }
                    case DW_LNS_const_add_pc: {
                        address += (long)const_pc_add;
                        break;
                    }
                    case DW_LNS_fixed_advance_pc: {
                        int amt = this.reader.readShort() & 0xFFFF;
                        address += (long)amt;
                    }
                }
                continue;
            }
            int adj = (opcode & 0xFF) - section.opcode_base;
            int addr_adv = adj / section.line_range * section.minimum_instruction_length;
            int line_adv = section.line_base + adj % section.line_range;
            long new_addr = address + (long)addr_adv;
            int new_line = lineno + line_adv;
            String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
            if (sourceFile != null) {
                result.add(new LineNumber(sourceFile, lineno, prev_base_address, new_addr));
            }
            prev_lineno = lineno;
            prev_fileno = fileno;
            lineno = new_line;
            address = new_addr;
        }
        return result;
    }

    private LineNumber interpret(long target, DwarfStatementList section, long shift) throws IOException {
        long address = 0L;
        long base_address = 0L;
        long prev_base_address = 0L;
        String define_file = null;
        int fileno = 0;
        int lineno = 1;
        int prev_fileno = 0;
        int prev_lineno = 1;
        int const_pc_add = 245 / section.line_range * section.minimum_instruction_length;
        int lineNumber = -1;
        String sourceFile = null;
        while (this.reader.getFilePointer() < this.header.getSectionOffset() + shift + section.total_length) {
            int opcode = this.reader.readByte() & 0xFF;
            if (opcode < section.opcode_base) {
                block0 : switch (LNS.get(opcode)) {
                    case DW_LNS_extended_op: {
                        int insn_len = this.reader.readUnsignedLEB128();
                        opcode = this.reader.readByte();
                        switch (LNE.get(opcode)) {
                            case DW_LNE_end_sequence: {
                                if (prev_base_address <= target && address > target) {
                                    lineNumber = prev_lineno;
                                    String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
                                    if (sourceFile != null) {
                                        return new LineNumber(sourceFile, lineNumber, prev_base_address, address);
                                    }
                                }
                                lineno = 1;
                                prev_lineno = 1;
                                fileno = 0;
                                prev_fileno = 0;
                                address = 0L;
                                base_address = 0L;
                                break block0;
                            }
                            case DW_LNE_set_address: {
                                prev_base_address = base_address;
                                if (insn_len == 9) {
                                    base_address = this.reader.readNumber(8);
                                } else if (insn_len == 5) {
                                    base_address = this.reader.readNumber(4);
                                }
                                address = base_address;
                                if (prev_base_address != 0L) break block0;
                                prev_base_address = base_address;
                                break block0;
                            }
                            case DW_LNE_define_file: {
                                define_file = this.reader.readString();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                this.reader.readUnsignedLEB128();
                                break block0;
                            }
                        }
                        this.reader.seek(this.reader.getFilePointer() + (long)insn_len);
                        break;
                    }
                    case DW_LNS_copy: {
                        if (prev_base_address <= target && address > target) {
                            lineNumber = prev_lineno == 1 ? lineno : prev_lineno;
                            String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
                            if (sourceFile != null) {
                                return new LineNumber(sourceFile, lineNumber, prev_base_address, address);
                            }
                        }
                        prev_lineno = lineno;
                        prev_fileno = fileno;
                        break;
                    }
                    case DW_LNS_advance_pc: {
                        long amt = this.reader.readUnsignedLEB128();
                        address += amt * (long)section.minimum_instruction_length;
                        break;
                    }
                    case DW_LNS_advance_line: {
                        long amt = this.reader.readSignedLEB128();
                        prev_lineno = lineno;
                        lineno += (int)amt;
                        break;
                    }
                    case DW_LNS_set_file: {
                        prev_fileno = fileno;
                        fileno = this.reader.readUnsignedLEB128() - 1;
                        break;
                    }
                    case DW_LNS_set_column: {
                        this.reader.readUnsignedLEB128();
                        break;
                    }
                    case DW_LNS_negate_stmt: {
                        break;
                    }
                    case DW_LNS_set_basic_block: {
                        break;
                    }
                    case DW_LNS_const_add_pc: {
                        address += (long)const_pc_add;
                        break;
                    }
                    case DW_LNS_fixed_advance_pc: {
                        int amt = this.reader.readShort() & 0xFFFF;
                        address += (long)amt;
                    }
                }
                continue;
            }
            int adj = (opcode & 0xFF) - section.opcode_base;
            int addr_adv = adj / section.line_range * section.minimum_instruction_length;
            int line_adv = section.line_base + adj % section.line_range;
            long new_addr = address + (long)addr_adv;
            int new_line = lineno + line_adv;
            if (prev_base_address <= target && new_addr >= target) {
                lineNumber = new_addr == target ? new_line : lineno;
                String string = sourceFile = prev_fileno >= 0 && prev_fileno + 1 < section.getFileEntries().size() ? section.getFilePath(prev_fileno + 1) : define_file;
                if (sourceFile != null) {
                    return new LineNumber(sourceFile, lineNumber, prev_base_address, new_addr);
                }
            }
            prev_lineno = lineno;
            prev_fileno = fileno;
            lineno = new_line;
            address = new_addr;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LineNumber
    implements Comparable<LineNumber> {
        public final String file;
        public final int line;
        public final long startOffset;
        public final long endOffset;

        private LineNumber(String file, int line, long startOffset, long endOffset) {
            assert (file != null);
            this.file = file;
            this.line = line;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LineNumber) {
                LineNumber other = (LineNumber)obj;
                return this.file.equals(other.file) && this.line == other.line;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 67 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 67 * hash + this.line;
            return hash;
        }

        public String toString() {
            return this.file + ":" + this.line + "\t(0x" + Long.toHexString(this.startOffset) + "-0x" + Long.toHexString(this.endOffset) + ")";
        }

        @Override
        public int compareTo(LineNumber o) {
            int res = this.file.compareTo(o.file);
            if (res == 0) {
                res = this.line - o.line;
            }
            return res;
        }
    }
}

