/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.csl.api.DataLoadersBridge;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModelFactory;
import org.netbeans.modules.web.beans.api.model.support.WebBeansModelSupport;
import org.netbeans.modules.web.jsf.editor.JsfHtmlExtension;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptorCache;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.index.JsfIndex;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.tld.TldLibrariesCache;
import org.netbeans.modules.web.jsf.editor.tld.TldLibrary;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfSupport {
    private static Logger LOGGER = Logger.getLogger("JsfSupport");
    private static final WeakHashMap<WebModule, JsfSupport> INSTANCIES;
    private TldLibrariesCache tldLibrariesCache;
    private FaceletsLibraryDescriptorCache faceletsDescriptorsCache;
    private FaceletsLibrarySupport faceletsLibrarySupport;
    private WebModule wm;
    private ClassPath classpath;
    private JsfIndex index;
    private MetadataModel<WebBeansModel> webBeansModel;

    public static JsfSupport findFor(Source source) {
        FileObject fileObject = source.getFileObject();
        if (fileObject == null) {
            return null;
        }
        return JsfSupport.findFor(fileObject);
    }

    public static JsfSupport findFor(Document document) {
        return JsfSupport.findFor(DataLoadersBridge.getDefault().getFileObject(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsfSupport findFor(FileObject fileObject) {
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/compile");
        if (classPath == null) {
            return null;
        }
        WeakHashMap<WebModule, JsfSupport> weakHashMap = INSTANCIES;
        synchronized (weakHashMap) {
            JsfSupport jsfSupport = INSTANCIES.get(webModule);
            if (jsfSupport == null) {
                jsfSupport = new JsfSupport(webModule, classPath);
                INSTANCIES.put(webModule, jsfSupport);
            }
            return jsfSupport;
        }
    }

    private JsfSupport(WebModule webModule, ClassPath classPath) {
        assert (webModule != null);
        this.wm = webModule;
        this.classpath = classPath;
        this.tldLibrariesCache = new TldLibrariesCache(this);
        this.faceletsDescriptorsCache = new FaceletsLibraryDescriptorCache(this);
        this.faceletsLibrarySupport = new FaceletsLibrarySupport(this);
        this.classpath.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JsfSupport jsfSupport = JsfSupport.this;
                synchronized (jsfSupport) {
                    JsfSupport.this.index = null;
                }
                JsfSupport.this.tldLibrariesCache.clearCache();
                JsfSupport.this.faceletsDescriptorsCache.clearCache();
            }
        });
        JsfHtmlExtension.activate();
    }

    public ClassPath getClassPath() {
        return this.classpath;
    }

    public WebModule getWebModule() {
        return this.wm;
    }

    public String toString() {
        return this.wm.getDocumentBase().toString();
    }

    public TldLibrary getTldLibrary(String string) {
        try {
            return this.tldLibrariesCache.getLibrary(string);
        }
        catch (LibraryDescriptorException libraryDescriptorException) {
            Exceptions.printStackTrace((Throwable)libraryDescriptorException);
            return null;
        }
    }

    public FaceletsLibraryDescriptor getFaceletsLibraryDescriptor(String string) {
        try {
            return this.faceletsDescriptorsCache.getLibrary(string);
        }
        catch (LibraryDescriptorException libraryDescriptorException) {
            Exceptions.printStackTrace((Throwable)libraryDescriptorException);
            return null;
        }
    }

    public LibraryDescriptor getLibraryDescriptor(String string) {
        FaceletsLibraryDescriptor faceletsLibraryDescriptor = this.getFaceletsLibraryDescriptor(string);
        return faceletsLibraryDescriptor != null ? faceletsLibraryDescriptor : this.getTldLibrary(string);
    }

    public Map<String, FaceletsLibrary> getFaceletsLibraries() {
        return this.faceletsLibrarySupport.getLibraries();
    }

    public synchronized JsfIndex getIndex() {
        if (this.index == null) {
            this.index = JsfIndex.create(this.wm);
        }
        return this.index;
    }

    public FaceletsLibrarySupport getFaceletsLibrarySupport() {
        return this.faceletsLibrarySupport;
    }

    public synchronized MetadataModel<WebBeansModel> getWebBeansModel() {
        if (this.webBeansModel == null) {
            ModelUnit modelUnit = WebBeansModelSupport.getModelUnit((WebModule)this.getWebModule());
            this.webBeansModel = WebBeansModelFactory.getMetaModel((ModelUnit)modelUnit);
        }
        return this.webBeansModel;
    }

    static {
        LOGGER.setLevel(Level.ALL);
        INSTANCIES = new WeakHashMap();
    }
}

