/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.UpdateType;
import org.openide.filesystems.FileObject;

public class EntityClass {
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final FileObject rootFolder;
    private final String className;
    private final String packageName;
    private final Set<List<String>> uniqueConstraints;
    private final UpdateType updateType;
    private List<RelationshipRole> roles;
    private List<EntityMember> fields;
    private boolean usePkField;
    private String pkFieldName;
    private CMPMappingModel mappingModel;
    private boolean forTable = true;

    public EntityClass(String string, String string2, String string3, FileObject fileObject, String string4, String string5, UpdateType updateType, Set<List<String>> set) {
        this.catalogName = string;
        this.schemaName = string2;
        this.tableName = string3;
        this.rootFolder = fileObject;
        this.packageName = string4;
        this.className = string5;
        this.updateType = updateType;
        this.uniqueConstraints = set;
        this.roles = Collections.emptyList();
        this.fields = new ArrayList<EntityMember>();
        this.mappingModel = new CMPMappingModel();
    }

    public boolean isForTable() {
        return this.forTable;
    }

    public void setIsForTable(boolean bl) {
        this.forTable = bl;
    }

    public Set<List<String>> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public void addRole(RelationshipRole relationshipRole) {
        if (this.roles == Collections.emptyList()) {
            this.roles = new ArrayList<RelationshipRole>();
        }
        this.roles.add(relationshipRole);
    }

    public List<RelationshipRole> getRoles() {
        return this.roles;
    }

    public List<EntityMember> getFields() {
        return this.fields;
    }

    public void setFields(List<EntityMember> list) {
        this.fields = list;
    }

    public String toString() {
        String string = "";
        for (EntityMember entityMember : this.getFields()) {
            string = string + " " + entityMember.getMemberName() + (entityMember.isPrimaryKey() ? " (PK) " : " ");
        }
        return "bean name " + this.getClassName() + "\ncmp-fields " + string;
    }

    public FileObject getRootFolder() {
        return this.rootFolder;
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getClassName() {
        return this.className;
    }

    public UpdateType getUpdateType() {
        return this.updateType;
    }

    public FileObject getPackageFileObject() {
        String string = this.packageName.replace('.', '/');
        return this.rootFolder.getFileObject(string);
    }

    public CMPMappingModel getCMPMapping() {
        this.mappingModel.getCMPFieldMapping().clear();
        for (EntityMember entityMember : this.getFields()) {
            this.mappingModel.setTableName(entityMember.getTableName());
            this.mappingModel.getCMPFieldMapping().put(entityMember.getMemberName(), entityMember.getColumnName());
        }
        return this.mappingModel;
    }

    public void usePkField(boolean bl) {
        this.usePkField = bl;
    }

    public boolean isUsePkField() {
        return this.usePkField;
    }

    public String getPkFieldName() {
        return this.pkFieldName;
    }

    public void setPkFieldName(String string) {
        this.pkFieldName = string;
    }
}

