/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationInfo;

public class ArithmeticUtilities {
    public static Number compute(CompilationInfo compilationInfo, TreePath treePath, boolean bl) {
        return new VisitorImpl(compilationInfo, bl).scan(treePath, null);
    }

    private static final class VisitorImpl
    extends TreePathScanner<Number, Void> {
        private static final Set<Tree.Kind> ACCEPTED_KINDS = EnumSet.of(Tree.Kind.MULTIPLY, new Tree.Kind[]{Tree.Kind.DIVIDE, Tree.Kind.REMAINDER, Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.LEFT_SHIFT, Tree.Kind.RIGHT_SHIFT, Tree.Kind.UNSIGNED_RIGHT_SHIFT, Tree.Kind.AND, Tree.Kind.XOR, Tree.Kind.OR, Tree.Kind.UNARY_MINUS, Tree.Kind.UNARY_PLUS, Tree.Kind.PARENTHESIZED, Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL});
        private final CompilationInfo info;
        private final boolean resolveCompileTimeConstants;

        public VisitorImpl(CompilationInfo compilationInfo, boolean bl) {
            this.info = compilationInfo;
            this.resolveCompileTimeConstants = bl;
        }

        @Override
        public Number scan(TreePath treePath, Void void_) {
            if (!ACCEPTED_KINDS.contains((Object)treePath.getLeaf().getKind())) {
                return null;
            }
            return (Number)super.scan(treePath, void_);
        }

        @Override
        public Number scan(Tree tree, Void void_) {
            if (tree == null) {
                return null;
            }
            if (!ACCEPTED_KINDS.contains((Object)tree.getKind())) {
                return null;
            }
            return (Number)super.scan(tree, void_);
        }

        @Override
        public Number visitLiteral(LiteralTree literalTree, Void void_) {
            if (literalTree.getValue() instanceof Number) {
                return (Number)literalTree.getValue();
            }
            return (Number)super.visitLiteral(literalTree, void_);
        }

        @Override
        public Number visitIdentifier(IdentifierTree identifierTree, Void void_) {
            return this.resolve();
        }

        @Override
        public Number visitMemberSelect(MemberSelectTree memberSelectTree, Void void_) {
            return this.resolve();
        }

        private Number resolve() {
            if (!this.resolveCompileTimeConstants) {
                return null;
            }
            Element element = this.info.getTrees().getElement(this.getCurrentPath());
            if (element == null || element.getKind() != ElementKind.FIELD) {
                return null;
            }
            Object object = ((VariableElement)element).getConstantValue();
            if (!(object instanceof Number)) {
                return null;
            }
            return (Number)object;
        }

        @Override
        public Number visitBinary(BinaryTree binaryTree, Void void_) {
            Number number = this.scan((Tree)binaryTree.getLeftOperand(), void_);
            Number number2 = this.scan((Tree)binaryTree.getRightOperand(), void_);
            if (number != null && number2 != null) {
                Number number3 = null;
                switch (binaryTree.getKind()) {
                    case MULTIPLY: {
                        if (number instanceof Double || number2 instanceof Double) {
                            number3 = number.doubleValue() * number2.doubleValue();
                            break;
                        }
                        if (number instanceof Float || number2 instanceof Float) {
                            number3 = Float.valueOf(number.floatValue() * number2.floatValue());
                            break;
                        }
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() * number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() * number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case DIVIDE: {
                        if (number instanceof Double || number2 instanceof Double) {
                            number3 = number.doubleValue() / number2.doubleValue();
                            break;
                        }
                        if (number instanceof Float || number2 instanceof Float) {
                            number3 = Float.valueOf(number.floatValue() / number2.floatValue());
                            break;
                        }
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() / number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() / number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case REMAINDER: {
                        if (number instanceof Double || number2 instanceof Double) {
                            number3 = number.doubleValue() % number2.doubleValue();
                            break;
                        }
                        if (number instanceof Float || number2 instanceof Float) {
                            number3 = Float.valueOf(number.floatValue() % number2.floatValue());
                            break;
                        }
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() % number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() % number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case PLUS: {
                        if (number instanceof Double || number2 instanceof Double) {
                            number3 = number.doubleValue() + number2.doubleValue();
                            break;
                        }
                        if (number instanceof Float || number2 instanceof Float) {
                            number3 = Float.valueOf(number.floatValue() + number2.floatValue());
                            break;
                        }
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() + number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() + number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case MINUS: {
                        if (number instanceof Double || number2 instanceof Double) {
                            number3 = number.doubleValue() - number2.doubleValue();
                            break;
                        }
                        if (number instanceof Float || number2 instanceof Float) {
                            number3 = Float.valueOf(number.floatValue() - number2.floatValue());
                            break;
                        }
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() - number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() - number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case LEFT_SHIFT: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() << (int)number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() << number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case RIGHT_SHIFT: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() >> (int)number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() >> number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case UNSIGNED_RIGHT_SHIFT: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() >>> (int)number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() >>> number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case AND: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() & number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() & number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case XOR: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() ^ number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() ^ number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                    case OR: {
                        if (number instanceof Long || number2 instanceof Long) {
                            number3 = number.longValue() | number2.longValue();
                            break;
                        }
                        if (VisitorImpl.integerLike(number) || VisitorImpl.integerLike(number2)) {
                            number3 = number.intValue() | number2.intValue();
                            break;
                        }
                        throw new IllegalStateException("left=" + number.getClass() + ", right=" + number2.getClass());
                    }
                }
                return number3;
            }
            return null;
        }

        @Override
        public Number visitUnary(UnaryTree unaryTree, Void void_) {
            Number number = this.scan((Tree)unaryTree.getExpression(), void_);
            if (number != null) {
                Number number2 = null;
                switch (unaryTree.getKind()) {
                    case UNARY_MINUS: {
                        if (number instanceof Double) {
                            number2 = -number.doubleValue();
                            break;
                        }
                        if (number instanceof Float) {
                            number2 = Float.valueOf(-number.floatValue());
                            break;
                        }
                        if (number instanceof Long) {
                            number2 = -number.longValue();
                            break;
                        }
                        if (number instanceof Integer) {
                            number2 = -number.intValue();
                            break;
                        }
                        throw new IllegalStateException("op=" + number.getClass());
                    }
                    case UNARY_PLUS: {
                        number2 = number;
                    }
                }
                return number2;
            }
            return (Number)super.visitUnary(unaryTree, void_);
        }

        private static boolean integerLike(Number number) {
            return number instanceof Integer || number instanceof Short || number instanceof Byte;
        }
    }
}

