/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.projectimport.eclipse.core.EclipseProject;
import org.netbeans.modules.projectimport.eclipse.core.EclipseUtils;
import org.netbeans.modules.projectimport.eclipse.core.JavaPlatformSupport;
import org.netbeans.modules.projectimport.eclipse.core.ProjectFactory;
import org.netbeans.modules.projectimport.eclipse.core.ProjectImporterException;
import org.netbeans.modules.projectimport.eclipse.core.Workspace;
import org.netbeans.modules.projectimport.eclipse.core.WorkspaceFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectImportModel;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeFactory;
import org.netbeans.modules.projectimport.eclipse.core.spi.ProjectTypeUpdater;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class EclipseProjectReference {
    private Project project;
    private final File eclipseProjectLocation;
    private final File eclipseWorkspaceLocation;
    private long timestamp;
    private String key;
    private boolean initialized;
    private EclipseProject eclipseProject;
    private ProjectImportModel importModel;
    private static final String PROJECT_PREFIX = "project-";
    private static final String WORKSPACE_PREFIX = "workspace-";

    public EclipseProjectReference(Project project, String eclipseProjectLocation, String eclipseWorkspaceLocation, long timestamp, String key) {
        this.eclipseProjectLocation = PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)eclipseProjectLocation);
        this.eclipseWorkspaceLocation = eclipseWorkspaceLocation != null ? PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)eclipseWorkspaceLocation) : null;
        this.timestamp = timestamp;
        this.key = key;
        this.project = project;
    }

    Project getProject() {
        return this.project;
    }

    public File getEclipseProjectLocation() {
        return this.eclipseProjectLocation;
    }

    public File getEclipseWorkspaceLocation() {
        return this.eclipseWorkspaceLocation;
    }

    File getFallbackEclipseProjectLocation() {
        String path = EclipseProjectReference.getPreferences().get(PROJECT_PREFIX + this.getEclipseProjectLocation().getPath(), null);
        if (path != null) {
            return new File(path);
        }
        return this.getEclipseProjectLocation();
    }

    File getFallbackWorkspaceProjectLocation() {
        if (this.eclipseWorkspaceLocation == null) {
            return null;
        }
        String path = EclipseProjectReference.getPreferences().get(WORKSPACE_PREFIX + this.getEclipseWorkspaceLocation().getPath(), null);
        if (path != null) {
            return FileUtil.normalizeFile((File)new File(path));
        }
        return this.getEclipseWorkspaceLocation();
    }

    void updateReference(String eclipseLocation, String eclipseWorkspace) {
        if (eclipseLocation != null) {
            EclipseProjectReference.getPreferences().put(PROJECT_PREFIX + this.getEclipseProjectLocation().getPath(), eclipseLocation);
        }
        if (eclipseWorkspace != null) {
            EclipseProjectReference.getPreferences().put(WORKSPACE_PREFIX + this.getEclipseWorkspaceLocation().getPath(), eclipseWorkspace);
        }
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(EclipseProjectReference.class);
    }

    public static EclipseProjectReference read(Project project) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, EclipseProjectReference.class, (boolean)true);
        String projectLoc = prefs.get("project", null);
        if (projectLoc == null) {
            return null;
        }
        return new EclipseProjectReference(project, projectLoc, prefs.get("workspace", null), Long.parseLong(prefs.get("timestamp", null)), prefs.get("key", null));
    }

    public static void write(Project project, EclipseProjectReference ref) {
        Preferences prefs = ProjectUtils.getPreferences((Project)project, EclipseProjectReference.class, (boolean)true);
        File baseDir = FileUtil.toFile((FileObject)project.getProjectDirectory());
        if (CollocationQuery.areCollocated((File)baseDir, (File)ref.eclipseProjectLocation)) {
            prefs.put("project", PropertyUtils.relativizeFile((File)baseDir, (File)ref.eclipseProjectLocation));
        } else {
            prefs.put("project", ref.eclipseProjectLocation.getPath());
        }
        if (ref.eclipseWorkspaceLocation != null) {
            if (CollocationQuery.areCollocated((File)baseDir, (File)ref.eclipseWorkspaceLocation)) {
                prefs.put("workspace", PropertyUtils.relativizeFile((File)baseDir, (File)ref.eclipseWorkspaceLocation));
            } else {
                prefs.put("workspace", ref.eclipseWorkspaceLocation.getPath());
            }
        }
        prefs.put("timestamp", Long.toString(ref.getCurrentTimestamp()));
        prefs.put("key", ref.key);
    }

    public boolean isUpToDate(boolean deepTest) {
        if (this.getCurrentTimestamp() > this.timestamp) {
            return false;
        }
        if (!deepTest) {
            return true;
        }
        EclipseProject ep = this.getEclipseProject(true);
        if (ep == null) {
            return true;
        }
        if (!(ep.getProjectTypeFactory() instanceof ProjectTypeUpdater)) assert (false) : "project with <eclipse> data in project.xml is upgradable: " + this.project.getProjectDirectory() + " " + ep.getProjectTypeFactory().getClass().getName();
        ProjectTypeUpdater updater = (ProjectTypeUpdater)ep.getProjectTypeFactory();
        return this.key.equals(updater.calculateKey(this.importModel));
    }

    void update(List<String> importProblems) throws IOException {
        EclipseProject ep = this.getEclipseProject(true);
        if (ep == null) {
            return;
        }
        ProjectTypeFactory factory = ep.getProjectTypeFactory();
        if (!(factory instanceof ProjectTypeUpdater)) {
            assert (false) : "project with <eclipse> data in project.xml is upgradable";
            return;
        }
        ep.resolveContainers(importProblems, true);
        ep.setupEnvironmentVariables(importProblems);
        this.key = ((ProjectTypeUpdater)factory).update(this.project, this.importModel, this.key, importProblems);
        EclipseProjectReference.write(this.project, this);
    }

    private long getCurrentTimestamp() {
        File dotClasspath = new File(this.getFallbackEclipseProjectLocation(), ".classpath");
        File dotProject = new File(this.getFallbackEclipseProjectLocation(), ".project");
        return Math.max(dotClasspath.lastModified(), dotProject.lastModified());
    }

    boolean isEclipseProjectReachable() {
        boolean b;
        boolean bl = b = EclipseUtils.isRegularProject(this.eclipseProjectLocation) && (this.eclipseWorkspaceLocation == null || this.eclipseWorkspaceLocation != null && EclipseUtils.isRegularWorkSpace(this.eclipseWorkspaceLocation));
        if (b) {
            EclipseProjectReference.getPreferences().remove(PROJECT_PREFIX + this.eclipseProjectLocation.getPath());
            if (this.eclipseWorkspaceLocation != null) {
                EclipseProjectReference.getPreferences().remove(WORKSPACE_PREFIX + this.eclipseWorkspaceLocation.getPath());
            }
            return true;
        }
        return EclipseUtils.isRegularProject(this.getFallbackEclipseProjectLocation()) && (this.eclipseWorkspaceLocation == null || this.eclipseWorkspaceLocation != null && EclipseUtils.isRegularWorkSpace(this.getFallbackWorkspaceProjectLocation()));
    }

    public EclipseProject getEclipseProject(boolean forceReload) {
        if (forceReload || !this.initialized) {
            try {
                EclipseProject ep = null;
                if (this.getFallbackWorkspaceProjectLocation() != null) {
                    Workspace w = WorkspaceFactory.getInstance().load(this.getFallbackWorkspaceProjectLocation());
                    ep = w.getProjectByProjectDir(this.getFallbackEclipseProjectLocation());
                }
                if (ep == null) {
                    ep = ProjectFactory.getInstance().load(this.getFallbackEclipseProjectLocation(), this.getFallbackWorkspaceProjectLocation());
                }
                this.eclipseProject = ep;
            }
            catch (ProjectImporterException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                this.eclipseProject = null;
                this.initialized = true;
                return null;
            }
            File f = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            this.importModel = new ProjectImportModel(this.eclipseProject, f, JavaPlatformSupport.getJavaPlatformSupport().getJavaPlatform(this.eclipseProject, new ArrayList<String>()), Collections.<Project>emptyList());
            this.initialized = true;
        }
        return this.eclipseProject;
    }
}

