/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class GlobalVariable {
    protected final Ruby runtime;
    protected final String name;
    private IRubyObject value;

    public static String variableName(String name) {
        return "$" + name;
    }

    public GlobalVariable(Ruby runtime, String name, IRubyObject value) {
        assert (name.startsWith("$"));
        this.runtime = runtime;
        this.name = name;
        this.value = value;
    }

    public String name() {
        return this.name;
    }

    public IRubyObject get() {
        return this.value;
    }

    public IRubyObject set(IRubyObject value) {
        this.value = value;
        return value;
    }

    public static class Copy
    extends GlobalVariable {
        private GlobalVariable other;

        public Copy(Ruby runtime, String name, GlobalVariable other) {
            super(runtime, name, other.get());
            this.other = other;
        }

        @Override
        public IRubyObject get() {
            return this.other.get();
        }

        @Override
        public IRubyObject set(IRubyObject value) {
            return this.other.set(value);
        }
    }
}

