/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.Deprecations;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.util.NbBundle;

public class HashListConvert
extends RubyAstRule {
    @Override
    public Set<NodeType> getKinds() {
        return Collections.singleton(NodeType.HASHNODE);
    }

    @Override
    public void run(RubyRuleContext context, List<Hint> result) {
        Node node = context.node;
        ParserResult info = context.parserResult;
        HashNode hash = (HashNode)node;
        ListNode listNode = hash.getListNode();
        if (listNode == null) {
            return;
        }
        if (listNode.size() < 2) {
            return;
        }
        int commaOffset = HashListConvert.getCommaOffset(context, listNode, 0);
        if (commaOffset == -1) {
            return;
        }
        OffsetRange range = new OffsetRange(commaOffset, commaOffset + 1);
        String displayName = NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertGutter");
        List<HashFix> fixes = Collections.singletonList(new HashFix(context, listNode));
        Hint desc = new Hint((Rule)this, displayName, RubyUtils.getFileObject((Parser.Result)info), range, fixes, 140);
        result.add(desc);
    }

    private static int getCommaOffset(RubyRuleContext context, ListNode listNode, int pair) {
        int prevEnd = listNode.get(2 * pair).getPosition().getEndOffset();
        int nextStart = listNode.get(2 * pair + 1).getPosition().getStartOffset();
        if (nextStart < prevEnd) {
            return -1;
        }
        OffsetRange lexRange = LexUtilities.getLexerOffsets((Parser.Result)context.parserResult, (OffsetRange)new OffsetRange(prevEnd, nextStart));
        if (lexRange == OffsetRange.NONE) {
            return -1;
        }
        try {
            String s = context.doc.getText(lexRange.getStart(), lexRange.getLength());
            int index = s.indexOf(44);
            if (index == -1 || s.indexOf("=>") != -1) {
                return -1;
            }
            return lexRange.getStart() + index;
        }
        catch (BadLocationException ex) {
            return -1;
        }
    }

    public String getId() {
        return "HashListConvert";
    }

    public String getDescription() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvertDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public JComponent getCustomizer(Preferences node) {
        return null;
    }

    public boolean appliesTo(RuleContext context) {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(HashListConvert.class, (String)"HashListConvert");
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    private static class HashFix
    implements PreviewableFix {
        private RubyRuleContext context;
        private ListNode listNode;

        public HashFix(RubyRuleContext context, ListNode listNode) {
            this.context = context;
            this.listNode = listNode;
        }

        public String getDescription() {
            return NbBundle.getMessage(Deprecations.class, (String)"HashListConvertFix");
        }

        public void implement() throws Exception {
            this.getEditList().apply();
        }

        public EditList getEditList() throws Exception {
            BaseDocument doc = this.context.doc;
            EditList list = new EditList(doc);
            int n = this.listNode.size() / 2;
            for (int i = 0; i < n; ++i) {
                int offset = HashListConvert.getCommaOffset(this.context, this.listNode, i);
                if (offset == -1) continue;
                String s = doc.getText(offset, 3);
                StringBuilder sb = new StringBuilder();
                if (!Character.isWhitespace(doc.getText(offset - 1, 1).charAt(0))) {
                    sb.append(' ');
                }
                sb.append("=>");
                if (offset < doc.getLength() - 2 && !Character.isWhitespace(doc.getText(offset + 1, 1).charAt(0))) {
                    sb.append(' ');
                }
                list.replace(offset, 1, sb.toString(), false, 0);
            }
            return list;
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }

        public boolean canPreview() {
            return true;
        }
    }
}

