/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.introduce.ErrorLabel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceVariablePanel
extends JPanel {
    private boolean introduceConstant;
    private Set<String> takenNames;
    private JButton btnOk;
    private ButtonGroup accessGroup;
    private JLabel errorLabel;
    private JLabel lblName;
    private JTextField name;
    private JCheckBox replaceAll;

    public IntroduceVariablePanel(int numDuplicates, String defaultName, boolean introduceConstant, JButton btnOk, Set<String> takenNames) {
        this.btnOk = btnOk;
        this.takenNames = takenNames;
        this.initComponents();
        this.introduceConstant = introduceConstant;
        Preferences pref = this.getPreferences(introduceConstant);
        if (numDuplicates == 1) {
            this.replaceAll.setEnabled(false);
            this.replaceAll.setSelected(false);
        } else {
            this.replaceAll.setEnabled(true);
            this.replaceAll.setText(this.replaceAll.getText() + " (" + numDuplicates + ")");
            this.replaceAll.setSelected(pref.getBoolean("replaceAll", true));
        }
        this.replaceAll.setVisible(numDuplicates > 1);
        this.name.setText(defaultName);
        if (this.name != null && defaultName.trim().length() > 0) {
            this.name.setCaretPosition(defaultName.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(defaultName.length());
        }
    }

    private Preferences getPreferences(boolean introduceConstant) {
        return NbPreferences.forModule(IntroduceVariablePanel.class).node(introduceConstant ? "introduceConstant" : "introduceVariable");
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyIdentifier((String)text)) {
                    return IntroduceVariablePanel.this.getDefaultErrorMessage(text);
                }
                if (IntroduceVariablePanel.this.takenNames.contains(text)) {
                    return NbBundle.getMessage(IntroduceVariablePanel.class, (String)"LocalAlreadyExists", (Object)text);
                }
                return null;
            }
        };
        final ErrorLabel label = new ErrorLabel(this.name.getDocument(), validator);
        label.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceVariablePanel.this.btnOk.setEnabled(label.isInputTextValid());
            }
        });
        this.btnOk.setEnabled(label.isInputTextValid());
        return label;
    }

    String getDefaultErrorMessage(String inputText) {
        return NbBundle.getMessage(IntroduceVariablePanel.class, (String)(this.introduceConstant ? "ConstantAlreadyExists" : "NotValidIdentifier"), (Object)inputText);
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.replaceAll = new JCheckBox();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.replaceAll, (String)NbBundle.getBundle(IntroduceVariablePanel.class).getString("LBL_ReplaceAll"));
        this.replaceAll.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.errorLabel, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblName).add(18, 18, 18).add((Component)this.name, -1, 425, Short.MAX_VALUE)).add((Component)this.replaceAll)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.name, -2, -1, -2)).addPreferredGap(1).add((Component)this.replaceAll).addPreferredGap(0, 64, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Name"));
        this.replaceAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_ReplaceAllOccurences"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceVariablePanel.class, (String)"AD_IntrVar_Dialog"));
    }

    public String getVariableName() {
        return this.name.getText();
    }

    public boolean isReplaceAll() {
        boolean ret = this.replaceAll.isSelected();
        this.getPreferences(this.introduceConstant).putBoolean("replaceAll", ret);
        return ret;
    }

    void setVariableName(String name) {
        this.name.setText(name);
    }

    void setReplaceAll(boolean replaceAll) {
        this.replaceAll.setSelected(replaceAll);
    }
}

