/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.FormLoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.LoginConfig;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;

public class LoginConfigPanel
extends SectionInnerPanel {
    private static final Logger LOG = Logger.getLogger(LoginConfigPanel.class.getName());
    private static String NONE = "NONE";
    private static String BASIC = "BASIC";
    private static String DIGEST = "DIGEST";
    private static String FORM = "FORM";
    private static String CLIENT_CERT = "CLIENT-CERT";
    private WebApp webApp;
    private LoginConfig loginConfig;
    private DDDataObject dObj;
    private JRadioButton basicRB;
    private ButtonGroup buttonGroup1;
    private JRadioButton clientCertRB;
    private JRadioButton digestRB;
    private JButton errorPageBrowseButton;
    private JLabel errorPageLabel;
    private JTextField errorPageTF;
    private JRadioButton formRB;
    private JButton loginPageBrowseButton;
    private JLabel loginPageLabel;
    private JTextField loginPageTF;
    private JRadioButton noneRB;
    private JLabel realmNameLabel;
    private JTextField realmNameTF;

    public LoginConfigPanel(SectionView sectionView, DDDataObject dDDataObject) {
        super(sectionView);
        this.initComponents();
        this.dObj = dDDataObject;
        this.webApp = dDDataObject.getWebApp();
        this.loginConfig = this.webApp.getSingleLoginConfig();
        this.initPanel();
    }

    private void initPanel() {
        if (this.loginConfig == null) {
            this.updateVisualState(NONE);
        } else {
            String string = this.loginConfig.getAuthMethod();
            this.updateVisualState(string);
            if (string.equals(FORM)) {
                FormLoginConfig formLoginConfig = this.loginConfig.getFormLoginConfig();
                this.loginPageTF.setText(formLoginConfig.getFormLoginPage());
                this.errorPageTF.setText(formLoginConfig.getFormErrorPage());
            }
            if (!string.equals(NONE)) {
                this.realmNameTF.setText(this.loginConfig.getRealmName());
            }
        }
        this.addModifier(this.noneRB);
        this.addModifier(this.digestRB);
        this.addModifier(this.clientCertRB);
        this.addModifier(this.basicRB);
        this.addModifier(this.formRB);
        this.addValidatee(this.realmNameTF);
        this.addValidatee(this.loginPageTF);
        this.addValidatee(this.errorPageTF);
    }

    private void updateVisualState(String string) {
        boolean bl = false;
        boolean bl2 = true;
        if (string.equals(NONE)) {
            this.noneRB.setSelected(true);
            bl2 = false;
        } else if (string.equals(DIGEST)) {
            this.digestRB.setSelected(true);
        } else if (string.equals(CLIENT_CERT)) {
            this.clientCertRB.setSelected(true);
        } else if (string.equals(BASIC)) {
            this.basicRB.setSelected(true);
        } else if (string.equals(FORM)) {
            this.formRB.setSelected(true);
            bl = true;
        } else {
            this.noneRB.setSelected(true);
            bl2 = false;
        }
        this.realmNameLabel.setEnabled(bl2);
        this.realmNameTF.setEnabled(bl2);
        this.loginPageLabel.setEnabled(bl);
        this.loginPageTF.setEnabled(bl);
        this.loginPageBrowseButton.setEnabled(bl);
        this.errorPageLabel.setEnabled(bl);
        this.errorPageTF.setEnabled(bl);
        this.errorPageBrowseButton.setEnabled(bl);
    }

    public void linkButtonPressed(Object object, String string) {
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void documentChanged(JTextComponent jTextComponent, String string) {
    }

    private void setLoginConfig(LoginConfig loginConfig) {
        this.webApp.setLoginConfig(loginConfig);
        this.loginConfig = loginConfig;
    }

    private LoginConfig getLoginConfig() {
        if (this.loginConfig == null) {
            try {
                this.loginConfig = (LoginConfig)this.webApp.createBean("LoginConfig");
                this.webApp.setLoginConfig(this.loginConfig);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "ignored exception", classNotFoundException);
            }
        }
        return this.loginConfig;
    }

    private FormLoginConfig getFormLoginConfig() {
        LoginConfig loginConfig = this.getLoginConfig();
        FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
        if (formLoginConfig == null) {
            try {
                formLoginConfig = (FormLoginConfig)this.webApp.createBean("FormLoginConfig");
                loginConfig.setFormLoginConfig(formLoginConfig);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.log(Level.FINE, "ignored exception", classNotFoundException);
            }
        }
        return formLoginConfig;
    }

    public void setValue(JComponent jComponent, Object object) {
        if (jComponent instanceof JRadioButton) {
            String string = null;
            string = jComponent == this.noneRB ? NONE : (jComponent == this.digestRB ? DIGEST : (jComponent == this.clientCertRB ? CLIENT_CERT : (jComponent == this.basicRB ? BASIC : (jComponent == this.formRB ? FORM : NONE))));
            this.setLoginConfig(null);
            if (!string.equals(NONE)) {
                LoginConfig loginConfig = this.getLoginConfig();
                loginConfig.setAuthMethod(string);
                if (!string.equals(NONE)) {
                    if (this.realmNameTF.getText().length() > 0) {
                        loginConfig.setRealmName(this.realmNameTF.getText());
                    } else {
                        loginConfig.setRealmName(null);
                    }
                }
                if (string.equals(FORM)) {
                    FormLoginConfig formLoginConfig = this.getFormLoginConfig();
                    formLoginConfig.setFormLoginPage(this.loginPageTF.getText());
                    formLoginConfig.setFormErrorPage(this.errorPageTF.getText());
                }
            }
            this.updateVisualState(string);
        } else if (jComponent == this.realmNameTF) {
            if (((String)object).length() > 0) {
                this.getLoginConfig().setRealmName((String)object);
            } else {
                this.getLoginConfig().setRealmName(null);
            }
        } else if (jComponent == this.loginPageTF) {
            this.getFormLoginConfig().setFormLoginPage((String)object);
        } else if (jComponent == this.errorPageTF) {
            this.getFormLoginConfig().setFormErrorPage((String)object);
        }
    }

    public void rollbackValue(JTextComponent jTextComponent) {
    }

    protected void startUIChange() {
        this.dObj.setChangedFromUI(true);
    }

    protected void endUIChange() {
        this.dObj.modelUpdatedFromUI();
        this.dObj.setChangedFromUI(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.realmNameLabel = new JLabel();
        this.loginPageLabel = new JLabel();
        this.errorPageLabel = new JLabel();
        this.realmNameTF = new JTextField();
        this.loginPageTF = new JTextField();
        this.errorPageTF = new JTextField();
        this.loginPageBrowseButton = new JButton();
        this.errorPageBrowseButton = new JButton();
        this.noneRB = new JRadioButton();
        this.digestRB = new JRadioButton();
        this.clientCertRB = new JRadioButton();
        this.basicRB = new JRadioButton();
        this.formRB = new JRadioButton();
        this.realmNameLabel.setLabelFor(this.realmNameTF);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ddloaders/web/multiview/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.realmNameLabel, (String)resourceBundle.getString("LBL_RealmName"));
        this.realmNameLabel.setEnabled(false);
        this.loginPageLabel.setLabelFor(this.loginPageTF);
        Mnemonics.setLocalizedText((JLabel)this.loginPageLabel, (String)resourceBundle.getString("LBL_FormLoginPage"));
        this.loginPageLabel.setEnabled(false);
        this.errorPageLabel.setLabelFor(this.loginPageTF);
        Mnemonics.setLocalizedText((JLabel)this.errorPageLabel, (String)resourceBundle.getString("LBL_FormErrorPage"));
        this.errorPageLabel.setEnabled(false);
        this.realmNameTF.setEnabled(false);
        this.loginPageTF.setEnabled(false);
        this.errorPageTF.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.loginPageBrowseButton, (String)resourceBundle.getString("LBL_browse"));
        this.loginPageBrowseButton.setEnabled(false);
        this.loginPageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.loginPageBrowseButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.errorPageBrowseButton, (String)resourceBundle.getString("LBL_browse"));
        this.errorPageBrowseButton.setEnabled(false);
        this.errorPageBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.errorPageBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.noneRB);
        this.noneRB.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noneRB, (String)resourceBundle.getString("LBL_NoneAuthMethod"));
        this.noneRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.noneRB.setMargin(new Insets(0, 0, 0, 0));
        this.noneRB.setOpaque(false);
        this.noneRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.noneRBActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.digestRB);
        Mnemonics.setLocalizedText((AbstractButton)this.digestRB, (String)resourceBundle.getString("LBL_DigestAuthMethod"));
        this.digestRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.digestRB.setMargin(new Insets(0, 0, 0, 0));
        this.digestRB.setOpaque(false);
        this.digestRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.digestRBActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.clientCertRB);
        Mnemonics.setLocalizedText((AbstractButton)this.clientCertRB, (String)resourceBundle.getString("LBL_ClientCertAuthMethod"));
        this.clientCertRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clientCertRB.setMargin(new Insets(0, 0, 0, 0));
        this.clientCertRB.setOpaque(false);
        this.clientCertRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.clientCertRBActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.basicRB);
        Mnemonics.setLocalizedText((AbstractButton)this.basicRB, (String)resourceBundle.getString("LBL_BasicAuthMethod"));
        this.basicRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.basicRB.setMargin(new Insets(0, 0, 0, 0));
        this.basicRB.setOpaque(false);
        this.basicRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.basicRBActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.formRB);
        Mnemonics.setLocalizedText((AbstractButton)this.formRB, (String)resourceBundle.getString("LBL_FormAuthMethod"));
        this.formRB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.formRB.setMargin(new Insets(0, 0, 0, 0));
        this.formRB.setOpaque(false);
        this.formRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginConfigPanel.this.formRBActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.noneRB).add((Component)this.digestRB).add((Component)this.clientCertRB).add((Component)this.basicRB).add((Component)this.formRB).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.loginPageLabel).add((Component)this.errorPageLabel)).add(4, 4, 4).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.errorPageTF, -1, 201, Short.MAX_VALUE).add(1, (Component)this.loginPageTF, -1, 201, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.errorPageBrowseButton).add((Component)this.loginPageBrowseButton))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.realmNameLabel).addPreferredGap(1).add((Component)this.realmNameTF, -1, 327, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.noneRB).addPreferredGap(0).add((Component)this.digestRB).addPreferredGap(0).add((Component)this.clientCertRB).addPreferredGap(0).add((Component)this.basicRB).addPreferredGap(0).add((Component)this.formRB).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.loginPageBrowseButton).add((Component)this.loginPageLabel).add((Component)this.loginPageTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.errorPageBrowseButton).add((Component)this.errorPageLabel).add((Component)this.errorPageTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.realmNameLabel).add((Component)this.realmNameTF, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void formRBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState(FORM);
    }

    private void basicRBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState(BASIC);
    }

    private void clientCertRBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState(CLIENT_CERT);
    }

    private void digestRBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState(DIGEST);
    }

    private void noneRBActionPerformed(ActionEvent actionEvent) {
        this.updateVisualState(NONE);
    }

    private void errorPageBrowseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null && !(string = "/" + DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true)).equals(this.errorPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.errorPageTF.setText(string);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormErrorPage(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "ignored exception", iOException);
        }
    }

    private void loginPageBrowseButtonActionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            SourceGroup[] sourceGroupArray = DDUtils.getDocBaseGroups(this.dObj);
            FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
            if (fileObject != null && !(string = "/" + DDUtils.getResourcePath(sourceGroupArray, fileObject, '/', true)).equals(this.loginPageTF.getText())) {
                this.dObj.modelUpdatedFromUI();
                this.loginPageTF.setText(string);
                this.dObj.setChangedFromUI(true);
                this.getFormLoginConfig().setFormLoginPage(string);
                this.dObj.setChangedFromUI(false);
                this.getSectionView().checkValidity();
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.FINE, "ignored exception", iOException);
        }
    }
}

