/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.util;

import java.text.NumberFormat;
import java.util.Locale;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class BytesFormatter
implements ValueFormatter {
    private static final int BINARY_ORDER = 1024;
    private static final int DECIMAL_ORDER = 1000;
    private static final String[] SUFFIXES = new String[]{"b", "K", "M", "G", "T"};
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance(Locale.US);
    private static final NumberFormat FRAC_FORMAT = NumberFormat.getNumberInstance(Locale.US);

    @Override
    public String format(long value) {
        double dbl = value;
        int i = 0;
        while (1024.0 <= dbl && i + 1 < SUFFIXES.length) {
            dbl /= 1024.0;
            ++i;
        }
        if (1000.0 <= dbl && i + 1 < SUFFIXES.length) {
            dbl /= 1024.0;
            ++i;
        }
        NumberFormat nf = dbl < 10.0 ? FRAC_FORMAT : INT_FORMAT;
        return nf.format(dbl) + SUFFIXES[i];
    }

    static {
        FRAC_FORMAT.setMaximumFractionDigits(1);
    }
}

