/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import org.jdesktop.application.ResourceMap;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProjectCustomizerPanel;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ProjectCustomizerProvider
implements ProjectCustomizer.CompositeCategoryProvider {
    private static final String CAT_NAME = "AppFramework";
    private static final String KEY_VENDOR_ID = "Application.vendorId";
    private static final String KEY_APP_ID = "Application.id";
    private static final String KEY_LOOK_AND_FEEL = "Application.lookAndFeel";
    private static final String[][] APP_PROPERTIES = new String[][]{{"application.title", "Application.title"}, {"application.vendor", "Application.vendor"}, {"application.desc", "Application.description"}, {"application.homepage", "Application.homepage"}};

    public ProjectCustomizer.Category createCategory(Lookup lookup) {
        ProjectCustomizer.Category category;
        Project project = (Project)lookup.lookup(Project.class);
        if (AppFrameworkSupport.isApplicationProject(project)) {
            category = ProjectCustomizer.Category.create((String)CAT_NAME, (String)NbBundle.getMessage(ProjectCustomizerProvider.class, (String)"CTL_ProjectCustomizerCategoryTitle"), null, (ProjectCustomizer.Category[])null);
            J2SEPropertyEvaluator j2SEPropertyEvaluator = (J2SEPropertyEvaluator)project.getLookup().lookup(J2SEPropertyEvaluator.class);
            if (j2SEPropertyEvaluator != null) {
                j2SEPropertyEvaluator.evaluator().addPropertyChangeListener((PropertyChangeListener)new ApplicationPropertyChangeListener(project));
            }
        } else {
            category = null;
        }
        return category;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup lookup) {
        Object object;
        ProjectCustomizerPanel projectCustomizerPanel = new ProjectCustomizerPanel();
        Project project = (Project)lookup.lookup(Project.class);
        SaveListener saveListener = new SaveListener(project);
        saveListener.panel = projectCustomizerPanel;
        category.setOkButtonListener((ActionListener)saveListener);
        if (ProjectCustomizerPanel.fileChooserDir == null) {
            object = FileUtil.toFile((FileObject)project.getProjectDirectory());
            ProjectCustomizerPanel.fileChooserDir = ((File)object).getPath();
        }
        if ((object = ResourceUtils.getAppDesignResourceMap(project)) != null) {
            projectCustomizerPanel.setVendorId(((ResourceMap)object).getString(KEY_VENDOR_ID, new Object[0]));
            projectCustomizerPanel.setApplicationId(((ResourceMap)object).getString(KEY_APP_ID, new Object[0]));
            projectCustomizerPanel.setLookAndFeel(((ResourceMap)object).getString(KEY_LOOK_AND_FEEL, new Object[0]));
        } else {
            projectCustomizerPanel.setReadOnly();
        }
        return projectCustomizerPanel;
    }

    static void storeValue(String string, String string2, DesignResourceMap designResourceMap) {
        ResourceValueImpl resourceValueImpl = designResourceMap.getResourceValue(string, String.class);
        if (resourceValueImpl != null) {
            if (string2 != null) {
                resourceValueImpl.setValue(string2);
                resourceValueImpl.setStringValue(string2);
                designResourceMap.addResourceValue(resourceValueImpl);
            } else {
                designResourceMap.removeResourceValue(resourceValueImpl);
            }
        } else if (string2 != null) {
            resourceValueImpl = new ResourceValueImpl(string, String.class, string2, null, string2, false, 0, null);
            designResourceMap.addResourceValue(resourceValueImpl);
        }
    }

    private static class SaveListener
    implements ActionListener,
    Runnable {
        private Project project;
        private ProjectCustomizerPanel panel;

        SaveListener(Project project) {
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RequestProcessor.getDefault().post((Runnable)this);
        }

        @Override
        public void run() {
            DesignResourceMap designResourceMap = ResourceUtils.getAppDesignResourceMap(this.project);
            if (designResourceMap == null) {
                return;
            }
            if (this.panel != null) {
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_VENDOR_ID, this.panel.getVendorId(), designResourceMap);
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_APP_ID, this.panel.getApplicationId(), designResourceMap);
                ProjectCustomizerProvider.storeValue(ProjectCustomizerProvider.KEY_LOOK_AND_FEEL, this.panel.getLookAndFeel(), designResourceMap);
                designResourceMap.save();
                FileObject fileObject = this.panel.getLookAndFeelJAR();
                if (fileObject != null) {
                    try {
                        ProjectClassPathModifier.addRoots((URL[])new URL[]{fileObject.getURL()}, (FileObject)designResourceMap.getSourceFile(), (String)"classpath/execute");
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
    }

    private static class ApplicationPropertyChangeListener
    implements PropertyChangeListener {
        private Project project;

        ApplicationPropertyChangeListener(Project project) {
            this.project = project;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            for (String[] stringArray : APP_PROPERTIES) {
                J2SEPropertyEvaluator j2SEPropertyEvaluator;
                PropertyEvaluator propertyEvaluator;
                if (!stringArray[0].equals(string) || (propertyEvaluator = (j2SEPropertyEvaluator = (J2SEPropertyEvaluator)this.project.getLookup().lookup(J2SEPropertyEvaluator.class)).evaluator()) == null) continue;
                DesignResourceMap designResourceMap = ResourceUtils.getAppDesignResourceMap(this.project);
                if (designResourceMap == null) {
                    return;
                }
                String string2 = propertyEvaluator.getProperty(stringArray[0]);
                ProjectCustomizerProvider.storeValue(stringArray[1], string2, designResourceMap);
                designResourceMap.save();
            }
        }
    }
}

