/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.CssProperties;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class FontModel {
    Map<String, List<String>> fontFamilyNames = new HashMap<String, List<String>>();
    List<String> fontFaceNames = new ArrayList<String>();

    public static Callable<FontModel> getFontModel() {
        return new Callable<FontModel>(){

            @Override
            public FontModel call() throws Exception {
                return new FontModel();
            }
        };
    }

    public FontModel() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            String familyName = fonts[i].getFamily();
            String faceName = fonts[i].getName();
            List<String> list = this.fontFamilyNames.get(familyName);
            if (list == null) {
                list = new ArrayList<String>();
                this.fontFamilyNames.put(familyName, list);
            }
            list.add(faceName);
            this.fontFaceNames.add(faceName);
        }
    }

    public DefaultListModel getFontFamilySetList() {
        return new FontFamilySetList();
    }

    public DefaultListModel getFontList() {
        return new FontList();
    }

    public DefaultListModel getWebFontList() {
        return new WebFontList();
    }

    public DefaultListModel getFontFamilyList() {
        return new FontFamilyList();
    }

    public DefaultListModel getFontSizeList() {
        return new FontSizeList();
    }

    public DefaultComboBoxModel getFontSizeUnitList() {
        return new FontSizeUnitList();
    }

    public DefaultComboBoxModel getFontStyleList() {
        return new FontStyleList();
    }

    public DefaultComboBoxModel getFontSelectionList() {
        return new FontSelectionList();
    }

    public DefaultComboBoxModel getFontWeightList() {
        return new FontWeightList();
    }

    public DefaultComboBoxModel getFontVariantList() {
        return new FontVariantList();
    }

    public FontSize getFontSize(String fontSizeStr) {
        return new FontSize(fontSizeStr);
    }

    public Font resolveFont(CssRuleContent styleData, Font baseFont) {
        String fontFamily = styleData.getProperty("font-family");
        String fontSize = styleData.getProperty("font-size");
        String fontStyle = styleData.getProperty("font-style");
        String fontVariant = styleData.getProperty("font-variant");
        String fontWeight = styleData.getProperty("font-weight");
        String name = this.resolveFontName(fontFamily, baseFont.getName());
        int style = this.resolveFontStyle(fontStyle, fontWeight, baseFont.getStyle());
        int size = this.resolveFontSize(fontSize, baseFont.getSize());
        return new Font(name, style, size);
    }

    private String resolveFontName(String fontFamily, String defName) {
        String fontName = defName;
        if (fontFamily != null) {
            StringTokenizer st = new StringTokenizer(fontFamily.trim(), ",");
            while (st.hasMoreTokens()) {
                String cssFamilyName = st.nextToken();
                if (this.fontFamilyNames.containsKey(cssFamilyName = cssFamilyName.replaceAll("'", ""))) {
                    List<String> fontFaceList = this.fontFamilyNames.get(cssFamilyName);
                    fontName = fontFaceList.get(0);
                    continue;
                }
                if (!this.fontFaceNames.contains(cssFamilyName)) continue;
                fontName = cssFamilyName;
            }
        }
        return fontName;
    }

    private int resolveFontStyle(String fontStyle, String fontWeight, int defStyle) {
        int style = defStyle;
        if (fontStyle != null && (fontStyle.equals("italic") || fontStyle.equals("oblique"))) {
            style = 2;
        }
        if (fontWeight != null && fontWeight.equals(fontWeight)) {
            style |= 1;
        }
        return style;
    }

    private int resolveFontSize(String fontSizeStr, int defSize) {
        int size = defSize;
        if (fontSizeStr != null) {
            FontSize fontSize = new FontSize(fontSizeStr);
            String fontSizeValue = fontSize.getValue();
            if (Utils.isInteger(fontSizeValue)) {
                size = Utils.getInteger(fontSizeValue);
            } else {
                if (fontSizeValue.equals("XX-small")) {
                    size = 4;
                }
                if (fontSizeValue.equals("X-small")) {
                    size = 6;
                }
                if (fontSizeValue.equals("small")) {
                    size = 8;
                }
                if (fontSizeValue.equals("medium")) {
                    size = 12;
                }
                if (fontSizeValue.equals("large")) {
                    size = 14;
                }
                if (fontSizeValue.equals("X-large")) {
                    size = 16;
                }
                if (fontSizeValue.equals("XX-large")) {
                    size = 20;
                }
            }
            if (size < 4) {
                size = 4;
            } else if (size > 72) {
                size = 72;
            }
        }
        return size;
    }

    public static class FontVariantList
    extends DefaultComboBoxModel {
        public FontVariantList() {
            String[] propValues = CssProperties.getCssPropertyValues("font-variant");
            this.addElement(Utils.NOT_SET);
            for (int i = 0; i < propValues.length; ++i) {
                this.addElement(propValues[i]);
            }
        }
    }

    public static class FontWeightList
    extends DefaultComboBoxModel {
        public FontWeightList() {
            String[] propValues = CssProperties.getCssPropertyValues("font-weight");
            this.addElement(Utils.NOT_SET);
            for (int i = 0; i < propValues.length; ++i) {
                this.addElement(propValues[i]);
            }
            this.setSelectedItem("px");
        }
    }

    public static class FontStyleList
    extends DefaultComboBoxModel {
        public FontStyleList() {
            String[] propValues = CssProperties.getCssPropertyValues("font-style");
            this.addElement(Utils.NOT_SET);
            for (int i = 0; i < propValues.length; ++i) {
                this.addElement(propValues[i]);
            }
        }
    }

    public static class FontSizeUnitList
    extends DefaultComboBoxModel {
        public FontSizeUnitList() {
            String[] unitValues = CssProperties.getCssLengthUnits();
            for (int i = 0; i < unitValues.length; ++i) {
                this.addElement(unitValues[i]);
            }
        }
    }

    public static class FontSizeList
    extends DefaultListModel {
        public FontSizeList() {
            this.addElement(Utils.NOT_SET);
            String[] FontSizeValues = CssProperties.getFontSizeValues();
            for (int i = 0; i < FontSizeValues.length; ++i) {
                this.addElement(FontSizeValues[i]);
            }
        }
    }

    public static class FontFamilySetList
    extends DefaultListModel {
        public FontFamilySetList() {
            this.addElement(Utils.NOT_SET);
            String[] FontfamilySetValues = CssProperties.getFontFamilySetValues();
            for (int i = 0; i < FontfamilySetValues.length; ++i) {
                this.addElement(FontfamilySetValues[i]);
            }
        }
    }

    public static class FontFamilyList
    extends DefaultListModel {
        public FontFamilyList() {
            this.addElement(Utils.NOT_SET);
            String[] FontfamilyValues = CssProperties.getFontFamilyValues();
            for (int i = 0; i < FontfamilyValues.length; ++i) {
                this.addElement(FontfamilyValues[i]);
            }
        }
    }

    public static class WebFontList
    extends DefaultListModel {
        public WebFontList() {
            this.addElement(Utils.NOT_SET);
            String[] webFontValues = CssProperties.getWebFontValues();
            for (int i = 0; i < webFontValues.length; ++i) {
                this.addElement(webFontValues[i]);
            }
        }
    }

    public static class FontList
    extends DefaultListModel {
        public FontList() {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] fontNames = ge.getAvailableFontFamilyNames();
            for (int i = 0; i < fontNames.length; ++i) {
                this.addElement(fontNames[i]);
            }
        }
    }

    public static class FontSelectionList
    extends DefaultComboBoxModel {
        public FontSelectionList() {
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONTS"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONT_FAMILIES"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"WEB_FONTS"));
        }
    }

    public class FontSize {
        FontSizeUnitList unitList = new FontSizeUnitList();
        String fontSizeUnit = null;
        String fontSize = null;

        public FontSize(String fontSizeStr) {
            this.fontSize = fontSizeStr.trim();
            for (int i = 0; i < this.unitList.getSize(); ++i) {
                String unit = (String)this.unitList.getElementAt(i);
                if (!this.fontSize.endsWith(unit)) continue;
                this.fontSizeUnit = unit;
                this.fontSize = this.fontSize.replaceAll(unit, "");
            }
        }

        public String getUnit() {
            return this.fontSizeUnit;
        }

        public String getValue() {
            if (Utils.isFloat(this.fontSize)) {
                return this.fontSize;
            }
            return null;
        }
    }
}

