/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectKeeper;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileChangedManager;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public final class FolderObj
extends BaseFileObj {
    static final long serialVersionUID = -1022430210876356809L;
    private static final Logger LOG = Logger.getLogger(FolderObj.class.getName());
    private FolderChildrenCache folderChildren;
    boolean valid = true;
    private FileObjectKeeper keeper;

    public FolderObj(File file, FileNaming name) {
        super(file, name);
    }

    public final boolean isFolder() {
        return true;
    }

    public FileObject getFileObject(String relativePath) {
        if (relativePath.indexOf(92) != -1) {
            return null;
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        File file = new File(this.getFileName().getFile(), relativePath);
        FileObjectFactory factory = this.getFactory();
        return factory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject);
    }

    public final FileObject getFileObject(String name, String ext) {
        File file = BaseFileObj.getFile(this.getFileName().getFile(), name, ext);
        FileObjectFactory factory = this.getFactory();
        return name.indexOf("/") == -1 ? factory.getValidFileObject(file, FileObjectFactory.Caller.GetFileObject) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject[] getChildren() {
        HashSet<FileNaming> fileNames;
        ArrayList<BaseFileObj> results = new ArrayList<BaseFileObj>();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            fileNames = new HashSet<FileNaming>(childrenCache.getChildren(false));
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileObjectFactory lfs = this.getFactory();
        for (FileNaming fileName : fileNames) {
            FileInfo fInfo = new FileInfo(fileName.getFile(), 1);
            fInfo.setFileNaming(fileName);
            BaseFileObj fo = lfs.getFileObject(fInfo, FileObjectFactory.Caller.GetChildern);
            if (fo == null) continue;
            results.add(fo);
        }
        return results.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createFolderImpl(String name) throws IOException {
        File folder2Create;
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        BaseFileObj retVal = null;
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            File myFile = this.getFileName().getFile();
            folder2Create = BaseFileObj.getFile(myFile, name, null);
            if (!myFile.canWrite()) {
                FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
            }
            this.createFolder(folder2Create, name);
            FileNaming childName = this.getChildrenCache().getChild(folder2Create.getName(), true);
            if (childName != null && !childName.isDirectory()) {
                childName = NamingFactory.fromFile(this.getFileName(), folder2Create, true);
            }
            if (childName != null) {
                childName = NamingFactory.checkCaseSensitivity(childName, folder2Create);
            }
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileObjectFactory factory = this.getFactory();
        if (factory != null) {
            retVal = (FolderObj)factory.getValidFileObject(folder2Create, FileObjectFactory.Caller.Others);
        }
        if (retVal != null) {
            retVal.fireFileFolderCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
        }
        return retVal;
    }

    private void createFolder(File folder2Create, String name) throws IOException {
        boolean isSupported = new FileInfo(folder2Create).isSupportedFile();
        ProvidedExtensions extensions = this.getProvidedExtensions();
        extensions.beforeCreate(this, folder2Create.getName(), true);
        if (!isSupported) {
            extensions.createFailure(this, folder2Create.getName(), true);
            FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(folder2Create)) {
                extensions.createFailure(this, folder2Create.getName(), true);
                throw new SyncFailedException(folder2Create.getAbsolutePath());
            }
            if (!folder2Create.mkdirs()) {
                extensions.createFailure(this, folder2Create.getName(), true);
                FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
            }
        }
        LogRecord r = new LogRecord(Level.FINEST, "FolderCreated: " + folder2Create.getAbsolutePath());
        r.setParameters(new Object[]{folder2Create});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(r);
    }

    public final FileObject createData(final String name, final String ext) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> c = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createDataImpl(name, ext);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(c);
    }

    public final FileObject createFolder(final String name) throws IOException {
        FileBasedFileSystem.FSCallable<FileObject> c = new FileBasedFileSystem.FSCallable<FileObject>(){

            @Override
            public FileObject call() throws IOException {
                return FolderObj.this.createFolderImpl(name);
            }
        };
        return FileBasedFileSystem.runAsInconsistent(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createDataImpl(String name, String ext) throws IOException {
        File file2Create;
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            file2Create = BaseFileObj.getFile(this.getFileName().getFile(), name, ext);
            this.createData(file2Create);
            FileNaming childName = this.getChildrenCache().getChild(file2Create.getName(), true);
            if (childName != null && childName.isDirectory()) {
                childName = NamingFactory.fromFile(this.getFileName(), file2Create, true);
            }
            if (childName != null) {
                childName = NamingFactory.checkCaseSensitivity(childName, file2Create);
            }
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileObjectFactory factory = this.getFactory();
        FileObj retVal = null;
        if (factory != null) {
            retVal = (FileObj)factory.getValidFileObject(file2Create, FileObjectFactory.Caller.Others);
        }
        if (retVal != null) {
            if (retVal instanceof FileObj) {
                retVal.setLastModified(file2Create.lastModified(), file2Create);
            }
            retVal.fireFileDataCreatedEvent(false);
        } else {
            FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
        }
        return retVal;
    }

    private void createData(File file2Create) throws IOException {
        boolean isSupported = new FileInfo(file2Create).isSupportedFile();
        ProvidedExtensions extensions = this.getProvidedExtensions();
        extensions.beforeCreate(this, file2Create.getName(), false);
        if (!isSupported) {
            extensions.createFailure(this, file2Create.getName(), false);
            FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
        } else {
            if (FileChangedManager.getInstance().exists(file2Create)) {
                extensions.createFailure(this, file2Create.getName(), false);
                throw new SyncFailedException(file2Create.getAbsolutePath());
            }
            if (!file2Create.createNewFile()) {
                extensions.createFailure(this, file2Create.getName(), false);
                FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
            }
        }
        LogRecord r = new LogRecord(Level.FINEST, "DataCreated: " + file2Create.getAbsolutePath());
        r.setParameters(new Object[]{file2Create});
        Logger.getLogger("org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj").log(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(FileLock lock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        LinkedList<FileObject> all = new LinkedList<FileObject>();
        File file = this.getFileName().getFile();
        if (!this.deleteFile(file, all, this.getFactory(), deleteHandler)) {
            FolderObj parent = this.getExistingParent();
            String parentPath = parent != null ? parent.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotDelete", file.getName(), parentPath);
        }
        BaseFileObj.attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
        this.setValid(false);
        for (int i = 0; i < all.size(); ++i) {
            ChildrenCache childrenCache;
            BaseFileObj toDel = (BaseFileObj)all.get(i);
            FolderObj existingParent = toDel.getExistingParent();
            ChildrenCache childrenCache2 = childrenCache = existingParent != null ? existingParent.getChildrenCache() : null;
            if (childrenCache != null) {
                Mutex.Privileged mutexPrivileged;
                Mutex.Privileged privileged = mutexPrivileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (mutexPrivileged != null) {
                    mutexPrivileged.enterWriteAccess();
                }
                try {
                    if (deleteHandler != null) {
                        childrenCache.removeChild(toDel.getFileName());
                    } else {
                        childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                    }
                }
                finally {
                    if (mutexPrivileged != null) {
                        mutexPrivileged.exitWriteAccess();
                    }
                }
            }
            toDel.setValid(false);
            toDel.fireFileDeletedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshImpl(boolean expected, boolean fire) {
        ChildrenCache cache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = cache.getMutexPrivileged();
        long previous = this.keeper == null ? -1L : this.keeper.childrenLastModified();
        HashSet<FileNaming> oldChildren = null;
        Map<FileNaming, Integer> refreshResult = null;
        mutexPrivileged.enterWriteAccess();
        try {
            oldChildren = new HashSet<FileNaming>(cache.getCachedChildren());
            refreshResult = cache.refresh();
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        LOG.log(Level.FINER, "refreshImpl for {0} expected: {1} fire: {2} previous: {3}", new Object[]{this, expected, fire, previous});
        oldChildren.removeAll(refreshResult.keySet());
        for (FileNaming child : oldChildren) {
            BaseFileObj childObj = this.getFactory().getCachedOnly(child.getFile());
            if (childObj == null || !childObj.isData()) continue;
            ((FileObj)childObj).refresh(expected);
        }
        FileObjectFactory factory = this.getFactory();
        for (Map.Entry<FileNaming, Integer> entry : refreshResult.entrySet()) {
            FileNaming child = entry.getKey();
            Integer operationId = entry.getValue();
            BaseFileObj newChild = operationId == ChildrenCache.ADDED_CHILD ? factory.getFileObject(new FileInfo(child.getFile()), FileObjectFactory.Caller.Others) : factory.getCachedOnly(child.getFile());
            BaseFileObj baseFileObj = newChild = newChild != null ? newChild : this.getFileObject(child.getName());
            if (operationId == ChildrenCache.ADDED_CHILD && newChild != null) {
                if (newChild.isFolder()) {
                    if (!fire) continue;
                    newChild.fireFileFolderCreatedEvent(expected);
                    continue;
                }
                if (!fire) continue;
                newChild.fireFileDataCreatedEvent(expected);
                continue;
            }
            if (operationId != ChildrenCache.REMOVED_CHILD) continue;
            if (newChild != null) {
                if (!newChild.isValid()) continue;
                newChild.setValid(false);
                if (newChild instanceof FolderObj) {
                    ((FolderObj)newChild).refreshImpl(expected, fire);
                    continue;
                }
                if (!fire) continue;
                newChild.fireFileDeletedEvent(expected);
                continue;
            }
            File f = child.getFile();
            if (new FileInfo(f).isConvertibleToFileObject()) continue;
            BaseFileObj fakeInvalid = child.isFile() ? new FileObj(f, child) : new FolderObj(f, child);
            fakeInvalid.setValid(false);
            if (!fire) continue;
            fakeInvalid.fireFileDeletedEvent(expected);
        }
        boolean validityFlag = FileChangedManager.getInstance().exists(this.getFileName().getFile());
        if (!validityFlag) {
            this.setValid(false);
            if (fire) {
                this.fireFileDeletedEvent(expected);
            }
        }
        if (previous != -1L) {
            assert (this.keeper != null);
            this.keeper.init(previous, factory, expected);
        }
    }

    public final void refresh(boolean expected) {
        this.refresh(expected, true);
    }

    private boolean deleteFile(File file, LinkedList<FileObject> all, FileObjectFactory factory, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        BaseFileObj aliveFo;
        boolean retVal;
        File[] arr;
        boolean ret;
        boolean bl = ret = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (ret) {
            BaseFileObj aliveFo2 = factory.getCachedOnly(file);
            if (aliveFo2 != null) {
                all.addFirst(aliveFo2);
            }
            return true;
        }
        if (!FileChangedManager.getInstance().exists(file)) {
            return false;
        }
        if (file.isDirectory() && (arr = file.listFiles()) != null) {
            for (int i = 0; i < arr.length; ++i) {
                File f2Delete = arr[i];
                if (this.deleteFile(f2Delete, all, factory, deleteHandler)) continue;
                return false;
            }
        }
        boolean bl2 = retVal = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (retVal && (aliveFo = factory.getCachedOnly(file)) != null) {
            all.addFirst(aliveFo);
        }
        return true;
    }

    @Override
    protected void setValid(boolean valid) {
        if (valid) {
            assert (this.isValid()) : this.toString();
        } else {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException(this.getPath());
    }

    public final FileLock lock() throws IOException {
        return new FileLock();
    }

    @Override
    final boolean checkLock(FileLock lock) throws IOException {
        return true;
    }

    public final synchronized ChildrenCache getChildrenCache() {
        if (this.folderChildren == null) {
            this.folderChildren = new FolderChildrenCache();
        }
        return this.folderChildren;
    }

    synchronized FileObjectKeeper getKeeper(Collection<? super File> arr) {
        if (this.keeper == null) {
            this.keeper = new FileObjectKeeper(this);
            List<File> ch = this.keeper.init(-1L, null, false);
            if (arr != null) {
                arr.addAll(ch);
            }
        } else if (arr != null) {
            List<File> ch = this.keeper.init(this.keeper.childrenLastModified(), null, false);
            arr.addAll(ch);
        }
        return this.keeper;
    }

    @Override
    public final void addRecursiveListener(FileChangeListener fcl) {
        this.getKeeper(null).addRecursiveListener(fcl);
    }

    @Override
    public final void removeRecursiveListener(FileChangeListener fcl) {
        this.getKeeper(null).removeRecursiveListener(fcl);
    }

    public final class FolderChildrenCache
    extends ChildrenSupport
    implements ChildrenCache {
        @Override
        public final Set<FileNaming> getChildren(boolean rescan) {
            return this.getChildren(FolderObj.this.getFileName(), rescan);
        }

        @Override
        public final FileNaming getChild(String childName, boolean rescan) {
            return this.getChild(childName, FolderObj.this.getFileName(), rescan);
        }

        @Override
        public final Map<FileNaming, Integer> refresh() {
            return this.refresh(FolderObj.this.getFileName());
        }

        @Override
        public final String toString() {
            return FolderObj.this.getFileName().toString();
        }

        @Override
        public void removeChild(FileNaming childName) {
            this.removeChild(FolderObj.this.getFileName(), childName);
        }
    }
}

