/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.kenai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonChangeListener;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonManager;
import org.netbeans.modules.hudson.api.UI;
import org.netbeans.modules.hudson.kenai.BuildHandleImpl;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.spi.BuildAccessor;
import org.netbeans.modules.kenai.ui.spi.BuildHandle;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.openide.util.WeakListeners;

public class BuildAccessorImpl
extends BuildAccessor {
    private static final Logger LOG = Logger.getLogger(BuildAccessorImpl.class.getName());
    private final Map<ProjectHandle, HudsonChangeListener> listeners = new WeakHashMap<ProjectHandle, HudsonChangeListener>();

    private static Collection<HudsonInstance> findServers(ProjectHandle handle) {
        ArrayList<HudsonInstance> servers = new ArrayList<HudsonInstance>();
        String id = handle.getId();
        try {
            KenaiProject prj = handle.getKenaiProject().getKenai().getProject(id);
            if (prj != null) {
                for (KenaiFeature feature : prj.getFeatures(KenaiService.Type.HUDSON)) {
                    String server = feature.getWebLocation().toString();
                    servers.add(HudsonManager.addInstance((String)id, (String)server, (int)5, (boolean)false));
                }
            }
        }
        catch (KenaiException x) {
            LOG.log(Level.FINE, "Could not find project " + id, x);
        }
        return servers;
    }

    public boolean isEnabled(ProjectHandle handle) {
        String id = handle.getId();
        try {
            KenaiProject prj = handle.getKenaiProject().getKenai().getProject(id);
            if (prj != null) {
                return prj.getFeatures(KenaiService.Type.HUDSON).length > 0;
            }
        }
        catch (KenaiException x) {
            LOG.log(Level.FINE, "Could not find project " + id, x);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuildHandle> getBuilds(final ProjectHandle handle) {
        HudsonChangeListener newListener;
        Map<ProjectHandle, HudsonChangeListener> map = this.listeners;
        synchronized (map) {
            if (this.listeners.containsKey(handle)) {
                newListener = null;
            } else {
                newListener = new HudsonChangeListener(){

                    private void change() {
                        handle.firePropertyChange("buildList", null, null);
                    }

                    public void stateChanged() {
                        this.change();
                    }

                    public void contentChanged() {
                        this.change();
                    }
                };
                this.listeners.put(handle, newListener);
            }
        }
        ArrayList<BuildHandle> builds = new ArrayList<BuildHandle>();
        for (HudsonInstance instance : BuildAccessorImpl.findServers(handle)) {
            if (newListener != null) {
                instance.addHudsonChangeListener((HudsonChangeListener)WeakListeners.create(HudsonChangeListener.class, (EventListener)newListener, (Object)instance));
            }
            for (HudsonJob job : instance.getJobs()) {
                builds.add(new BuildHandleImpl(job));
            }
        }
        return builds;
    }

    public Action getNewBuildAction(ProjectHandle handle) {
        Collection<HudsonInstance> servers = BuildAccessorImpl.findServers(handle);
        if (servers.isEmpty()) {
            return null;
        }
        return UI.createJobAction((HudsonInstance)servers.iterator().next());
    }
}

