/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.repository;

import java.net.MalformedURLException;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.config.Scrambler;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryConnection {
    private static final String RC_DELIMITER = "~=~";
    private String url;
    private String username;
    private char[] password;
    private String externalCommand;
    private boolean savePassword;
    private SVNUrl svnUrl;
    private SVNRevision svnRevision;
    private String certFile;
    private char[] certPassword;
    private static Boolean keepUserInHostname;

    public RepositoryConnection(RepositoryConnection rc) {
        this(rc.url, rc.username, rc.password, rc.externalCommand, rc.savePassword, rc.certFile, rc.certPassword);
    }

    public RepositoryConnection(String url) {
        this(url, null, null, null, false, null, null);
    }

    public RepositoryConnection(String url, String username, char[] password, String externalCommand, boolean savePassword, String certFile, char[] certPassword) {
        this.setUrl(url);
        this.setUsername(username);
        this.setPassword(password);
        this.setExternalCommand(externalCommand);
        this.savePassword = savePassword;
        this.certFile = certFile;
        this.certPassword = certPassword;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username == null ? "" : this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getExternalCommand() {
        return this.externalCommand == null ? "" : this.externalCommand;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public String getCertFile() {
        return this.certFile == null ? "" : this.certFile;
    }

    public char[] getCertPassword() {
        return this.certPassword;
    }

    public SVNUrl getSvnUrl() throws MalformedURLException {
        if (this.svnUrl == null) {
            this.parseUrlString(this.url);
        }
        return this.svnUrl;
    }

    public SVNRevision getSvnRevision() throws MalformedURLException {
        if (this.svnRevision == null) {
            this.parseUrlString(this.url);
        }
        return this.svnRevision;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryConnection test = (RepositoryConnection)o;
        return this.url == test.url || this.url == null || this.url.equals(test.url);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    void setUrl(String url) {
        this.url = url;
        this.svnUrl = null;
        this.svnRevision = null;
    }

    void setUsername(String username) {
        this.username = username;
    }

    void setPassword(char[] password) {
        this.password = password;
    }

    void setExternalCommand(String externalCommand) {
        this.externalCommand = externalCommand;
    }

    void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public void setCertFile(String certFile) {
        this.certFile = certFile;
    }

    public void setCertPassword(char[] certPassword) {
        this.certPassword = certPassword;
    }

    public String toString() {
        return this.url;
    }

    private void parseUrlString(String urlString) throws MalformedURLException {
        int idx = urlString.lastIndexOf(64);
        int hostIdx = urlString.indexOf("://");
        int firstSlashIdx = urlString.indexOf("/", hostIdx + 3);
        if (idx < 0 || firstSlashIdx < 0 || idx < firstSlashIdx) {
            this.svnRevision = SVNRevision.HEAD;
        } else {
            if (idx + 1 < urlString.length()) {
                String revisionString = "";
                try {
                    revisionString = urlString.substring(idx + 1);
                    this.svnRevision = SvnUtils.getSVNRevision(revisionString);
                }
                catch (NumberFormatException ex) {
                    throw new MalformedURLException(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_WrongRevision", (Object)revisionString));
                }
            } else {
                this.svnRevision = SVNRevision.HEAD;
            }
            urlString = urlString.substring(0, idx);
        }
        this.svnUrl = this.removeEmptyPathSegments(new SVNUrl(urlString));
    }

    private SVNUrl removeEmptyPathSegments(SVNUrl url) throws MalformedURLException {
        String[] pathSegments = url.getPathSegments();
        StringBuffer urlString = new StringBuffer();
        urlString.append(url.getProtocol());
        urlString.append("://");
        urlString.append(RepositoryConnection.ripUserFromHost(url.getHost()));
        if (url.getPort() > 0) {
            urlString.append(":");
            urlString.append(url.getPort());
        }
        boolean gotSegments = false;
        for (int i = 0; i < pathSegments.length; ++i) {
            if (pathSegments[i].trim().equals("")) continue;
            gotSegments = true;
            urlString.append("/");
            urlString.append(pathSegments[i]);
        }
        if (gotSegments) {
            return new SVNUrl(urlString.toString());
        }
        return url;
    }

    public static String getString(RepositoryConnection rc) {
        SVNUrl url;
        try {
            url = rc.getSvnUrl();
        }
        catch (MalformedURLException mue) {
            Subversion.LOG.log(Level.INFO, null, mue);
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(url.toString());
        sb.append(RC_DELIMITER);
        if (rc.getSavePassword()) {
            sb.append(rc.getUsername());
        }
        sb.append(RC_DELIMITER);
        sb.append(RC_DELIMITER);
        sb.append(rc.getExternalCommand());
        sb.append(RC_DELIMITER);
        sb.append(rc.getSavePassword());
        sb.append(RC_DELIMITER);
        sb.append(rc.getCertFile());
        sb.append(RC_DELIMITER);
        sb.append(RC_DELIMITER);
        return sb.toString();
    }

    public static RepositoryConnection parse(String str) {
        String[] fields = str.split(RC_DELIMITER);
        int l = fields.length;
        String url = fields[0];
        String username = l > 1 && !fields[1].equals("") ? fields[1] : null;
        String password = l > 2 && !fields[2].equals("") ? Scrambler.getInstance().descramble(fields[2]) : null;
        String extCmd = l > 3 && !fields[3].equals("") ? fields[3] : null;
        boolean save = l > 4 && !fields[4].equals("") ? Boolean.parseBoolean(fields[4]) : true;
        String certFile = l > 5 && !fields[5].equals("") ? fields[5] : null;
        String certPassword = l > 6 && !fields[6].equals("") ? Scrambler.getInstance().descramble(fields[6]) : null;
        return new RepositoryConnection(url, username, password == null ? null : password.toCharArray(), extCmd, save, certFile, certPassword == null ? null : certPassword.toCharArray());
    }

    private static String ripUserFromHost(String hostname) {
        if (keepUserInHostname == null) {
            keepUserInHostname = new Boolean("false".equals(System.getProperty("subversion.ripUserFromHostnames", "true")));
        }
        return keepUserInHostname != false ? hostname : SvnUtils.ripUserFromHost(hostname);
    }
}

