/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.tools.JavaFileManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.classpath.CacheClassPath;
import org.netbeans.modules.java.source.classpath.SourcePath;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.AptSourceFileManager;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.CachingFileManager;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.GeneratedFileMarker;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.MemoryFileManager;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.ProxyFileManager;
import org.netbeans.modules.java.source.parsing.SiblingSource;
import org.netbeans.modules.java.source.parsing.SiblingSupport;
import org.netbeans.modules.java.source.parsing.SourceFileManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final ClassPath EMPTY_PATH;
    private static Logger log;
    private final CachingArchiveProvider archiveProvider;
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private final ClassPath cachedUserSrcClassPath;
    private final ClassPath cachedAptSrcClassPath;
    private final ClassPath cachedSrcClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean backgroundCompilation;
    private final boolean useModifiedFiles;
    private final boolean ignoreExcludes;
    private final JavaFileFilterImplementation filter;
    private JavaFileManager fileManager;
    private OutputFileManager outFileManager;
    private final MemoryFileManager memoryFileManager;
    private final ChangeSupport listenerList;
    private ClassIndex usagesQuery;

    private ClasspathInfo(@NonNull CachingArchiveProvider archiveProvider, @NonNull ClassPath bootCp, @NonNull ClassPath compileCp, ClassPath srcCp, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
        assert (archiveProvider != null);
        assert (bootCp != null);
        assert (compileCp != null);
        this.cpListener = new ClassPathListener();
        this.archiveProvider = archiveProvider;
        this.bootClassPath = bootCp;
        this.compileClassPath = compileCp;
        this.listenerList = new ChangeSupport((Object)this);
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath);
        this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
        this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        if (srcCp == null) {
            this.cachedAptSrcClassPath = null;
            this.srcClassPath = this.cachedUserSrcClassPath = EMPTY_PATH;
            this.cachedSrcClassPath = this.cachedUserSrcClassPath;
            this.outputClassPath = EMPTY_PATH;
        } else {
            this.srcClassPath = srcCp;
            boolean allowAptRoots = true;
            this.cachedUserSrcClassPath = SourcePath.sources(srcCp, backgroundCompilation);
            this.cachedAptSrcClassPath = SourcePath.apt(srcCp, backgroundCompilation);
            this.cachedSrcClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cachedUserSrcClassPath, this.cachedAptSrcClassPath});
            this.outputClassPath = CacheClassPath.forSourcePath(this.cachedUserSrcClassPath);
            this.cachedSrcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedSrcClassPath));
        }
        this.backgroundCompilation = backgroundCompilation;
        this.ignoreExcludes = ignoreExcludes;
        this.useModifiedFiles = useModifiedFiles;
        this.filter = filter;
        if (hasMemoryFileManager) {
            if (srcCp == null) {
                throw new IllegalStateException();
            }
            this.memoryFileManager = new MemoryFileManager();
        } else {
            this.memoryFileManager = null;
        }
    }

    public String toString() {
        return String.format("ClasspathInfo boot: %s, compile: %s, src: %s, internal boot: %s, internal compile: %s, internal out: %s", this.bootClassPath, this.compileClassPath, this.cachedSrcClassPath, this.cachedBootClassPath, this.cachedCompileClassPath, this.outputClassPath);
    }

    public int hashCode() {
        return this.srcClassPath == null ? 0 : this.srcClassPath.entries().size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClasspathInfo) {
            ClasspathInfo other = (ClasspathInfo)obj;
            return this.srcClassPath == null ? other.srcClassPath == null : this.srcClassPath.equals(other.srcClassPath) && this.compileClassPath.equals(other.compileClassPath) && this.bootClassPath.equals(other.bootClassPath);
        }
        return false;
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fo = FileUtil.toFileObject((File)file);
        if (fo == null) {
            return null;
        }
        return ClasspathInfo.create(fo);
    }

    @NullUnknown
    public static ClasspathInfo create(@NonNull Document doc) {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        Object source = doc.getProperty("stream");
        if (source instanceof DataObject) {
            DataObject dObj = (DataObject)source;
            return ClasspathInfo.create(dObj.getPrimaryFile());
        }
        String mimeType = (String)doc.getProperty("mimeType");
        if ("text/x-dialog-binding".equals(mimeType)) {
            Object obj;
            LanguagePath path;
            InputAttributes attributes = (InputAttributes)doc.getProperty(InputAttributes.class);
            Document d = (Document)attributes.getValue(path = LanguagePath.get((Language)((Language)MimeLookup.getLookup((String)mimeType).lookup(Language.class))), (Object)"dialogBinding.document");
            if (d != null && (obj = d.getProperty("stream")) instanceof DataObject) {
                DataObject dObj = (DataObject)obj;
                return ClasspathInfo.create(dObj.getPrimaryFile());
            }
            FileObject fileObject = (FileObject)attributes.getValue(path, (Object)"dialogBinding.fileObject");
            if (fileObject != null) {
                return ClasspathInfo.create(fileObject);
            }
        }
        return null;
    }

    private static ClasspathInfo create(@NonNull FileObject fo, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
        ClassPath srcPath;
        ClassPath compilePath;
        ClassPath bootPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
        if (bootPath == null) {
            bootPath = JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries();
        }
        if ((compilePath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile")) == null) {
            compilePath = EMPTY_PATH;
        }
        if ((srcPath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source")) == null) {
            srcPath = EMPTY_PATH;
        }
        return ClasspathInfo.create(bootPath, compilePath, srcPath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
    }

    @NonNull
    public static ClasspathInfo create(@NonNull FileObject fo) {
        return ClasspathInfo.create(fo, null, false, false, false, true);
    }

    private static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath classPath, ClassPath sourcePath, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
        return new ClasspathInfo(CachingArchiveProvider.getDefault(), bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
    }

    @NonNull
    public static ClasspathInfo create(@NonNull ClassPath bootPath, @NonNull ClassPath classPath, @NullAllowed ClassPath sourcePath) {
        Parameters.notNull((CharSequence)"bootPath", (Object)bootPath);
        Parameters.notNull((CharSequence)"classPath", (Object)classPath);
        return ClasspathInfo.create(bootPath, classPath, sourcePath, null, false, false, false, true);
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.addChangeListener(listener);
    }

    public synchronized void removeChangeListener(@NonNull ChangeListener listener) {
        this.listenerList.removeChangeListener(listener);
    }

    public ClassPath getClassPath(@NonNull PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case SOURCE: {
                return this.cachedSrcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    @NonNull
    public synchronized ClassIndex getClassIndex() {
        if (this.usagesQuery == null) {
            this.usagesQuery = new ClassIndex(this.bootClassPath, this.compileClassPath, this.cachedUserSrcClassPath);
        }
        return this.usagesQuery;
    }

    synchronized JavaFileManager getFileManager() {
        if (this.fileManager == null) {
            boolean hasSources = this.cachedSrcClassPath != null;
            CacheMarker marker = new CacheMarker(this.cachedUserSrcClassPath, this.cachedAptSrcClassPath, this.backgroundCompilation);
            SiblingSource siblings = SiblingSupport.create();
            this.fileManager = new ProxyFileManager(new CachingFileManager(this.archiveProvider, this.cachedBootClassPath, true, true), new CachingFileManager(this.archiveProvider, this.cachedCompileClassPath, false, true), hasSources ? (!this.useModifiedFiles ? new CachingFileManager(this.archiveProvider, this.cachedSrcClassPath, this.filter, false, this.ignoreExcludes) : new SourceFileManager(this.cachedUserSrcClassPath, this.ignoreExcludes)) : null, this.cachedAptSrcClassPath != null ? new AptSourceFileManager(this.cachedUserSrcClassPath, this.cachedAptSrcClassPath, siblings.getProvider()) : null, hasSources ? (this.outFileManager = new OutputFileManager(this.archiveProvider, this.outputClassPath, this.cachedUserSrcClassPath, this.cachedAptSrcClassPath, siblings.getProvider())) : null, this.memoryFileManager, marker, siblings);
        }
        return this.fileManager;
    }

    synchronized OutputFileManager getOutputFileManager() {
        this.getFileManager();
        return this.outFileManager;
    }

    private void fireChangeListenerStateChanged() {
        this.listenerList.fireChange();
    }

    static {
        block2: {
            EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
            log = Logger.getLogger(ClasspathInfo.class.getName());
            ClasspathInfoAccessor.setINSTANCE(new ClasspathInfoAccessorImpl());
            try {
                Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (!log.isLoggable(Level.SEVERE)) break block2;
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private static class CacheMarker
    implements GeneratedFileMarker {
        private final ClassPath userRoots;
        private final ClassPath aptRoots;
        private final boolean allowsWrite;
        private final Set<URL> srcOutput = new HashSet<URL>();
        private final Set<URL> clsOutput = new HashSet<URL>();
        private StringBuilder cachedValue;
        private Set<String> cachedResources;

        public CacheMarker(@NonNull ClassPath userRoots, ClassPath aptRoots, boolean allowsWrite) {
            assert (userRoots != null);
            this.userRoots = userRoots;
            this.aptRoots = aptRoots;
            this.allowsWrite = allowsWrite;
        }

        @Override
        public boolean allowsWrite() {
            return this.allowsWrite;
        }

        @Override
        public void mark(@NonNull URL result, GeneratedFileMarker.Type type) {
            if (this.allowsWrite) {
                switch (type) {
                    case SOURCE: {
                        this.srcOutput.add(result);
                        break;
                    }
                    case RESOURCE: {
                        this.clsOutput.add(result);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finished(@NonNull URL source) {
            try {
                if (!(!this.allowsWrite || this.srcOutput.isEmpty() && this.clsOutput.isEmpty())) {
                    File classCache;
                    boolean apt = false;
                    URL sourceRootURL = CacheMarker.getOwnerRoot(source, this.userRoots);
                    if (sourceRootURL == null) {
                        URL uRL = sourceRootURL = this.aptRoots != null ? CacheMarker.getOwnerRoot(source, this.aptRoots) : null;
                        if (sourceRootURL == null) {
                            return;
                        }
                        apt = true;
                    }
                    File sourceRoot = new File(sourceRootURL.toURI());
                    File file = classCache = apt ? new File(AptCacheForSourceQuery.getClassFolder(sourceRootURL).toURI()) : JavaIndex.getClassFolder(sourceRoot);
                    if (!this.srcOutput.isEmpty()) {
                        StringBuilder sb = new StringBuilder();
                        URL aptRootURL = AptCacheForSourceQuery.getAptFolder(sourceRootURL);
                        for (URL url : this.srcOutput) {
                            sb.append(FileObjects.getRelativePath(aptRootURL, url));
                            sb.append('\n');
                        }
                        File sourceFile = new File(source.toURI());
                        String relativePath = FileObjects.stripExtension(FileObjects.getRelativePath(sourceRoot, sourceFile));
                        File cacheFile = new File(classCache, relativePath + '.' + "rapt");
                        if (!cacheFile.getParentFile().exists()) {
                            cacheFile.getParentFile().mkdirs();
                        }
                        this.writeFile(cacheFile, sb, null);
                    }
                    if (!this.clsOutput.isEmpty()) {
                        File resFile = new File(classCache, "resouces.res");
                        HashSet<String> currentResources = new HashSet<String>();
                        StringBuilder sb = this.readFile(resFile, currentResources);
                        boolean changed = false;
                        for (URL url : this.clsOutput) {
                            String resPath = FileObjects.getRelativePath(classCache.toURI().toURL(), url);
                            if (!currentResources.add(resPath)) continue;
                            sb.append(resPath);
                            sb.append('\n');
                            changed = true;
                        }
                        if (changed) {
                            this.writeFile(resFile, sb, currentResources);
                        } else {
                            this.setCacheIfNeeded(sb, currentResources);
                        }
                    }
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            finally {
                this.srcOutput.clear();
                this.clsOutput.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeFile(File file, StringBuilder data, Set<String> currentResources) throws IOException {
            if (currentResources != null) {
                this.cachedValue = data;
                this.cachedResources = currentResources;
            }
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
            try {
                out.write(data.toString());
            }
            finally {
                ((Writer)out).close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StringBuilder readFile(File file, Set<? super String> currentResources) {
            StringBuilder sb;
            block8: {
                if (this.cachedResources != null) {
                    assert (this.cachedValue != null);
                    currentResources.addAll(this.cachedResources);
                    return this.cachedValue;
                }
                sb = new StringBuilder();
                try {
                    InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                    try {
                        int len;
                        char[] buffer = new char[1024];
                        while ((len = in.read(buffer)) > 0) {
                            sb.append(buffer, 0, len);
                        }
                    }
                    finally {
                        ((Reader)in).close();
                    }
                }
                catch (IOException ioe) {
                    if (sb.length() == 0) break block8;
                    sb = new StringBuilder();
                }
            }
            currentResources.addAll(Arrays.asList(sb.toString().split("\n")));
            return sb;
        }

        private void setCacheIfNeeded(StringBuilder data, Set<String> currentResources) {
            assert (data != null);
            assert (currentResources != null);
            if (this.cachedResources == null) {
                this.cachedValue = data;
                this.cachedResources = currentResources;
            }
        }

        private static URL getOwnerRoot(@NonNull URL source, @NonNull ClassPath cp) throws URISyntaxException {
            assert (source != null);
            assert (cp != null);
            for (ClassPath.Entry entry : cp.entries()) {
                URL rootURL = entry.getURL();
                if (!FileObjects.isParentOf(rootURL, source)) continue;
                return rootURL;
            }
            return null;
        }
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        @Override
        public JavaFileManager getFileManager(ClasspathInfo cpInfo) {
            return cpInfo.getFileManager();
        }

        @Override
        public ClassPath getCachedClassPath(ClasspathInfo cpInfo, PathKind kind) {
            return cpInfo.getCachedClassPath(kind);
        }

        @Override
        public ClasspathInfo create(ClassPath bootPath, ClassPath classPath, ClassPath sourcePath, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
            return ClasspathInfo.create(bootPath, classPath, sourcePath, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
        }

        @Override
        public ClasspathInfo create(@NonNull FileObject fo, JavaFileFilterImplementation filter, boolean backgroundCompilation, boolean ignoreExcludes, boolean hasMemoryFileManager, boolean useModifiedFiles) {
            return ClasspathInfo.create(fo, filter, backgroundCompilation, ignoreExcludes, hasMemoryFileManager, useModifiedFiles);
        }

        @Override
        public boolean registerVirtualSource(ClasspathInfo cpInfo, InferableJavaFileObject jfo) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException("The ClassPathInfo doesn't support memory JavacFileManager");
            }
            return cpInfo.memoryFileManager.register(jfo);
        }

        @Override
        public boolean unregisterVirtualSource(ClasspathInfo cpInfo, String fqn) throws UnsupportedOperationException {
            if (cpInfo.memoryFileManager == null) {
                throw new UnsupportedOperationException();
            }
            return cpInfo.memoryFileManager.unregister(fqn);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("roots".equals(event.getPropertyName())) {
                ClassPathListener classPathListener = this;
                synchronized (classPathListener) {
                    ClasspathInfo.this.fileManager = null;
                }
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

