/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.MappingRequest;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ApplicationParameter;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.Resource;

public class ApplicationContext
implements ServletContext {
    private HashMap attributes = new HashMap();
    private HashMap readOnlyAttributes = new HashMap();
    private StandardContext context = null;
    private static final ArrayList empty = new ArrayList();
    private ServletContext facade = new ApplicationContextFacade(this);
    private HashMap parameters = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private String basePath = null;

    public ApplicationContext(String basePath, StandardContext context) {
        this.context = context;
        this.basePath = basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        ArrayList list = new ArrayList();
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        Iterator keys = list.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.removeAttribute(key);
        }
    }

    public DirContext getResources() {
        return this.context.getResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeReadOnly(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.attributes.containsKey(name)) {
                this.readOnlyAttributes.put(name, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(this.attributes.keySet());
        }
    }

    public ServletContext getContext(String uri) {
        if (uri == null || !uri.startsWith("/")) {
            return null;
        }
        try {
            Host host = (Host)this.context.getParent();
            Context child = host.map(uri);
            if (child != null) {
                if (this.context.getCrossContext()) {
                    return child.getServletContext();
                }
                if (this.context == child) {
                    return this;
                }
                return null;
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInitParameter(String name) {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            if (System.getSecurityManager() != null) {
                PrivilegedGetInitParameter ip = new PrivilegedGetInitParameter(name);
                return (String)AccessController.doPrivileged(ip);
            }
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        this.mergeParameters();
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            if (System.getSecurityManager() != null) {
                PrivilegedGetInitParameterNames pn = new PrivilegedGetInitParameterNames();
                return (Enumeration)AccessController.doPrivileged(pn);
            }
            return new Enumerator(this.parameters.keySet());
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(".");
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(extension);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        ApplicationDispatcher dispatcher;
        if (name == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(name);
        if (wrapper == null) {
            return null;
        }
        if (System.getSecurityManager() != null) {
            PrivilegedGetNamedDispatcher nd = new PrivilegedGetNamedDispatcher(wrapper, name);
            dispatcher = (ApplicationDispatcher)AccessController.doPrivileged(nd);
        } else {
            dispatcher = new ApplicationDispatcher(wrapper, null, null, null, name);
        }
        return dispatcher;
    }

    public String getRealPath(String path) {
        if (!this.context.isFilesystemBased()) {
            return null;
        }
        File file = new File(this.basePath, path);
        return file.getAbsolutePath();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (path == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", path));
        }
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        String contextPath = this.context.getPath();
        if (contextPath == null) {
            contextPath = "";
        }
        if (System.getSecurityManager() != null) {
            PrivilegedGetRequestDispatcher dp = new PrivilegedGetRequestDispatcher(contextPath, path, queryString);
            return (RequestDispatcher)AccessController.doPrivileged(dp);
        }
        MappingRequest request = new MappingRequest(this.context.getPath(), contextPath + path, queryString);
        Wrapper wrapper = (Wrapper)this.context.map(request, true);
        if (wrapper == null) {
            return null;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        return new ApplicationDispatcher(wrapper, hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString(), null);
    }

    public URL getResource(String path) throws MalformedURLException {
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            String fullPath = this.context.getName() + path;
            String hostName = this.context.getParent().getName();
            try {
                resources.lookup(path);
                if (System.getSecurityManager() != null) {
                    try {
                        PrivilegedGetResource dp = new PrivilegedGetResource(hostName, fullPath, resources);
                        return (URL)AccessController.doPrivileged(dp);
                    }
                    catch (PrivilegedActionException pe) {
                        throw pe.getException();
                    }
                }
                return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(hostName, fullPath), (URLStreamHandler)new DirContextURLStreamHandler(resources));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if ((path = RequestUtil.normalize(path)) == null) {
            return null;
        }
        DirContext resources = this.context.getResources();
        if (resources != null) {
            try {
                Object resource = resources.lookup(path);
                if (resource instanceof Resource) {
                    return ((Resource)resource).streamContent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        DirContext resources = this.context.getResources();
        if (resources != null) {
            if (System.getSecurityManager() != null) {
                PrivilegedGetResourcePaths dp = new PrivilegedGetResourcePaths(resources, path);
                return (Set)AccessController.doPrivileged(dp);
            }
            return this.getResourcePathsInternal(resources, path);
        }
        return null;
    }

    private Set getResourcePathsInternal(DirContext resources, String path) {
        ResourceSet set = new ResourceSet();
        try {
            ApplicationContext.listCollectionPaths(set, resources, path);
        }
        catch (NamingException e) {
            return null;
        }
        set.setLocked(true);
        return set;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public Enumeration getServletNames() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Enumerator(empty);
                }
            });
        }
        return new Enumerator(empty);
    }

    public Enumeration getServlets() {
        if (System.getSecurityManager() != null) {
            return (Enumeration)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Enumerator(empty);
                }
            });
        }
        return new Enumerator(empty);
    }

    public void log(String message) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogMessage dp = new PrivilegedLogMessage(message);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(message);
        }
    }

    private void internalLog(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(message);
        }
    }

    public void log(Exception exception, String message) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogException dp = new PrivilegedLogException(exception, message);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(exception, message);
        }
    }

    private void internalLog(Exception exception, String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(exception, message);
        }
    }

    public void log(String message, Throwable throwable) {
        if (System.getSecurityManager() != null) {
            PrivilegedLogThrowable dp = new PrivilegedLogThrowable(message, throwable);
            AccessController.doPrivileged(dp);
        } else {
            this.internalLog(message, throwable);
        }
    }

    private void internalLog(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log(message, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object value = null;
        boolean found = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            value = this.attributes.get(name);
            this.attributes.remove(name);
        }
        Object[] listeners = this.context.getApplicationListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", listener);
                listener.attributeRemoved(event);
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                continue;
            }
            catch (Throwable t) {
                this.context.fireContainerEvent("afterContextAttributeRemoved", listener);
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldValue = null;
        boolean replaced = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            if (this.readOnlyAttributes.containsKey(name)) {
                return;
            }
            oldValue = this.attributes.get(name);
            if (oldValue != null) {
                replaced = true;
            }
            this.attributes.put(name, value);
        }
        Object[] listeners = this.context.getApplicationListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        ServletContextAttributeEvent event = null;
        event = replaced ? new ServletContextAttributeEvent(this.context.getServletContext(), name, oldValue) : new ServletContextAttributeEvent(this.context.getServletContext(), name, value);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners[i];
            try {
                if (replaced) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", listener);
                    listener.attributeReplaced(event);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", listener);
                listener.attributeAdded(event);
                this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                continue;
            }
            catch (Throwable t) {
                if (replaced) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", listener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", listener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), t);
            }
        }
    }

    ServletContext getFacade() {
        return this.facade;
    }

    private void mergeParameters() {
        if (this.parameters != null) {
            return;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        String[] names = this.context.findParameters();
        for (int i = 0; i < names.length; ++i) {
            results.put(names[i], this.context.findParameter(names[i]));
        }
        ApplicationParameter[] params = this.context.findApplicationParameters();
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getOverride()) {
                if (results.get(params[i].getName()) != null) continue;
                results.put(params[i].getName(), params[i].getValue());
                continue;
            }
            results.put(params[i].getName(), params[i].getValue());
        }
        this.parameters = results;
    }

    private static void listCollectionPaths(Set set, DirContext resources, String path) throws NamingException {
        NamingEnumeration<Binding> childPaths = resources.listBindings(path);
        while (childPaths.hasMoreElements()) {
            Binding binding = (Binding)childPaths.nextElement();
            String name = binding.getName();
            StringBuffer childPath = new StringBuffer(path);
            if (!"/".equals(path) && !path.endsWith("/")) {
                childPath.append("/");
            }
            childPath.append(name);
            Object object = binding.getObject();
            if (object instanceof DirContext) {
                childPath.append("/");
            }
            set.add(childPath.toString());
        }
    }

    public static String getJNDIUri(String hostName, String path) {
        if (!path.startsWith("/")) {
            return "/" + hostName + "/" + path;
        }
        return "/" + hostName + path;
    }

    protected class PrivilegedLogThrowable
    implements PrivilegedAction {
        private String message;
        private Throwable throwable;

        PrivilegedLogThrowable(String message, Throwable throwable) {
            this.message = message;
            this.throwable = throwable;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message, this.throwable);
            return null;
        }
    }

    protected class PrivilegedLogException
    implements PrivilegedAction {
        private String message;
        private Exception exception;

        PrivilegedLogException(Exception exception, String message) {
            this.message = message;
            this.exception = exception;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.exception, this.message);
            return null;
        }
    }

    protected class PrivilegedLogMessage
    implements PrivilegedAction {
        private String message;

        PrivilegedLogMessage(String message) {
            this.message = message;
        }

        public Object run() {
            ApplicationContext.this.internalLog(this.message);
            return null;
        }
    }

    protected class PrivilegedGetResourcePaths
    implements PrivilegedAction {
        private String path;
        private DirContext resources;

        PrivilegedGetResourcePaths(DirContext resources, String path) {
            this.resources = resources;
            this.path = path;
        }

        public Object run() {
            return ApplicationContext.this.getResourcePathsInternal(this.resources, this.path);
        }
    }

    protected class PrivilegedGetResource
    implements PrivilegedExceptionAction {
        private String path;
        private String host;
        private DirContext resources;

        PrivilegedGetResource(String host, String path, DirContext resources) {
            this.host = host;
            this.path = path;
            this.resources = resources;
        }

        public Object run() throws Exception {
            return new URL("jndi", null, 0, ApplicationContext.getJNDIUri(this.host, this.path), (URLStreamHandler)new DirContextURLStreamHandler(this.resources));
        }
    }

    protected class PrivilegedGetRequestDispatcher
    implements PrivilegedAction {
        private String contextPath;
        private String relativeURI;
        private String queryString;

        PrivilegedGetRequestDispatcher(String contextPath, String relativeURI, String queryString) {
            this.contextPath = contextPath;
            this.relativeURI = relativeURI;
            this.queryString = queryString;
        }

        public Object run() {
            MappingRequest request = new MappingRequest(ApplicationContext.this.context.getPath(), this.contextPath + this.relativeURI, this.queryString);
            Wrapper wrapper = (Wrapper)ApplicationContext.this.context.map(request, true);
            if (wrapper == null) {
                return null;
            }
            HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
            return new ApplicationDispatcher(wrapper, hrequest.getServletPath(), hrequest.getPathInfo(), hrequest.getQueryString(), null);
        }
    }

    protected class PrivilegedGetNamedDispatcher
    implements PrivilegedAction {
        private Wrapper wrapper;
        private String name;

        PrivilegedGetNamedDispatcher(Wrapper wrapper, String name) {
            this.wrapper = wrapper;
            this.name = name;
        }

        public Object run() {
            return new ApplicationDispatcher(this.wrapper, null, null, null, this.name);
        }
    }

    protected class PrivilegedGetInitParameterNames
    implements PrivilegedAction {
        PrivilegedGetInitParameterNames() {
        }

        public Object run() {
            return new Enumerator(ApplicationContext.this.parameters.keySet());
        }
    }

    protected class PrivilegedGetInitParameter
    implements PrivilegedAction {
        private String name;

        PrivilegedGetInitParameter(String name) {
            this.name = name;
        }

        public Object run() {
            return (String)ApplicationContext.this.parameters.get(this.name);
        }
    }
}

