/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.realm;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.Lists;
import org.apache.webapp.admin.realm.DataSourceRealmForm;
import org.apache.webapp.admin.realm.JDBCRealmForm;
import org.apache.webapp.admin.realm.JNDIRealmForm;
import org.apache.webapp.admin.realm.MemoryRealmForm;
import org.apache.webapp.admin.realm.UserDatabaseRealmForm;

public class EditRealmAction
extends Action {
    private MBeanServer mBServer = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Locale locale = this.getLocale(request);
        MessageResources resources = this.getResources(request);
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        ObjectName rname = null;
        try {
            rname = new ObjectName(request.getParameter("select"));
        }
        catch (Exception e) {
            String message = resources.getMessage(locale, "error.realmName.bad", (Object)request.getParameter("select"));
            this.getServlet().log(message);
            response.sendError(400, message);
            return null;
        }
        String realmType = null;
        String attribute = null;
        try {
            attribute = "className";
            String className = (String)this.mBServer.getAttribute(rname, attribute);
            int period = className.lastIndexOf(".");
            if (period >= 0) {
                realmType = className.substring(period + 1);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
            return null;
        }
        if ("UserDatabaseRealm".equalsIgnoreCase(realmType)) {
            this.setUpUserDatabaseRealm(rname, request, response);
        } else if ("MemoryRealm".equalsIgnoreCase(realmType)) {
            this.setUpMemoryRealm(rname, request, response);
        } else if ("JDBCRealm".equalsIgnoreCase(realmType)) {
            this.setUpJDBCRealm(rname, request, response);
        } else if ("JNDIRealm".equalsIgnoreCase(realmType)) {
            this.setUpJNDIRealm(rname, request, response);
        } else if ("DataSourceRealm".equalsIgnoreCase(realmType)) {
            this.setUpDataSourceRealm(rname, request, response);
        }
        return mapping.findForward(realmType);
    }

    private void setUpUserDatabaseRealm(ObjectName rname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        UserDatabaseRealmForm realmFm = new UserDatabaseRealmForm();
        session.setAttribute("userDatabaseRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Edit");
        realmFm.setObjectName(rname.toString());
        String realmType = "UserDatabaseRealm";
        StringBuffer sb = new StringBuffer("");
        String host = rname.getKeyProperty("host");
        String context = rname.getKeyProperty("path");
        if (host != null) {
            sb.append("Host (" + host + ") > ");
        }
        if (context != null) {
            sb.append("Context (" + context + ") > ");
        }
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.realm"));
        realmFm.setNodeLabel(sb.toString());
        realmFm.setRealmType(realmType);
        realmFm.setAllowDeletion(this.allowDeletion(rname, request));
        String attribute = null;
        try {
            attribute = "resourceName";
            realmFm.setResource((String)this.mBServer.getAttribute(rname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpMemoryRealm(ObjectName rname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        MemoryRealmForm realmFm = new MemoryRealmForm();
        session.setAttribute("memoryRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Edit");
        realmFm.setObjectName(rname.toString());
        String realmType = "MemoryRealm";
        StringBuffer sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.realm"));
        sb.append(" (");
        sb.append(realmType);
        sb.append(")");
        realmFm.setNodeLabel(sb.toString());
        realmFm.setRealmType(realmType);
        realmFm.setAllowDeletion(this.allowDeletion(rname, request));
        String attribute = null;
        try {
            attribute = "pathname";
            realmFm.setPathName((String)this.mBServer.getAttribute(rname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpJDBCRealm(ObjectName rname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JDBCRealmForm realmFm = new JDBCRealmForm();
        session.setAttribute("jdbcRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Edit");
        realmFm.setObjectName(rname.toString());
        String realmType = "JDBCRealm";
        StringBuffer sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.realm"));
        sb.append(" (");
        sb.append(realmType);
        sb.append(")");
        realmFm.setNodeLabel(sb.toString());
        realmFm.setRealmType(realmType);
        realmFm.setAllowDeletion(this.allowDeletion(rname, request));
        String attribute = null;
        try {
            attribute = "digest";
            realmFm.setDigest((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "driverName";
            realmFm.setDriver((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "roleNameCol";
            realmFm.setRoleNameCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userNameCol";
            realmFm.setUserNameCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userCredCol";
            realmFm.setPasswordCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userTable";
            realmFm.setUserTable((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userRoleTable";
            realmFm.setRoleTable((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionName";
            realmFm.setConnectionName((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionPassword";
            realmFm.setConnectionPassword((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionURL";
            realmFm.setConnectionURL((String)this.mBServer.getAttribute(rname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpJNDIRealm(ObjectName rname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        JNDIRealmForm realmFm = new JNDIRealmForm();
        session.setAttribute("jndiRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Edit");
        realmFm.setObjectName(rname.toString());
        String realmType = "JNDIRealm";
        StringBuffer sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.realm"));
        sb.append(" (");
        sb.append(realmType);
        sb.append(")");
        realmFm.setNodeLabel(sb.toString());
        realmFm.setRealmType(realmType);
        realmFm.setSearchVals(Lists.getBooleanValues());
        realmFm.setAllowDeletion(this.allowDeletion(rname, request));
        String attribute = null;
        try {
            attribute = "digest";
            realmFm.setDigest((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userSubtree";
            realmFm.setUserSubtree(((Boolean)this.mBServer.getAttribute(rname, attribute)).toString());
            attribute = "roleSubtree";
            realmFm.setRoleSubtree(((Boolean)this.mBServer.getAttribute(rname, attribute)).toString());
            attribute = "userRoleName";
            realmFm.setUserRoleName((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "roleName";
            realmFm.setRoleName((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "roleBase";
            realmFm.setRoleBase((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "roleSearch";
            realmFm.setRolePattern((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "contextFactory";
            realmFm.setContextFactory((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userPassword";
            realmFm.setUserPassword((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userPattern";
            realmFm.setUserPattern((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userSearch";
            realmFm.setUserSearch((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionName";
            realmFm.setConnectionName((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionPassword";
            realmFm.setConnectionPassword((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "connectionURL";
            realmFm.setConnectionURL((String)this.mBServer.getAttribute(rname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private void setUpDataSourceRealm(ObjectName rname, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MessageResources resources = this.getResources(request);
        HttpSession session = request.getSession();
        Locale locale = this.getLocale(request);
        DataSourceRealmForm realmFm = new DataSourceRealmForm();
        session.setAttribute("dataSourceRealmForm", (Object)realmFm);
        realmFm.setAdminAction("Edit");
        realmFm.setObjectName(rname.toString());
        String realmType = "DataSourceRealm";
        StringBuffer sb = new StringBuffer();
        sb.append(resources.getMessage(locale, "server.service.treeBuilder.realm"));
        sb.append(" (");
        sb.append(realmType);
        sb.append(")");
        realmFm.setNodeLabel(sb.toString());
        realmFm.setRealmType(realmType);
        realmFm.setAllowDeletion(this.allowDeletion(rname, request));
        realmFm.setBooleanVals(Lists.getBooleanValues());
        String attribute = null;
        try {
            attribute = "dataSourceName";
            realmFm.setDataSourceName((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "digest";
            realmFm.setDigest((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "localDataSource";
            realmFm.setLocalDataSource(((Boolean)this.mBServer.getAttribute(rname, attribute)).toString());
            attribute = "roleNameCol";
            realmFm.setRoleNameCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userCredCol";
            realmFm.setUserCredCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userNameCol";
            realmFm.setUserNameCol((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userRoleTable";
            realmFm.setUserRoleTable((String)this.mBServer.getAttribute(rname, attribute));
            attribute = "userTable";
            realmFm.setUserTable((String)this.mBServer.getAttribute(rname, attribute));
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), t);
            response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
        }
    }

    private String allowDeletion(ObjectName rname, HttpServletRequest request) {
        boolean retVal;
        block4: {
            retVal = true;
            try {
                String adminHost = request.getServerName();
                String adminContext = request.getContextPath();
                String thisHost = rname.getKeyProperty("host");
                String thisContext = rname.getKeyProperty("path");
                if (thisContext != null) {
                    retVal = !thisContext.equalsIgnoreCase(adminContext);
                    break block4;
                }
                if (thisHost != null) {
                    retVal = !thisHost.equalsIgnoreCase(adminHost);
                    break block4;
                }
                return "false";
            }
            catch (Exception e) {
                this.getServlet().log("Error getting admin service, host or context", (Throwable)e);
            }
        }
        return new Boolean(retVal).toString();
    }
}

