/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.BaseKeyAgreementParty;
import gnu.javax.crypto.key.KeyAgreementException;
import gnu.javax.crypto.sasl.srp.SRP;
import java.math.BigInteger;

public abstract class SRP6KeyAgreement
extends BaseKeyAgreementParty {
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.srp6.ka.prng";
    public static final String SHARED_MODULUS = "gnu.crypto.srp6.ka.N";
    public static final String GENERATOR = "gnu.crypto.srp6.ka.g";
    public static final String HASH_FUNCTION = "gnu.crypto.srp6.ka.H";
    public static final String USER_IDENTITY = "gnu.crypto.srp6.ka.I";
    public static final String USER_PASSWORD = "gnu.crypto.srp6.ka.p";
    public static final String HOST_PASSWORD_DB = "gnu.crypto.srp6.ka.password.db";
    protected static final BigInteger THREE;
    protected SRP srp;
    protected BigInteger N;
    protected BigInteger g;
    protected BigInteger K;

    protected SRP6KeyAgreement() {
        super("srp6");
    }

    protected byte[] engineSharedSecret() throws KeyAgreementException {
        return Util.trim(this.K);
    }

    protected void engineReset() {
        this.srp = null;
        this.N = null;
        this.g = null;
        this.K = null;
    }

    protected BigInteger uValue(BigInteger bigInteger, BigInteger bigInteger2) {
        IMessageDigest iMessageDigest = this.srp.newDigest();
        byte[] byArray = Util.trim(bigInteger);
        iMessageDigest.update(byArray, 0, byArray.length);
        byArray = Util.trim(bigInteger2);
        iMessageDigest.update(byArray, 0, byArray.length);
        return new BigInteger(1, iMessageDigest.digest());
    }

    static {
        SOURCE_OF_RANDOMNESS = SOURCE_OF_RANDOMNESS;
        SHARED_MODULUS = SHARED_MODULUS;
        GENERATOR = GENERATOR;
        HASH_FUNCTION = HASH_FUNCTION;
        USER_IDENTITY = USER_IDENTITY;
        USER_PASSWORD = USER_PASSWORD;
        HOST_PASSWORD_DB = HOST_PASSWORD_DB;
        THREE = BigInteger.valueOf(3);
    }
}

