/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;

public final class CertPathEntry
extends PrimitiveEntry {
    public static final int TYPE = 8;
    private Certificate[] path;

    public CertPathEntry(Certificate[] certificateArray, Date date, Properties properties) {
        super(8, date, properties);
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("no certificate path");
        }
        this.path = (Certificate[])certificateArray.clone();
    }

    private CertPathEntry() {
        super(8);
    }

    public static CertPathEntry decode(DataInputStream dataInputStream) throws IOException {
        CertPathEntry certPathEntry = new CertPathEntry();
        certPathEntry.properties.decode(dataInputStream);
        certPathEntry.makeCreationDate();
        int n = dataInputStream.readInt();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            certPathEntry.path = (Certificate[])certificateFactory.generateCertificates(meteredInputStream).toArray(new Certificate[0]);
        }
        catch (CertificateException certificateException) {
            throw new MalformedKeyringException(certificateException.toString());
        }
        return certPathEntry;
    }

    public Certificate[] getCertPath() {
        return this.path;
    }

    protected void encodePayload() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        Object var2_2 = null;
        try {
            for (int i = 0; i < this.path.length; ++i) {
                byteArrayOutputStream.write(this.path[i].getEncoded());
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new IOException(certificateEncodingException.toString());
        }
        this.payload = byteArrayOutputStream.toByteArray();
    }
}

