/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Enumerated;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class CompressionMethod
implements Enumerated {
    static final CompressionMethod NULL = new CompressionMethod(0);
    static final CompressionMethod ZLIB = new CompressionMethod(1);
    private final int value;

    private CompressionMethod(int n) {
        this.value = n;
    }

    static CompressionMethod read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException("unexpected end of input stream");
        }
        switch (n & 0xFF) {
            case 0: {
                return NULL;
            }
            case 1: {
                return ZLIB;
            }
        }
        return new CompressionMethod(n);
    }

    public byte[] getEncoded() {
        return new byte[]{(byte)this.value};
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "null";
            }
            case 1: {
                return "zlib";
            }
        }
        return "unknown(" + this.value + ")";
    }
}

