/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.PRNGFactory;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.net.ssl.Base64;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLSocket;
import gnu.javax.net.ssl.provider.Session;
import gnu.javax.net.ssl.provider.SessionContext;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XMLSessionContext
extends SessionContext {
    private final File file = new File(Util.getSecurityProperty("jessie.SessionContext.xml.file"));
    private final IRandom pbekdf;
    private final boolean compress;
    private final SecureRandom random;
    private boolean encoding;

    XMLSessionContext() throws IOException, SAXException {
        String string = Util.getSecurityProperty("jessie.SessionContext.xml.password");
        this.compress = new Boolean(Util.getSecurityProperty("jessie.SessionContext.xml.compress"));
        if (string == null) {
            string = "";
        }
        this.pbekdf = PRNGFactory.getInstance("PBKDF2-HMAC-SHA1");
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.pbe.password", string.toCharArray());
        hashMap.put("gnu.crypto.pbe.salt", new byte[8]);
        hashMap.put("gnu.crypto.pbe.iteration.count", new Integer(1000));
        this.pbekdf.init(hashMap);
        this.encoding = false;
        if (this.file.exists()) {
            this.decode();
        }
        this.encoding = true;
        this.random = new SecureRandom();
    }

    synchronized boolean addSession(Session.ID iD, Session session) {
        boolean bl = super.addSession(iD, session);
        if (bl && this.encoding) {
            try {
                this.encode();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    synchronized void notifyAccess(Session session) {
        try {
            this.encode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized boolean removeSession(Session.ID iD) {
        if (super.removeSession(iD)) {
            try {
                this.encode();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void decode() throws IOException, SAXException {
        SAXParser sAXParser = null;
        try {
            sAXParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        SAXHandler sAXHandler = new SAXHandler(this, this, this.pbekdf);
        InputStream inputStream = null;
        inputStream = this.compress ? new GZIPInputStream(new FileInputStream(this.file)) : new FileInputStream(this.file);
        sAXParser.parse(inputStream, (DefaultHandler)sAXHandler);
    }

    private void encode() throws IOException {
        IMode iMode = ModeFactory.getInstance("CBC", "AES", 16);
        HashMap hashMap = new HashMap();
        IMac iMac = MacFactory.getInstance("HMAC-SHA1");
        HashMap hashMap2 = new HashMap();
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[48];
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        hashMap.put("gnu.crypto.mode.iv", byArray2);
        hashMap.put("gnu.crypto.mode.state", new Integer(1));
        hashMap2.put("gnu.crypto.mac.key.material", byArray3);
        PrintStream printStream = null;
        printStream = this.compress ? new PrintStream(new GZIPOutputStream(new FileOutputStream(this.file))) : new PrintStream(new FileOutputStream(this.file));
        printStream.println("<?xml version=\"1.0\"?>");
        printStream.println("<!DOCTYPE sessions [");
        printStream.println("  <!ELEMENT sessions (session*)>");
        printStream.println("  <!ATTLIST sessions size CDATA \"0\">");
        printStream.println("  <!ATTLIST sessions timeout CDATA \"86400\">");
        printStream.println("  <!ELEMENT session (peer, certificates?, secret)>");
        printStream.println("  <!ATTLIST session id CDATA #REQUIRED>");
        printStream.println("  <!ATTLIST session protocol (SSLv3|TLSv1|TLSv1.1) #REQUIRED>");
        printStream.println("  <!ATTLIST session suite CDATA #REQUIRED>");
        printStream.println("  <!ATTLIST session created CDATA #REQUIRED>");
        printStream.println("  <!ATTLIST session timestamp CDATA #REQUIRED>");
        printStream.println("  <!ELEMENT peer (certificates?)>");
        printStream.println("  <!ATTLIST peer host CDATA #REQUIRED>");
        printStream.println("  <!ELEMENT certificates (#PCDATA)>");
        printStream.println("  <!ATTLIST certificates type CDATA \"X.509\">");
        printStream.println("  <!ELEMENT secret (#PCDATA)>");
        printStream.println("  <!ATTLIST secret salt CDATA #REQUIRED>");
        printStream.println("]>");
        printStream.println();
        printStream.print("<sessions size=\"");
        printStream.print(this.cacheSize);
        printStream.print("\" timeout=\"");
        printStream.print(this.timeout);
        printStream.println("\">");
        Iterator iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            Map.Entry entry = (Map.Entry)iterator.next();
            Session.ID iD = (Session.ID)entry.getKey();
            Session session = (Session)entry.getValue();
            if (!session.valid) continue;
            printStream.print("<session id=\"");
            printStream.print(Base64.encode(iD.getId(), 0));
            printStream.print("\" suite=\"");
            printStream.print(session.getCipherSuite());
            printStream.print("\" protocol=\"");
            printStream.print(session.getProtocol());
            printStream.print("\" created=\"");
            printStream.print(session.getCreationTime());
            printStream.print("\" timestamp=\"");
            printStream.print(session.getLastAccessedTime());
            printStream.println("\">");
            printStream.print("<peer host=\"");
            printStream.print(session.getPeerHost());
            printStream.println("\">");
            Certificate[] certificateArray = session.getPeerCertificates();
            if (certificateArray != null && certificateArray.length > 0) {
                printStream.print("<certificates type=\"");
                printStream.print(certificateArray[0].getType());
                printStream.println("\">");
                for (n = 0; n < certificateArray.length; ++n) {
                    printStream.println("-----BEGIN CERTIFICATE-----");
                    try {
                        printStream.print(Base64.encode(certificateArray[n].getEncoded(), 70));
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IOException(certificateEncodingException.toString());
                    }
                    printStream.println("-----END CERTIFICATE-----");
                }
                printStream.println("</certificates>");
            }
            printStream.println("</peer>");
            certificateArray = session.getLocalCertificates();
            if (certificateArray != null && certificateArray.length > 0) {
                printStream.print("<certificates type=\"");
                printStream.print(certificateArray[0].getType());
                printStream.println("\">");
                for (n = 0; n < certificateArray.length; ++n) {
                    printStream.println("-----BEGIN CERTIFICATE-----");
                    try {
                        printStream.print(Base64.encode(certificateArray[n].getEncoded(), 70));
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IOException(certificateEncodingException.toString());
                    }
                    printStream.println("-----END CERTIFICATE-----");
                }
                printStream.println("</certificates>");
            }
            this.random.nextBytes(byArray4);
            this.pbekdf.init(Collections.singletonMap("gnu.crypto.pbe.salt", byArray4));
            try {
                this.pbekdf.nextBytes(byArray, 0, byArray.length);
                this.pbekdf.nextBytes(byArray2, 0, byArray2.length);
                this.pbekdf.nextBytes(byArray3, 0, byArray3.length);
                iMode.reset();
                iMode.init(hashMap);
                iMac.init(hashMap2);
            }
            catch (Exception exception) {
                throw new Error(exception.toString());
            }
            for (n = 0; n < session.masterSecret.length; n += 16) {
                iMode.update(session.masterSecret, n, byArray5, n);
            }
            iMac.update(byArray5, 0, byArray5.length);
            byte[] byArray6 = iMac.digest();
            printStream.print("<secret salt=\"");
            printStream.print(Base64.encode(byArray4, 0));
            printStream.println("\">");
            printStream.print(Base64.encode(Util.concat(byArray5, byArray6), 70));
            printStream.println("</secret>");
            printStream.println("</session>");
        }
        printStream.println("</sessions>");
        printStream.close();
    }

    private class SAXHandler
    extends DefaultHandler {
        private /* synthetic */ XMLSessionContext this$0;
        private SessionContext context;
        private Session current;
        private IRandom pbekdf;
        private StringBuffer buf;
        private String certType;
        private int state;
        private IMode cipher;
        private HashMap cipherAttr;
        private IMac mac;
        private HashMap macAttr;
        private byte[] key;
        private byte[] iv;
        private byte[] mackey;
        private static final int START = 0;
        private static final int SESSIONS = 1;
        private static final int SESSION = 2;
        private static final int PEER = 3;
        private static final int PEER_CERTS = 4;
        private static final int CERTS = 5;
        private static final int SECRET = 6;

        SAXHandler(XMLSessionContext xMLSessionContext, SessionContext sessionContext, IRandom iRandom) {
            this.this$0 = xMLSessionContext;
            this.context = sessionContext;
            this.pbekdf = iRandom;
            this.buf = new StringBuffer();
            this.state = 0;
            this.cipher = ModeFactory.getInstance("CBC", "AES", 16);
            this.cipherAttr = new HashMap();
            this.mac = MacFactory.getInstance("HMAC-SHA1");
            this.macAttr = new HashMap();
            this.key = new byte[32];
            this.iv = new byte[16];
            this.mackey = new byte[20];
            this.cipherAttr.put("gnu.crypto.cipher.key.material", this.key);
            this.cipherAttr.put("gnu.crypto.mode.iv", this.iv);
            this.cipherAttr.put("gnu.crypto.mode.state", new Integer(2));
            this.macAttr.put("gnu.crypto.mac.key.material", this.mackey);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            string3 = string3.toLowerCase();
            switch (this.state) {
                case 0: {
                    if (string3.equals("sessions")) {
                        try {
                            this.this$0.timeout = Integer.parseInt(attributes.getValue("timeout"));
                            this.this$0.cacheSize = Integer.parseInt(attributes.getValue("size"));
                            if (this.this$0.timeout <= 0 || this.this$0.cacheSize < 0) {
                                throw new SAXException("timeout or cache size out of range");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new SAXException(numberFormatException);
                        }
                        this.state = 1;
                        break;
                    }
                    throw new SAXException("expecting sessions");
                }
                case 1: {
                    if (string3.equals("session")) {
                        try {
                            this.current = new Session(Long.parseLong(attributes.getValue("created")));
                            this.current.enabledSuites = new ArrayList(SSLSocket.supportedSuites);
                            this.current.enabledProtocols = new TreeSet(SSLSocket.supportedProtocols);
                            this.current.context = this.context;
                            this.current.sessionId = new Session.ID(Base64.decode(attributes.getValue("id")));
                            this.current.setLastAccessedTime(Long.parseLong(attributes.getValue("timestamp")));
                        }
                        catch (Exception exception) {
                            throw new SAXException(exception);
                        }
                        String string4 = attributes.getValue("protocol");
                        if (string4.equals("SSLv3")) {
                            this.current.protocol = ProtocolVersion.SSL_3;
                        } else if (string4.equals("TLSv1")) {
                            this.current.protocol = ProtocolVersion.TLS_1;
                        } else if (string4.equals("TLSv1.1")) {
                            this.current.protocol = ProtocolVersion.TLS_1_1;
                        } else {
                            throw new SAXException("bad protocol: " + string4);
                        }
                        this.current.cipherSuite = CipherSuite.forName(attributes.getValue("suite"));
                        this.state = 2;
                        break;
                    }
                    throw new SAXException("expecting session");
                }
                case 2: {
                    if (string3.equals("peer")) {
                        this.current.peerHost = attributes.getValue("host");
                        this.state = 3;
                        break;
                    }
                    if (string3.equals("certificates")) {
                        this.certType = attributes.getValue("type");
                        this.state = 5;
                        break;
                    }
                    if (string3.equals("secret")) {
                        byte[] byArray = null;
                        try {
                            byArray = Base64.decode(attributes.getValue("salt"));
                        }
                        catch (IOException iOException) {
                            throw new SAXException(iOException);
                        }
                        this.pbekdf.init(Collections.singletonMap("gnu.crypto.pbe.salt", byArray));
                        this.state = 6;
                        break;
                    }
                    throw new SAXException("bad element: " + string3);
                }
                case 3: {
                    if (string3.equals("certificates")) {
                        this.certType = attributes.getValue("type");
                        this.state = 4;
                        break;
                    }
                    throw new SAXException("bad element: " + string3);
                }
                default: {
                    throw new SAXException("bad element: " + string3);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            string3 = string3.toLowerCase();
            switch (this.state) {
                case 1: {
                    if (string3.equals("sessions")) {
                        this.state = 0;
                        break;
                    }
                    throw new SAXException("expecting sessions");
                }
                case 2: {
                    if (string3.equals("session")) {
                        this.current.valid = true;
                        this.context.addSession(this.current.sessionId, this.current);
                        this.state = 1;
                        break;
                    }
                    throw new SAXException("expecting session");
                }
                case 3: {
                    if (string3.equals("peer")) {
                        this.state = 2;
                        break;
                    }
                    throw new SAXException("unexpected element: " + string3);
                }
                case 4: {
                    if (string3.equals("certificates")) {
                        try {
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(this.certType);
                            this.current.peerCerts = (Certificate[])certificateFactory.generateCertificates(new ByteArrayInputStream(this.buf.toString().getBytes())).toArray(new Certificate[0]);
                        }
                        catch (Exception exception) {
                            throw new SAXException(exception);
                        }
                        this.current.peerVerified = true;
                        this.state = 3;
                        break;
                    }
                    throw new SAXException("unexpected element: " + string3);
                }
                case 5: {
                    if (string3.equals("certificates")) {
                        try {
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(this.certType);
                            this.current.localCerts = (Certificate[])certificateFactory.generateCertificates(new ByteArrayInputStream(this.buf.toString().getBytes())).toArray(new Certificate[0]);
                        }
                        catch (Exception exception) {
                            throw new SAXException(exception);
                        }
                        this.state = 2;
                        break;
                    }
                    throw new SAXException("unexpected element: " + string3);
                }
                case 6: {
                    if (string3.equals("secret")) {
                        int n;
                        byte[] byArray = null;
                        try {
                            byArray = Base64.decode(this.buf.toString());
                            if (byArray.length != 68) {
                                throw new IOException("encrypted secret not 68 bytes long");
                            }
                            this.pbekdf.nextBytes(this.key, 0, this.key.length);
                            this.pbekdf.nextBytes(this.iv, 0, this.iv.length);
                            this.pbekdf.nextBytes(this.mackey, 0, this.mackey.length);
                            this.cipher.reset();
                            this.cipher.init(this.cipherAttr);
                            this.mac.init(this.macAttr);
                        }
                        catch (Exception exception) {
                            throw new SAXException(exception);
                        }
                        this.mac.update(byArray, 0, 48);
                        byte[] byArray2 = this.mac.digest();
                        for (n = 0; n < byArray2.length; ++n) {
                            if (byArray2[n] == byArray[48 + n]) continue;
                            throw new SAXException("MAC mismatch");
                        }
                        this.current.masterSecret = new byte[48];
                        for (n = 0; n < this.current.masterSecret.length; n += 16) {
                            this.cipher.update(byArray, n, this.current.masterSecret, n);
                        }
                        this.state = 2;
                        break;
                    }
                    throw new SAXException("unexpected element: " + string3);
                }
                default: {
                    throw new SAXException("unexpected element: " + string3);
                }
            }
            this.buf.setLength(0);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state != 5 && this.state != 4 && this.state != 6) {
                throw new SAXException("illegal character data");
            }
            this.buf.append(cArray, n, n2);
        }
    }
}

