/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import gnu.classpath.SystemProperties;
import gnu.java.lang.management.ClassLoadingMXBeanImpl;
import gnu.java.lang.management.CompilationMXBeanImpl;
import gnu.java.lang.management.GarbageCollectorMXBeanImpl;
import gnu.java.lang.management.MemoryMXBeanImpl;
import gnu.java.lang.management.MemoryManagerMXBeanImpl;
import gnu.java.lang.management.MemoryPoolMXBeanImpl;
import gnu.java.lang.management.OperatingSystemMXBeanImpl;
import gnu.java.lang.management.RuntimeMXBeanImpl;
import gnu.java.lang.management.ThreadMXBeanImpl;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.management.VMManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.NotCompliantMBeanException;

public class ManagementFactory {
    private static OperatingSystemMXBean osBean;
    private static RuntimeMXBean runtimeBean;
    private static ClassLoadingMXBean classLoadingBean;
    private static ThreadMXBean threadBean;
    private static MemoryMXBean memoryBean;
    private static CompilationMXBean compilationBean;

    private ManagementFactory() {
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        if (osBean == null) {
            try {
                osBean = new OperatingSystemMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the operating system bean is not a compliant management bean.");
            }
        }
        return osBean;
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        if (runtimeBean == null) {
            try {
                runtimeBean = new RuntimeMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the runtime bean is not a compliant management bean.");
            }
        }
        return runtimeBean;
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        if (classLoadingBean == null) {
            try {
                classLoadingBean = new ClassLoadingMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the class loading bean is not a compliant management bean.");
            }
        }
        return classLoadingBean;
    }

    public static ThreadMXBean getThreadMXBean() {
        if (threadBean == null) {
            try {
                threadBean = new ThreadMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the thread bean is not a compliant management bean.");
            }
        }
        return threadBean;
    }

    public static MemoryMXBean getMemoryMXBean() {
        if (memoryBean == null) {
            try {
                memoryBean = new MemoryMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory bean is not a compliant management bean.");
            }
        }
        return memoryBean;
    }

    public static CompilationMXBean getCompilationMXBean() {
        if (compilationBean == null && SystemProperties.getProperty("gnu.java.compiler.name") != null) {
            try {
                compilationBean = new CompilationMXBeanImpl();
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the compilation bean is not a compliant management bean.");
            }
        }
        return compilationBean;
    }

    public static List getMemoryPoolMXBeans() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = VMManagementFactory.getMemoryPoolNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new MemoryPoolMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory pool bean, " + i + ", is " + "not a compliant management bean.");
            }
        }
        return arrayList;
    }

    public static List getMemoryManagerMXBeans() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = VMManagementFactory.getMemoryManagerNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new MemoryManagerMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the memory manager bean, " + i + ", is " + "not a compliant management bean.");
            }
        }
        arrayList.addAll(ManagementFactory.getGarbageCollectorMXBeans());
        return arrayList;
    }

    public static List getGarbageCollectorMXBeans() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = VMManagementFactory.getGarbageCollectorNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                arrayList.add(new GarbageCollectorMXBeanImpl(stringArray[i]));
                continue;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                throw new InternalError("The GNU implementation of the garbage collector bean, " + i + ", is not a compliant management " + "bean.");
            }
        }
        return arrayList;
    }
}

