/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.FloatBufferImpl;

public abstract class FloatBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    float[] backing_buffer;

    FloatBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public static FloatBuffer allocate(int n) {
        return new FloatBufferImpl(n);
    }

    public static final FloatBuffer wrap(float[] fArray, int n, int n2) {
        return new FloatBufferImpl(fArray, 0, fArray.length, n + n2, n, -1, false);
    }

    public static final FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public FloatBuffer get(float[] fArray, int n, int n2) {
        Buffer.checkArraySize(fArray.length, n, n2);
        this.checkForUnderflow(n2);
        for (int i = n; i < n + n2; ++i) {
            fArray[i] = this.get();
        }
        return this;
    }

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(floatBuffer.remaining());
        if (floatBuffer.remaining() > 0) {
            float[] fArray = new float[floatBuffer.remaining()];
            floatBuffer.get(fArray);
            this.put(fArray);
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        Buffer.checkArraySize(fArray.length, n, n2);
        this.checkForOverflow(n2);
        for (int i = n; i < n + n2; ++i) {
            this.put(fArray[i]);
        }
        return this;
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final float[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.get(this.position())) + 31;
        int n2 = 1;
        for (int i = this.position() + 1; i < this.limit(); ++i) {
            n += (Float.floatToIntBits(this.get(i)) + 30) * (n2 *= 31);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof FloatBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    public int compareTo(Object object) {
        FloatBuffer floatBuffer = (FloatBuffer)object;
        int n = Math.min(this.remaining(), floatBuffer.remaining());
        int n2 = this.position();
        int n3 = floatBuffer.position();
        for (int i = 0; i < n; ++i) {
            float f;
            float f2;
            if ((f2 = this.get(n2++)) == (f = floatBuffer.get(n3++))) continue;
            if (f2 < f) {
                return -1;
            }
            return 1;
        }
        return this.remaining() - floatBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();
}

