/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.SystemProperties;
import gnu.java.security.Engine;
import gnu.java.security.action.GetSecurityPropertyAction;
import gnu.java.security.jce.prng.Sha160RandomSpi;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.security.VMSecureRandom;
import java.util.Enumeration;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecureRandom
extends Random {
    private static final String SECURE_RANDOM = "SecureRandom";
    private static final long serialVersionUID = 4940670005562187L;
    long counter;
    Provider provider;
    byte[] randomBytes;
    int randomBytesUsed;
    SecureRandomSpi secureRandomSpi;
    byte[] state;
    private String algorithm;
    private boolean isSeeded;
    private static final String SECURERANDOM_SOURCE = "securerandom.source";
    private static final String JAVA_SECURITY_EGD = "java.security.egd";
    private static final Logger logger;

    private /* synthetic */ void finit$() {
        this.counter = 0L;
        this.provider = null;
        this.randomBytes = null;
        this.randomBytesUsed = 0;
        this.secureRandomSpi = null;
        this.state = null;
        this.isSeeded = false;
    }

    public SecureRandom() {
        this.finit$();
        Provider[] providerArray = Security.getProviders();
        String string = null;
        for (int i = 0; i < providerArray.length; ++i) {
            Enumeration enumeration = providerArray[i].propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("SECURERANDOM.") || (string = providerArray[i].getProperty(string2)) == null) continue;
                try {
                    this.secureRandomSpi = (SecureRandomSpi)Class.forName(string).newInstance();
                    this.provider = providerArray[i];
                    this.algorithm = string2.substring(13);
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                }
            }
        }
        this.secureRandomSpi = new Sha160RandomSpi();
        this.algorithm = "Sha160";
    }

    public SecureRandom(byte[] byArray) {
        this();
        this.setSeed(byArray);
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, "unknown");
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        this.finit$();
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SecureRandom.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SecureRandom.getInstance(string, provider);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        try {
            return new SecureRandom((SecureRandomSpi)Engine.getInstance(SECURE_RANDOM, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
        this.isSeeded = true;
    }

    public void setSeed(long l) {
        if (this.secureRandomSpi != null) {
            byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
            this.secureRandomSpi.engineSetSeed(byArray);
            this.isSeeded = true;
        }
    }

    public void nextBytes(byte[] byArray) {
        if (!this.isSeeded) {
            this.setSeed(SecureRandom.getSeed(32));
        }
        this.randomBytesUsed += byArray.length;
        ++this.counter;
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n) {
        if (n == 0) {
            return 0;
        }
        byte[] byArray = new byte[(n + 7) / 8];
        this.nextBytes(byArray);
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n2 |= (byArray[i] & 0xFF) << (8 * i & 0x1F);
        }
        long l = (1L << (n & 0x3F)) - 1L;
        return (int)l & n2;
    }

    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        SecureRandom.generateSeed(byArray);
        return byArray;
    }

    public byte[] generateSeed(int n) {
        return this.secureRandomSpi.engineGenerateSeed(n);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static int generateSeed(byte[] byArray) {
        return SecureRandom.generateSeed(byArray, 0, byArray.length);
    }

    private static int generateSeed(byte[] byArray, int n, int n2) {
        URL uRL = null;
        String string = null;
        GetSecurityPropertyAction getSecurityPropertyAction = new GetSecurityPropertyAction(SECURERANDOM_SOURCE);
        try {
            string = (String)AccessController.doPrivileged(getSecurityPropertyAction);
            if (string != null) {
                uRL = new URL(string);
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "securerandom.source property is malformed: {0}", string);
        }
        if (uRL == null) {
            try {
                string = SystemProperties.getProperty(JAVA_SECURITY_EGD);
                if (string != null) {
                    uRL = new URL(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.log(Level.WARNING, "java.security.egd property is malformed: {0}", string);
            }
        }
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                return inputStream.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "error reading random bytes", iOException);
            }
        }
        return VMSecureRandom.generateSeed(byArray, n, n2);
    }

    static {
        SECURE_RANDOM = SECURE_RANDOM;
        SECURERANDOM_SOURCE = SECURERANDOM_SOURCE;
        JAVA_SECURITY_EGD = JAVA_SECURITY_EGD;
        logger = Logger.getLogger(SecureRandom.class$("java.security.SecureRandom").getName());
    }
}

