/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.DummySignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;

public abstract class Signature
extends SignatureSpi {
    private static final String SIGNATURE = "Signature";
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state;
    private String algorithm;
    Provider provider;

    private /* synthetic */ void finit$() {
        this.state = 0;
    }

    protected Signature(String string) {
        this.finit$();
        this.algorithm = string;
        this.state = 0;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return Signature.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return Signature.getInstance(string, provider);
    }

    public static Signature getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Signature signature = null;
        Object object = null;
        try {
            object = Engine.getInstance(SIGNATURE, string, provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        if (object instanceof SignatureSpi) {
            signature = new DummySignature((SignatureSpi)object, string);
        } else if (object instanceof Signature) {
            signature = (Signature)object;
            signature.algorithm = string;
        } else {
            throw new NoSuchAlgorithmException(string);
        }
        signature.provider = provider;
        return signature;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.state = 3;
        this.engineInitVerify(publicKey);
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        X509Certificate x509Certificate;
        boolean[] blArray;
        this.state = 3;
        if (certificate.getType().equals("X509") && (blArray = (x509Certificate = (X509Certificate)certificate).getKeyUsage()) != null && !blArray[0]) {
            throw new InvalidKeyException("KeyUsage of this Certificate indicates it cannot be used for digital signing");
        }
        this.initVerify(certificate.getPublicKey());
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey, secureRandom);
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            return this.engineSign();
        }
        throw new SignatureException();
    }

    public final int sign(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 2) {
            return this.engineSign(byArray, n, n2);
        }
        throw new SignatureException();
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        if (this.state == 3) {
            return this.engineVerify(byArray);
        }
        throw new SignatureException();
    }

    public final boolean verify(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("illegal state");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("signature is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("offset is less than 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length is less than 0");
        }
        if (n + n2 < byArray.length) {
            throw new IllegalArgumentException("range is out of bounds");
        }
        return this.engineVerify(byArray, n, n2);
    }

    public final void update(byte by) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return this.algorithm + " Signature";
    }

    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engineSetParameter(string, object);
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(algorithmParameterSpec);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engineGetParameter(string);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

