/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;

public class MBeanConstructorInfo
extends MBeanFeatureInfo
implements Cloneable {
    private static final long serialVersionUID = 4433990064191844427L;
    private MBeanParameterInfo[] signature;

    public MBeanConstructorInfo(String string, Constructor constructor) {
        super(constructor.getName(), string);
        Class[] classArray = constructor.getParameterTypes();
        this.signature = new MBeanParameterInfo[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            this.signature[i] = new MBeanParameterInfo(null, classArray[i].getName(), null);
        }
    }

    public MBeanConstructorInfo(String string, String string2, MBeanParameterInfo[] mBeanParameterInfoArray) {
        super(string, string2);
        this.signature = mBeanParameterInfoArray == null ? new MBeanParameterInfo[0] : mBeanParameterInfoArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("clone() called on non-cloneable object.");
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MBeanConstructorInfo)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MBeanConstructorInfo mBeanConstructorInfo = (MBeanConstructorInfo)object;
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanConstructorInfo.getSignature();
        for (int i = 0; i < this.signature.length; ++i) {
            if (i == mBeanParameterInfoArray.length) {
                return true;
            }
            if (this.signature[i].equals(mBeanParameterInfoArray[i])) continue;
            return false;
        }
        return true;
    }

    public MBeanParameterInfo[] getSignature() {
        return (MBeanParameterInfo[])this.signature.clone();
    }

    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.signature);
    }

    public String toString() {
        if (this.string == null) {
            super.toString();
            this.string = this.string.substring(0, this.string.length() - 1) + ",signature=" + Arrays.toString(this.signature) + "]";
        }
        return this.string;
    }
}

