/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;

public class StandardMBean
implements DynamicMBean {
    private Class iface;
    private Object impl;
    private MBeanInfo info;

    protected StandardMBean(Class clazz) throws NotCompliantMBeanException {
        if (clazz == null) {
            String string = this.getClass().getName();
            try {
                clazz = Class.forName(string + "MBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (NotCompliantMBeanException)new NotCompliantMBeanException("An interface for the class " + string + " was not found.").initCause(classNotFoundException);
            }
        }
        if (!clazz.isInstance(this)) {
            throw new NotCompliantMBeanException("The instance, " + this.impl + ", is not an instance of " + clazz);
        }
        this.impl = this;
        this.iface = clazz;
    }

    public StandardMBean(Object object, Class clazz) throws NotCompliantMBeanException {
        if (object == null) {
            throw new IllegalArgumentException("The specified implementation is null.");
        }
        if (clazz == null) {
            String string = object.getClass().getName();
            try {
                clazz = Class.forName(string + "MBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw (NotCompliantMBeanException)new NotCompliantMBeanException("An interface for the class " + string + " was not found.").initCause(classNotFoundException);
            }
        }
        if (!clazz.isInstance(object)) {
            throw new NotCompliantMBeanException("The instance, " + object + ", is not an instance of " + clazz);
        }
        this.impl = object;
        this.iface = clazz;
    }

    protected void cacheMBeanInfo(MBeanInfo mBeanInfo) {
        if (mBeanInfo != null) {
            this.info = mBeanInfo;
        }
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object;
        Method method;
        try {
            method = this.iface.getMethod("get" + string.substring(0, 1).toUpperCase() + string.substring(1), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = this.iface.getMethod("is" + string.substring(0, 1).toUpperCase() + string.substring(1), null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw (AttributeNotFoundException)new AttributeNotFoundException("The attribute, " + string + ", was not found.").initCause(noSuchMethodException2);
            }
        }
        try {
            object = method.invoke(this.impl, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to retrieve " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Failed to retrieve " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException((Exception)invocationTargetException.getCause(), "The getter of " + string + " threw an exception");
        }
        return object;
    }

    public AttributeList getAttributes(String[] stringArray) {
        AttributeList attributeList = new AttributeList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object object = this.getAttribute(stringArray[i]);
                attributeList.add(new Attribute(stringArray[i], object));
                continue;
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                continue;
            }
            catch (ReflectionException reflectionException) {
                continue;
            }
            catch (MBeanException mBeanException) {
                // empty catch block
            }
        }
        return attributeList;
    }

    protected MBeanInfo getCachedMBeanInfo() {
        return this.info;
    }

    protected String getClassName(MBeanInfo mBeanInfo) {
        return mBeanInfo.getClassName();
    }

    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] mBeanConstructorInfoArray, Object object) {
        if (object == null || object == this) {
            return mBeanConstructorInfoArray;
        }
        return null;
    }

    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanConstructorInfo);
    }

    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getDescription();
    }

    protected String getDescription(MBeanFeatureInfo mBeanFeatureInfo) {
        return mBeanFeatureInfo.getDescription();
    }

    protected String getDescription(MBeanInfo mBeanInfo) {
        return mBeanInfo.getDescription();
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        return this.getDescription((MBeanFeatureInfo)mBeanOperationInfo);
    }

    protected String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getDescription();
    }

    protected int getImpact(MBeanOperationInfo mBeanOperationInfo) {
        return mBeanOperationInfo.getImpact();
    }

    public Object getImplementation() {
        return this.impl;
    }

    public Class getImplementationClass() {
        return this.impl.getClass();
    }

    public MBeanInfo getMBeanInfo() {
        MBeanParameterInfo[] mBeanParameterInfoArray;
        Object object;
        Object object2;
        MBeanConstructorInfo[] mBeanConstructorInfoArray;
        Method[] methodArray;
        Object object3;
        Object object4;
        MBeanInfo mBeanInfo = this.getCachedMBeanInfo();
        if (mBeanInfo != null) {
            return mBeanInfo;
        }
        Method[] methodArray2 = this.iface.getMethods();
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < methodArray2.length; ++i) {
            object4 = methodArray2[i].getName();
            if ((((String)object4).startsWith("get") && methodArray2[i].getReturnType() != Void.TYPE || ((String)object4).startsWith("is") && methodArray2[i].getReturnType() == Boolean.TYPE) && methodArray2[i].getParameterTypes().length == 0) {
                object3 = ((String)object4).startsWith("is") ? ((String)object4).substring(2, 3).toLowerCase() + ((String)object4).substring(3) : ((String)object4).substring(3, 4).toLowerCase() + ((String)object4).substring(4);
                if (hashMap.containsKey(object3)) {
                    methodArray = (Method[])hashMap.get(object3);
                } else {
                    methodArray = new Method[2];
                    hashMap.put(object3, methodArray);
                }
                methodArray[0] = methodArray2[i];
                continue;
            }
            if (((String)object4).startsWith("set") && methodArray2[i].getReturnType() == Void.TYPE && methodArray2[i].getParameterTypes().length == 1) {
                object3 = ((String)object4).substring(3, 4).toLowerCase() + ((String)object4).substring(4);
                if (hashMap.containsKey(object3)) {
                    methodArray = (Method[])hashMap.get(object3);
                } else {
                    methodArray = new Method[2];
                    hashMap.put(object3, methodArray);
                }
                methodArray[1] = methodArray2[i];
                continue;
            }
            arrayList.add(new MBeanOperationInfo("", methodArray2[i]));
        }
        ArrayList arrayList2 = new ArrayList(hashMap.size());
        object4 = hashMap.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = (MBeanAttributeInfo[])object4.next();
            methodArray = (Method[])object3.getValue();
            try {
                arrayList2.add(new MBeanAttributeInfo((String)object3.getKey(), "", methodArray[0], methodArray[1]));
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalStateException("The two methods passed to the MBeanAttributeInfo constructor for " + object3 + "were null.", introspectionException);
            }
        }
        object3 = new MBeanAttributeInfo[arrayList2.size()];
        for (int i = 0; i < ((MBeanAttributeInfo[])object3).length; ++i) {
            mBeanConstructorInfoArray = (MBeanConstructorInfo[])arrayList2.get(i);
            String string = this.getDescription((MBeanAttributeInfo)mBeanConstructorInfoArray);
            object3[i] = new MBeanAttributeInfo(mBeanConstructorInfoArray.getName(), mBeanConstructorInfoArray.getType(), string, mBeanConstructorInfoArray.isReadable(), mBeanConstructorInfoArray.isWritable(), mBeanConstructorInfoArray.isIs());
        }
        Constructor[] constructorArray = this.impl.getClass().getConstructors();
        mBeanConstructorInfoArray = new MBeanConstructorInfo[constructorArray.length];
        for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
            MBeanConstructorInfo mBeanConstructorInfo = new MBeanConstructorInfo("", constructorArray[i]);
            object2 = this.getDescription(mBeanConstructorInfo);
            object = mBeanConstructorInfo.getSignature();
            MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[((MBeanParameterInfo[])object).length];
            for (int j = 0; j < mBeanParameterInfoArray2.length; ++j) {
                mBeanParameterInfoArray = this.getDescription(mBeanConstructorInfo, object[j], j);
                String string = this.getParameterName(mBeanConstructorInfo, object[j], j);
                mBeanParameterInfoArray2[j] = new MBeanParameterInfo(string, object[j].getType(), (String)mBeanParameterInfoArray);
            }
            mBeanConstructorInfoArray[i] = new MBeanConstructorInfo(mBeanConstructorInfo.getName(), (String)object2, mBeanParameterInfoArray2);
        }
        mBeanConstructorInfoArray = this.getConstructors(mBeanConstructorInfoArray, this.impl);
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[arrayList.size()];
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            object2 = (MBeanOperationInfo)arrayList.get(i);
            object = this.getDescription((MBeanOperationInfo)object2);
            int n = this.getImpact((MBeanOperationInfo)object2);
            MBeanParameterInfo[] mBeanParameterInfoArray3 = ((MBeanOperationInfo)object2).getSignature();
            mBeanParameterInfoArray = new MBeanParameterInfo[mBeanParameterInfoArray3.length];
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                String string = this.getDescription((MBeanOperationInfo)object2, mBeanParameterInfoArray3[j], j);
                String string2 = this.getParameterName((MBeanOperationInfo)object2, mBeanParameterInfoArray3[j], j);
                mBeanParameterInfoArray[j] = new MBeanParameterInfo(string2, mBeanParameterInfoArray3[j].getType(), string);
            }
            mBeanOperationInfoArray[i] = new MBeanOperationInfo(((MBeanFeatureInfo)object2).getName(), (String)object, mBeanParameterInfoArray, ((MBeanOperationInfo)object2).getReturnType(), n);
        }
        mBeanInfo = new MBeanInfo(this.impl.getClass().getName(), "", (MBeanAttributeInfo[])object3, mBeanConstructorInfoArray, mBeanOperationInfoArray, null);
        String string = this.getClassName(mBeanInfo);
        object2 = this.getDescription(mBeanInfo);
        mBeanInfo = new MBeanInfo(string, (String)object2, (MBeanAttributeInfo[])object3, mBeanConstructorInfoArray, mBeanOperationInfoArray, null);
        this.cacheMBeanInfo(mBeanInfo);
        return mBeanInfo;
    }

    public Class getMBeanInterface() {
        return this.iface;
    }

    protected String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getName();
    }

    protected String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getName();
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Object object;
        Method method;
        Class[] classArray = new Class[stringArray.length];
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                classArray[i] = Class.forName(stringArray[i], true, classLoader);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The class, " + stringArray[i] + ", in the method signature " + "could not be loaded.");
            }
        }
        try {
            method = this.iface.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ReflectionException(noSuchMethodException, "The method, " + string + ", could not be found.");
        }
        try {
            object = method.invoke(this.impl, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to call " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Failed to call " + string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException((Exception)invocationTargetException.getCause(), "The method " + string + " threw an exception");
        }
        return object;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method method;
        String string = attribute.getName();
        try {
            method = this.iface.getMethod("set" + string.substring(0, 1).toUpperCase() + string.substring(1), null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw (AttributeNotFoundException)new AttributeNotFoundException("The attribute, " + string + ", was not found.").initCause(noSuchMethodException);
        }
        try {
            method.invoke(this.impl, new Object[]{attribute.getValue()});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Failed to set " + string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (InvalidAttributeValueException)new InvalidAttributeValueException(attribute.getValue() + " is an invalid value for " + string).initCause(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new MBeanException((Exception)invocationTargetException.getCause(), "The getter of " + string + " threw an exception");
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        Iterator iterator = attributeList.iterator();
        while (iterator.hasNext()) {
            try {
                Attribute attribute = (Attribute)iterator.next();
                this.setAttribute(attribute);
                attributeList2.add(attribute);
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
            }
            catch (ReflectionException reflectionException) {
            }
            catch (MBeanException mBeanException) {}
        }
        return attributeList2;
    }

    public void setImplementation(Object object) throws NotCompliantMBeanException {
        if (object == null) {
            throw new IllegalArgumentException("The specified implementation is null.");
        }
        if (!this.iface.isInstance(object)) {
            throw new NotCompliantMBeanException("The instance, " + object + ", is not an instance of " + this.iface);
        }
        this.impl = object;
    }
}

