/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class SslRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = -8310631444933958385L;
    private String[] enabledCipherSuites = this.getProp("javax.rmi.ssl.client.enabledCipherSuites");
    private String[] enabledProtocols = this.getProp("javax.rmi.ssl.client.enabledProtocols");
    private static SSLSocketFactory socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    private String[] getProp(String string) {
        StringTokenizer stringTokenizer;
        try {
            String string2 = System.getProperty(string);
            stringTokenizer = new StringTokenizer(string2, ",");
        }
        catch (SecurityException securityException) {
            return null;
        }
        int n = stringTokenizer.countTokens();
        if (n < 1) {
            return null;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)socketFactory.createSocket(string, n);
        if (this.enabledCipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sSLSocket.setEnabledProtocols(this.enabledProtocols);
        }
        return sSLSocket;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SslRMIClientSocketFactory)) {
            return false;
        }
        SslRMIClientSocketFactory sslRMIClientSocketFactory = (SslRMIClientSocketFactory)object;
        if (!SslRMIServerSocketFactory.cmpStrArray(this.enabledCipherSuites, sslRMIClientSocketFactory.enabledCipherSuites)) {
            return false;
        }
        return SslRMIServerSocketFactory.cmpStrArray(this.enabledProtocols, sslRMIClientSocketFactory.enabledProtocols);
    }

    public int hashCode() {
        int n;
        int n2 = 0;
        if (this.enabledCipherSuites != null) {
            for (n = 0; n < this.enabledCipherSuites.length; ++n) {
                n2 ^= this.enabledCipherSuites[n].hashCode();
            }
        }
        if (this.enabledProtocols != null) {
            for (n = 0; n < this.enabledProtocols.length; ++n) {
                n2 ^= this.enabledProtocols[n].hashCode();
            }
        }
        return n2;
    }
}

