/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class BasicComboPopup
extends JPopupMenu
implements ComboPopup {
    protected Timer autoscrollTimer;
    protected JComboBox comboBox;
    protected boolean hasEntered;
    protected boolean isAutoScrolling;
    protected ItemListener itemListener;
    protected KeyListener keyListener;
    protected JList list;
    protected ListDataListener listDataListener;
    protected MouseListener listMouseListener;
    protected MouseMotionListener listMouseMotionListener;
    protected ListSelectionListener listSelectionListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    protected PropertyChangeListener propertyChangeListener;
    protected static final int SCROLL_DOWN = 1;
    protected static final int SCROLL_UP = 0;
    protected int scrollDirection;
    protected JScrollPane scroller;
    protected boolean valueIsAdjusting;

    public BasicComboPopup(JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.keyListener = this.createKeyListener();
        this.list = this.createList();
        this.configureList();
        this.scroller = this.createScroller();
        this.configureScroller();
        this.configurePopup();
        this.installComboBoxListeners();
        this.installKeyboardActions();
    }

    public void show() {
        Dimension dimension = this.comboBox.getSize();
        dimension.height = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
        this.scroller.setMaximumSize(rectangle.getSize());
        this.scroller.setPreferredSize(rectangle.getSize());
        this.scroller.setMinimumSize(rectangle.getSize());
        this.list.invalidate();
        this.syncListSelection();
        this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
        this.show(this.comboBox, rectangle.x, rectangle.y);
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != this) continue;
            menuSelectionManager.clearSelectedPath();
            break;
        }
        this.comboBox.repaint();
    }

    public JList getList() {
        return this.list;
    }

    public MouseListener getMouseListener() {
        return this.mouseListener;
    }

    public MouseMotionListener getMouseMotionListener() {
        return this.mouseMotionListener;
    }

    public KeyListener getKeyListener() {
        return this.keyListener;
    }

    public void uninstallingUI() {
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void uninstallComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        comboBoxModel.removeListDataListener(this.listDataListener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected void firePopupMenuWillBecomeVisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeVisible(new PopupMenuEvent(this.comboBox));
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuWillBecomeInvisible(new PopupMenuEvent(this.comboBox));
        }
    }

    protected void firePopupMenuCanceled() {
        PopupMenuListener[] popupMenuListenerArray = this.comboBox.getPopupMenuListeners();
        for (int i = 0; i < popupMenuListenerArray.length; ++i) {
            popupMenuListenerArray[i].popupMenuCanceled(new PopupMenuEvent(this.comboBox));
        }
    }

    protected MouseListener createMouseListener() {
        return new InvocationMouseHandler(this);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new InvocationMouseMotionHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new InvocationKeyHandler(this);
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler(this);
    }

    protected ListDataListener createListDataListener() {
        return null;
    }

    protected MouseListener createListMouseListener() {
        return new ListMouseHandler(this);
    }

    protected MouseMotionListener createListMouseMotionListener() {
        return new ListMouseMotionHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected ItemListener createItemListener() {
        return new ItemHandler(this);
    }

    protected JList createList() {
        JList jList = new JList(this.comboBox.getModel());
        return jList;
    }

    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setForeground(this.comboBox.getForeground());
        this.list.setBackground(this.comboBox.getBackground());
        Color color = UIManager.getColor("ComboBox.selectionForeground");
        this.list.setSelectionForeground(color);
        Color color2 = UIManager.getColor("ComboBox.selectionBackground");
        this.list.setSelectionBackground(color2);
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.syncListSelection();
        this.list.setSelectionMode(1);
        this.installListListeners();
    }

    protected void installListListeners() {
        this.listMouseListener = this.createListMouseListener();
        this.list.addMouseListener(this.listMouseListener);
        this.listMouseMotionListener = this.createListMouseMotionListener();
        this.list.addMouseMotionListener(this.listMouseMotionListener);
        this.listSelectionListener = this.createListSelectionListener();
        this.list.addListSelectionListener(this.listSelectionListener);
    }

    protected JScrollPane createScroller() {
        return new JScrollPane(this.list, 20, 31);
    }

    protected void configureScroller() {
        this.scroller.setBorder(null);
        this.scroller.setFocusable(false);
        this.scroller.getVerticalScrollBar().setFocusable(false);
    }

    protected void configurePopup() {
        this.setBorderPainted(true);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.setOpaque(false);
        this.add(this.scroller);
        this.setFocusable(false);
    }

    protected void installComboBoxListeners() {
        this.itemListener = this.createItemListener();
        this.comboBox.addItemListener(this.itemListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        this.installComboBoxModelListeners(this.comboBox.getModel());
    }

    protected void installComboBoxModelListeners(ComboBoxModel comboBoxModel) {
        this.listDataListener = this.createListDataListener();
        this.comboBox.getModel().addListDataListener(this.listDataListener);
    }

    protected void installKeyboardActions() {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void startAutoScrolling(int n) {
        this.isAutoScrolling = true;
        if (n == 0) {
            this.autoScrollUp();
        } else {
            this.autoScrollDown();
        }
    }

    protected void stopAutoScrolling() {
        this.isAutoScrolling = false;
    }

    protected void autoScrollUp() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 0);
        jScrollBar.setValue(jScrollBar.getValue() - n);
        if (this.list.getSelectedIndex() != 0) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() - 1);
        }
    }

    protected void autoScrollDown() {
        JScrollBar jScrollBar = this.scroller.getVerticalScrollBar();
        int n = this.list.getScrollableUnitIncrement(super.getBounds(), 1, 1);
        jScrollBar.setValue(jScrollBar.getValue() + n);
        if (this.list.getSelectedIndex() + 1 != this.comboBox.getItemCount()) {
            this.list.setSelectedIndex(this.list.getSelectedIndex() + 1);
        }
    }

    protected void delegateFocus(MouseEvent mouseEvent) {
        if (this.comboBox.isEditable()) {
            this.comboBox.getEditor().getEditorComponent().requestFocus();
        } else {
            this.comboBox.requestFocus();
        }
    }

    protected void togglePopup() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this.list);
        MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
        return mouseEvent2;
    }

    protected int getPopupHeightForRowCount(int n) {
        int n2 = 0;
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        if (this.comboBox.getItemCount() < n) {
            n = this.comboBox.getItemCount();
        }
        for (int i = 0; i < n; ++i) {
            Component component = listCellRenderer.getListCellRendererComponent(this.list, this.comboBox.getModel().getElementAt(i), -1, false, false);
            Dimension dimension = component.getPreferredSize();
            n2 += dimension.height;
        }
        if (n2 == 0) {
            return 100;
        }
        return n2;
    }

    protected Rectangle computePopupBounds(int n, int n2, int n3, int n4) {
        return new Rectangle(n, n2, n3, n4);
    }

    protected void updateListBoxSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
        Point point = mouseEvent.getPoint();
        if (this.list != null) {
            int n = this.list.locationToIndex(point);
            if (n == -1) {
                n = point.y < 0 ? 0 : this.comboBox.getModel().getSize() - 1;
            }
            if (this.list.getSelectedIndex() != n) {
                this.list.setSelectedIndex(n);
                if (bl) {
                    this.list.ensureIndexIsVisible(n);
                }
            }
        }
    }

    private void uninstallListeners() {
        this.uninstallComboBoxListeners();
        this.uninstallComboBoxModelListeners(this.comboBox.getModel());
    }

    private void uninstallListListeners() {
        this.list.removeMouseListener(this.listMouseListener);
        this.listMouseListener = null;
        this.list.removeMouseMotionListener(this.listMouseMotionListener);
        this.listMouseMotionListener = null;
    }

    private void uninstallComboBoxListeners() {
        this.comboBox.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    void syncListSelection() {
        int n = this.comboBox.getSelectedIndex();
        if (n == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(n);
        }
    }

    public class InvocationKeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        public InvocationKeyHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    protected class ListSelectionHandler
    implements ListSelectionListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListSelectionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        private /* synthetic */ BasicComboPopup this$0;

        public ListDataHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected PropertyChangeHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("renderer")) {
                this.this$0.list.setCellRenderer(this.this$0.comboBox.getRenderer());
                if (this.this$0.isVisible()) {
                    this.this$0.hide();
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("model")) {
                ComboBoxModel comboBoxModel = (ComboBoxModel)propertyChangeEvent.getOldValue();
                this.this$0.uninstallComboBoxModelListeners(comboBoxModel);
                ComboBoxModel comboBoxModel2 = (ComboBoxModel)propertyChangeEvent.getNewValue();
                this.this$0.list.setModel(comboBoxModel2);
                this.this$0.installComboBoxModelListeners(comboBoxModel2);
                if (this.this$0.comboBox.getItemCount() > 0) {
                    this.this$0.comboBox.setSelectedIndex(0);
                }
                if (this.this$0.isVisible()) {
                    this.this$0.hide();
                }
            }
        }
    }

    protected class ListMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Rectangle rectangle = new Rectangle();
            this.this$0.list.computeVisibleRect(rectangle);
            if (rectangle.contains(point)) {
                this.this$0.valueIsAdjusting = true;
                this.this$0.updateListBoxSelectionForEvent(mouseEvent, false);
                this.this$0.valueIsAdjusting = false;
            }
        }
    }

    protected class ListMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected ListMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.this$0.comboBox.setSelectedIndex(this.this$0.list.getSelectedIndex());
            this.this$0.hide();
        }
    }

    protected class ItemHandler
    implements ItemListener {
        private /* synthetic */ BasicComboPopup this$0;

        protected ItemHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1 && !this.this$0.valueIsAdjusting) {
                this.this$0.valueIsAdjusting = true;
                this.this$0.syncListSelection();
                this.this$0.valueIsAdjusting = false;
                this.this$0.list.ensureIndexIsVisible(this.this$0.comboBox.getSelectedIndex());
            }
        }
    }

    protected class InvocationMouseMotionHandler
    extends MouseMotionAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseMotionHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.isVisible()) {
                MouseEvent mouseEvent2 = this.this$0.convertMouseEvent(mouseEvent);
                Rectangle rectangle = new Rectangle();
                this.this$0.list.computeVisibleRect(rectangle);
                if (mouseEvent2.getPoint().y >= rectangle.y && mouseEvent2.getPoint().y <= rectangle.y + rectangle.height - 1) {
                    Point point;
                    this.this$0.hasEntered = true;
                    if (this.this$0.isAutoScrolling) {
                        this.this$0.stopAutoScrolling();
                    }
                    if (rectangle.contains(point = mouseEvent2.getPoint())) {
                        this.this$0.valueIsAdjusting = true;
                        this.this$0.updateListBoxSelectionForEvent(mouseEvent2, false);
                        this.this$0.valueIsAdjusting = false;
                    }
                } else if (this.this$0.hasEntered) {
                    int n;
                    int n2 = n = mouseEvent2.getPoint().y < rectangle.y ? 0 : 1;
                    if (this.this$0.isAutoScrolling && this.this$0.scrollDirection != n) {
                        this.this$0.stopAutoScrolling();
                        this.this$0.startAutoScrolling(n);
                    } else if (!this.this$0.isAutoScrolling) {
                        this.this$0.startAutoScrolling(n);
                    }
                } else if (mouseEvent.getPoint().y < 0) {
                    this.this$0.hasEntered = true;
                    this.this$0.startAutoScrolling(0);
                }
            }
        }
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        private /* synthetic */ BasicComboPopup this$0;

        protected InvocationMouseHandler(BasicComboPopup basicComboPopup) {
            this.this$0 = basicComboPopup;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.this$0.comboBox.isEnabled()) {
                this.this$0.delegateFocus(mouseEvent);
                this.this$0.togglePopup();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = component.getSize();
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            if (!rectangle.contains(mouseEvent.getPoint())) {
                MouseEvent mouseEvent2 = this.this$0.convertMouseEvent(mouseEvent);
                Point point = mouseEvent2.getPoint();
                Rectangle rectangle2 = new Rectangle();
                this.this$0.list.computeVisibleRect(rectangle2);
                if (rectangle2.contains(point)) {
                    this.this$0.updateListBoxSelectionForEvent(mouseEvent2, false);
                    this.this$0.comboBox.setSelectedIndex(this.this$0.list.getSelectedIndex());
                }
                this.this$0.hide();
            }
            this.this$0.hasEntered = false;
            this.this$0.stopAutoScrolling();
        }
    }
}

