/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.java.security.hash.Sha160;
import gnu.java.security.util.Base64;
import gnu.java.util.jar.JarUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

class HashUtils {
    private static final Logger log = Logger.getLogger(HashUtils.class$("gnu.classpath.tools.jarsigner.HashUtils").getName());
    private Sha160 sha;

    private /* synthetic */ void finit$() {
        this.sha = new Sha160();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    String hashStream(InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        byte[] byArray = new byte[4096];
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            this.sha.update(byArray, 0, n);
            n2 += n;
        }
        byte[] byArray2 = this.sha.digest();
        if (Configuration.DEBUG) {
            log.finest("Hashed " + n2 + " byte(s)");
        }
        String string = Base64.encode((byte[])byArray2);
        return string;
    }

    String hashByteArray(byte[] byArray) throws IOException {
        this.sha.update(byArray);
        byte[] byArray2 = this.sha.digest();
        if (Configuration.DEBUG) {
            log.finest("Hashed " + byArray.length + " byte(s)");
        }
        String string = Base64.encode((byte[])byArray2);
        return string;
    }

    String hashManifestEntry(String string, String string2) throws UnsupportedEncodingException {
        this.sha.update(("Name: " + string).getBytes("UTF-8"));
        this.sha.update(JarUtils.CRLF);
        this.sha.update(("SHA1-Digest: " + string2).getBytes("UTF-8"));
        this.sha.update(JarUtils.CRLF);
        this.sha.update(JarUtils.CRLF);
        byte[] byArray = this.sha.digest();
        String string3 = Base64.encode((byte[])byArray);
        return string3;
    }

    HashUtils() {
        this.finit$();
    }
}

