/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.tools.jarsigner.HashUtils;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.util.Util;
import gnu.java.util.jar.JarUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class JarVerifier {
    private static final Logger log = Logger.getLogger(JarVerifier.class$("gnu.classpath.tools.jarsigner.JarVerifier").getName());
    private Main main;
    private HashUtils util;
    private JarFile jarFile;
    private Map entryHashes;

    private /* synthetic */ void finit$() {
        this.util = new HashUtils();
        this.entryHashes = new HashMap();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    JarVerifier(Main main) {
        this.finit$();
        this.main = main;
    }

    void start() throws Exception {
        String[] stringArray;
        Object object;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        String string = this.main.getJarFileName();
        this.jarFile = new JarFile(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<JarEntry> enumeration = this.jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            object = jarEntry.getName();
            if (!((String)object).startsWith("META-INF/") || !((String)object).endsWith(".SF") || (stringArray = ((String)object).split("/")).length != 2) continue;
            String string2 = stringArray[1];
            String string3 = string2.substring(0, string2.length() - 3);
            arrayList.add(string3);
        }
        if (arrayList.isEmpty()) {
            System.out.println(Messages.getString("JarVerifier.2"));
        } else {
            int n = arrayList.size();
            int n2 = 0;
            object = arrayList.iterator();
            while (object.hasNext()) {
                stringArray = (String[])object.next();
                if (!this.verifySF((String)stringArray) || !this.verifySFEntries((String)stringArray)) continue;
                ++n2;
            }
            if (n2 == 0) {
                System.out.println(Messages.getString("JarVerifier.3"));
            } else if (n2 != n) {
                System.out.println(Messages.getFormattedString("JarVerifier.4", new Integer[]{n2, n}));
            } else {
                System.out.println(Messages.getFormattedString("JarVerifier.7", n));
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    private boolean verifySF(String string) throws CRLException, CertificateException, ZipException, IOException {
        int n;
        DSSSignatureX509Codec dSSSignatureX509Codec;
        DSSSignature dSSSignature;
        OID oID;
        JarEntry jarEntry;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "verifySF");
            log.fine("About to verify signature of " + string + "...");
        }
        if ((jarEntry = this.jarFile.getJarEntry("META-INF/" + string + ".DSA")) == null) {
            throw new SecurityException(Messages.getFormattedString("JarVerifier.13", string));
        }
        InputStream inputStream = this.jarFile.getInputStream(jarEntry);
        PKCS7SignedData pKCS7SignedData = new PKCS7SignedData(inputStream);
        Set set = pKCS7SignedData.getSignerInfos();
        if (set == null || set.isEmpty()) {
            throw new SecurityException(Messages.getString("JarVerifier.14"));
        }
        SignerInfo signerInfo = (SignerInfo)set.iterator().next();
        byte[] byArray = signerInfo.getEncryptedDigest();
        if (byArray == null) {
            throw new SecurityException(Messages.getString("JarVerifier.16"));
        }
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])byArray, (String)"--- signedSFBytes "));
        }
        Certificate certificate = pKCS7SignedData.getCertificates()[0];
        PublicKey publicKey = certificate.getPublicKey();
        if (Configuration.DEBUG) {
            log.fine("--- verifier public key = " + publicKey);
        }
        if ((oID = signerInfo.getDigestEncryptionAlgorithmId()).equals((Object)Main.DSA_SIGNATURE_OID)) {
            dSSSignature = new DSSSignature();
            dSSSignatureX509Codec = new DSSSignatureX509Codec();
        } else {
            dSSSignature = new RSAPKCS1V1_5Signature("md5");
            dSSSignatureX509Codec = new RSAPKCS1V1_5SignatureX509Codec();
        }
        HashMap<String, PublicKey> hashMap = new HashMap<String, PublicKey>();
        hashMap.put("gnu.crypto.sig.public.key", publicKey);
        dSSSignature.setupVerify(hashMap);
        Object object = dSSSignatureX509Codec.decodeSignature(byArray);
        JarEntry jarEntry2 = this.jarFile.getJarEntry("META-INF/" + string + ".SF");
        inputStream = this.jarFile.getInputStream(jarEntry2);
        byte[] byArray2 = new byte[2048];
        while ((n = inputStream.read(byArray2)) != -1) {
            if (n <= 0) continue;
            dSSSignature.update(byArray2, 0, n);
        }
        boolean bl = dSSSignature.verify(object);
        if (Configuration.DEBUG) {
            log.fine("Signature block [" + string + "] is " + (bl ? "" : "NOT ") + "OK");
            log.exiting(this.getClass().getName(), "verifySF", bl);
        }
        return bl;
    }

    private boolean verifySFEntries(String string) throws IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "verifySFEntries");
        }
        JarEntry jarEntry = this.jarFile.getJarEntry("META-INF/" + string + ".SF");
        InputStream inputStream = this.jarFile.getInputStream(jarEntry);
        Attributes attributes = new Attributes();
        HashMap hashMap = new HashMap();
        JarUtils.readSFManifest((Attributes)attributes, hashMap, (InputStream)inputStream);
        boolean bl = false;
        String string2 = attributes.getValue(Main.DIGEST_MANIFEST_ATTR);
        if (string2 != null) {
            bl = this.verifyManifest(string2);
        }
        if (!bl) {
            Map.Entry entry;
            String string3;
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext() && (bl = this.verifySFEntry(string3 = (String)(entry = (Map.Entry)iterator.next()).getKey(), string2 = (attributes = (Attributes)entry.getValue()).getValue(Main.DIGEST_ATTR)))) {
            }
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "verifySFEntries", bl);
        }
        return bl;
    }

    private boolean verifyManifest(String string) throws IOException {
        return this.verifySFEntry("META-INF/MANIFEST.MF", string);
    }

    private boolean verifySFEntry(String string, String string2) throws IOException {
        String string3 = this.getEntryHash("META-INF/MANIFEST.MF");
        boolean bl = string3.equalsIgnoreCase(string2);
        if (Configuration.DEBUG) {
            log.fine("Is " + string + " OK? " + bl);
        }
        return bl;
    }

    private String getEntryHash(String string) throws IOException {
        String string2 = (String)this.entryHashes.get(string);
        if (string2 == null) {
            JarEntry jarEntry = this.jarFile.getJarEntry(string);
            InputStream inputStream = this.jarFile.getInputStream(jarEntry);
            string2 = this.util.hashStream(inputStream);
            this.entryHashes.put(string, string2);
        }
        return string2;
    }
}

