/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jarsigner;

import gnu.classpath.Configuration;
import gnu.classpath.tools.jarsigner.HashUtils;
import gnu.classpath.tools.jarsigner.Main;
import gnu.classpath.tools.jarsigner.Messages;
import gnu.java.security.OID;
import gnu.java.security.der.DERValue;
import gnu.java.security.pkcs.PKCS7Data;
import gnu.java.security.pkcs.PKCS7SignedData;
import gnu.java.security.pkcs.SignerInfo;
import gnu.java.security.sig.dss.DSSSignature;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.util.Util;
import gnu.java.util.jar.JarUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

public class SFHelper {
    private static final Logger log = Logger.getLogger(SFHelper.class$("gnu.classpath.tools.jarsigner.SFHelper").getName());
    private static final int READY = 0;
    private static final int STARTED = 1;
    private static final int FINISHED = 2;
    private static final int SF_GENERATED = 3;
    private static final int DSA_GENERATED = 4;
    private static final OID hashAlgorithmIdentifierSHA1 = new OID("1.3.14.3.2.26");
    private int state;
    private JarFile jar;
    private Manifest manifest;
    private Attributes sfMainAttributes;
    private Map sfEntries;
    private byte[] sfBytes;
    private HashUtils util;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SFHelper(JarFile jarFile) {
        this.jar = jarFile;
        this.state = 0;
    }

    void writeSF(JarOutputStream jarOutputStream) throws IOException {
        if (this.state != 2) {
            throw new IllegalStateException(Messages.getString("SFHelper.1"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JarUtils.writeSFManifest((Attributes)this.sfMainAttributes, (Map)this.sfEntries, (OutputStream)byteArrayOutputStream);
        this.sfBytes = byteArrayOutputStream.toByteArray();
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])this.sfBytes, (String)"+++ sfBytes "));
        }
        jarOutputStream.write(this.sfBytes);
        jarOutputStream.flush();
        this.state = 3;
    }

    void writeDSA(JarOutputStream jarOutputStream, PrivateKey privateKey, Certificate[] certificateArray, boolean bl) throws IOException, CertificateEncodingException, CRLException {
        Object object;
        String string;
        Object object2;
        OID oID;
        DSSSignatureX509Codec dSSSignatureX509Codec;
        DSSSignature dSSSignature;
        if (this.state != 3) {
            throw new IllegalStateException(Messages.getString("SFHelper.4"));
        }
        if (Configuration.DEBUG) {
            log.fine("+++ signer private key = " + privateKey);
        }
        if (privateKey instanceof DSAPrivateKey) {
            dSSSignature = new DSSSignature();
            dSSSignatureX509Codec = new DSSSignatureX509Codec();
            oID = Main.DSA_SIGNATURE_OID;
        } else if (privateKey instanceof RSAPrivateKey) {
            dSSSignature = new RSAPKCS1V1_5Signature("md5");
            dSSSignatureX509Codec = new RSAPKCS1V1_5SignatureX509Codec();
            oID = Main.RSA_SIGNATURE_OID;
        } else {
            throw new SecurityException(Messages.getString("SFHelper.6"));
        }
        HashMap<String, PrivateKey> hashMap = new HashMap<String, PrivateKey>();
        hashMap.put("gnu.crypto.sig.private.key", privateKey);
        dSSSignature.setupSign(hashMap);
        dSSSignature.update(this.sfBytes, 0, this.sfBytes.length);
        Object object3 = dSSSignature.sign();
        byte[] byArray = dSSSignatureX509Codec.encodeSignature(object3);
        if (Configuration.DEBUG) {
            log.fine("\n" + Util.dumpString((byte[])byArray, (String)"+++ signedSFBytes "));
        }
        HashSet<DERValue> hashSet = new HashSet<DERValue>();
        ArrayList<DERValue> arrayList = new ArrayList<DERValue>(2);
        DERValue dERValue = new DERValue(6, (Object)hashAlgorithmIdentifierSHA1);
        DERValue dERValue2 = new DERValue(5, null);
        arrayList.add(dERValue);
        arrayList.add(dERValue2);
        DERValue dERValue3 = new DERValue(48, arrayList);
        hashSet.add(dERValue3);
        PKCS7Data pKCS7Data = bl ? new PKCS7Data(this.sfBytes) : null;
        X509CRL[] x509CRLArray = null;
        HashSet<SignerInfo> hashSet2 = new HashSet<SignerInfo>();
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            object2 = this.getIssuerName(x509Certificate);
            string = this.getSubjectName(x509Certificate);
            object = this.getNotAfterDate(x509Certificate);
            System.out.println(Messages.getFormattedString("SFHelper.0", new Object[]{object2, string, object}));
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            object2 = this.getIssuerName(x509Certificate);
            string = this.getSubjectName(x509Certificate);
            object = this.getNotBeforeDate(x509Certificate);
            System.out.println(Messages.getFormattedString("SFHelper.11", new Object[]{object2, string, object}));
        }
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        object2 = x509Certificate.getSerialNumber();
        string = null;
        object = byArray;
        byte[] byArray2 = null;
        SignerInfo signerInfo = new SignerInfo(x500Principal, (BigInteger)object2, hashAlgorithmIdentifierSHA1, (byte[])string, oID, object, byArray2);
        hashSet2.add(signerInfo);
        PKCS7SignedData pKCS7SignedData = new PKCS7SignedData(hashSet, pKCS7Data, certificateArray, x509CRLArray, hashSet2);
        pKCS7SignedData.encode((OutputStream)jarOutputStream);
        jarOutputStream.flush();
        this.state = 4;
    }

    Manifest getManifest() {
        return this.manifest;
    }

    void startSigning() throws IOException {
        if (this.state != 0) {
            throw new IllegalStateException(Messages.getString("SFHelper.9"));
        }
        Manifest manifest = this.jar.getManifest();
        this.manifest = manifest == null ? new Manifest() : new Manifest(manifest);
        this.sfMainAttributes = new Attributes();
        this.sfEntries = new HashMap();
        this.util = new HashUtils();
        this.state = 1;
    }

    void updateEntry(JarEntry jarEntry) throws IOException {
        Attributes attributes;
        if (this.state != 1) {
            throw new IllegalStateException(Messages.getString("SFHelper.10"));
        }
        String string = jarEntry.getName();
        InputStream inputStream = this.jar.getInputStream(jarEntry);
        String string2 = this.util.hashStream(inputStream);
        if (Configuration.DEBUG) {
            log.fine("Hash of " + string + " = " + string2);
        }
        if ((attributes = this.manifest.getAttributes(string)) == null) {
            attributes = new Attributes();
            this.manifest.getEntries().put(string, attributes);
        }
        attributes.putValue("SHA1-Digest", string2);
        String string3 = this.util.hashManifestEntry(string, string2);
        Attributes attributes2 = (Attributes)this.sfEntries.get(string);
        if (attributes2 == null) {
            attributes2 = new Attributes();
            this.sfEntries.put(string, attributes2);
        }
        attributes2.putValue("SHA1-Digest", string3);
        if (Configuration.DEBUG) {
            log.fine("Name: " + string);
            log.fine("SHA1-Digest: " + string3);
            log.fine("");
        }
    }

    void finishSigning(boolean bl) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException(Messages.getString("SFHelper.10"));
        }
        if (bl) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.manifest.write(byteArrayOutputStream);
        byteArrayOutputStream.flush();
        String string = this.util.hashByteArray(byteArrayOutputStream.toByteArray());
        if (Configuration.DEBUG) {
            log.fine("Hashed Manifest " + string);
        }
        this.sfMainAttributes.putValue("SHA1-Digest-Manifest", string);
        this.state = 2;
    }

    private String getIssuerName(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        if (x500Principal == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has null Issuer. Return [unknown]");
            }
            return Messages.getString("SFHelper.14");
        }
        String string = x500Principal.getName();
        if (string == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has an Issuer with null DN. Return [unnamed]");
            }
            return Messages.getString("SFHelper.17");
        }
        return string;
    }

    private String getSubjectName(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        if (x500Principal == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has null Subject. Return [unknown]");
            }
            return Messages.getString("SFHelper.14");
        }
        String string = x500Principal.getName();
        if (string == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has a Subject with null DN. Return [unnamed]");
            }
            return Messages.getString("SFHelper.17");
        }
        return string;
    }

    private Date getNotAfterDate(X509Certificate x509Certificate) {
        Date date = x509Certificate.getNotAfter();
        if (date == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has null start-validity date. Return epoch");
            }
            return new Date(0L);
        }
        return date;
    }

    private Date getNotBeforeDate(X509Certificate x509Certificate) {
        Date date = x509Certificate.getNotBefore();
        if (date == null) {
            if (Configuration.DEBUG) {
                log.fine("Certiticate, with serial number " + x509Certificate.getSerialNumber() + ", has null end-validity date. Return epoch");
            }
            return new Date(0L);
        }
        return date;
    }
}

