/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.SystemProperties;
import gnu.java.nio.charset.EncodingHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InputStreamReader
extends Reader {
    private InputStream in;
    private CharsetDecoder decoder;
    private boolean isDone;
    private float maxBytesPerChar;
    private ByteBuffer byteBuffer;
    private String encoding;
    private char savedSurrogate;
    private boolean hasSavedSurrogate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.decoder != null) {
                this.decoder.reset();
            }
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
            this.isDone = true;
            this.decoder = null;
            return;
        }
    }

    public String getEncoding() {
        return this.in != null ? this.encoding : null;
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        boolean bl = false;
        if (this.in.available() != 0) {
            bl = true;
        }
        return bl;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        if (this.isDone) {
            return -1;
        }
        if (this.decoder != null) {
            int n3;
            int n4 = (int)((double)n2 * (double)this.maxBytesPerChar);
            byte[] byArray = new byte[n4];
            int n5 = 0;
            if (this.byteBuffer != null) {
                n5 = this.byteBuffer.remaining();
                this.byteBuffer.get(byArray, 0, n5);
            }
            if (n4 - n5 > 0) {
                n3 = this.in.read(byArray, n5, n4 - n5);
                if (n3 == -1) {
                    n3 = n5;
                    this.isDone = true;
                } else {
                    n3 += n5;
                }
            } else {
                n3 = n5;
            }
            this.byteBuffer = ByteBuffer.wrap(byArray, 0, n3);
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n, n2);
            int n6 = charBuffer.position();
            if (this.hasSavedSurrogate) {
                this.hasSavedSurrogate = false;
                charBuffer.put(this.savedSurrogate);
                ++n3;
            }
            CoderResult coderResult = this.decoder.decode(this.byteBuffer, charBuffer, this.isDone);
            this.decoder.reset();
            if (coderResult.isOverflow() && charBuffer.hasRemaining()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(2);
                coderResult = this.decoder.decode(this.byteBuffer, charBuffer2, this.isDone);
                charBuffer2.flip();
                if (charBuffer2.hasRemaining()) {
                    charBuffer.put(charBuffer2.get());
                    this.savedSurrogate = charBuffer2.get();
                    this.hasSavedSurrogate = true;
                    this.isDone = false;
                }
            }
            if (this.byteBuffer.hasRemaining()) {
                this.byteBuffer.compact();
                this.byteBuffer.flip();
                this.isDone = false;
            } else {
                this.byteBuffer = null;
            }
            n3 = charBuffer.position() - n6;
            return n3 <= 0 ? -1 : n3;
        }
        byte[] byArray = new byte[n2];
        int n7 = this.in.read(byArray);
        int n8 = 0;
        while (n8 < n7) {
            cArray[n + n8] = (char)(byArray[n8] & 0xFF);
            ++n8;
        }
        return n7;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        return n > 0 ? cArray[0] : -1;
    }

    public long skip(long l) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        return super.skip(l);
    }

    private final /* synthetic */ void this() {
        this.isDone = false;
        this.hasSavedSurrogate = false;
    }

    public InputStreamReader(InputStream inputStream) {
        this.this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        try {
            this.encoding = SystemProperties.getProperty("file.encoding");
            if (EncodingHelper.isISOLatin1(this.encoding)) {
                this.encoding = "ISO8859_1";
                this.maxBytesPerChar = 1.0f;
                this.decoder = null;
                return;
            }
            Charset charset = EncodingHelper.getCharset(this.encoding);
            this.decoder = charset.newDecoder();
            this.encoding = EncodingHelper.getOldCanonical(charset.name());
            try {
                this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
        }
        catch (RuntimeException runtimeException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this.this();
        if (inputStream == null || string == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        if (EncodingHelper.isISOLatin1(string)) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
            return;
        }
        try {
            Charset charset = EncodingHelper.getCharset(string);
            try {
                this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.maxBytesPerChar = 1.0f;
            }
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.decoder.reset();
            this.encoding = EncodingHelper.getOldCanonical(charset.name());
        }
        catch (RuntimeException runtimeException) {
            this.encoding = "ISO8859_1";
            this.maxBytesPerChar = 1.0f;
            this.decoder = null;
        }
    }

    public InputStreamReader(InputStream inputStream, Charset charset) {
        this.this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.decoder = charset.newDecoder();
        try {
            this.maxBytesPerChar = charset.newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.maxBytesPerChar = 1.0f;
        }
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.reset();
        this.encoding = EncodingHelper.getOldCanonical(charset.name());
    }

    public InputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder) {
        this.this();
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.decoder = charsetDecoder;
        Charset charset = charsetDecoder.charset();
        try {
            this.maxBytesPerChar = charset == null ? 1.0f : charset.newEncoder().maxBytesPerChar();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.maxBytesPerChar = 1.0f;
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
        charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        charsetDecoder.reset();
        this.encoding = charset == null ? "US-ASCII" : EncodingHelper.getOldCanonical(charsetDecoder.charset().name());
    }
}

