/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int SIZE = 64;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('D');
    private final double value;

    public static final String toString(double d) {
        return VMDouble.toString(d, false);
    }

    public static final String toHexString(double d) {
        int n;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-Infinity" : "Infinity";
        }
        long l = Double.doubleToLongBits(d);
        StringBuilder stringBuilder = new StringBuilder();
        if (l < 0L) {
            stringBuilder.append('-');
        }
        stringBuilder.append("0x");
        long l2 = 0xFFFFFFFFFFFFFL;
        long l3 = l & l2;
        long l4 = 2047L;
        long l5 = l >>> 52 & l4;
        int n2 = 0;
        if (l5 == 0L) {
            n2 = 1;
        }
        stringBuilder.append(49 - n2);
        stringBuilder.append('.');
        stringBuilder.append(Long.toHexString(l3));
        if (l5 == 0L && l3 != 0L) {
            int n3 = 0;
            if (l < 0L) {
                n3 = 1;
            }
            n = 4 + n3;
            int n4 = n + 13;
            while (stringBuilder.length() < n4) {
                stringBuilder.insert(n, '0');
            }
        }
        stringBuilder.append('p');
        if (l5 != 0L || l3 != 0L) {
            int n5 = 0;
            if (l5 == 0L) {
                n5 = 1;
            }
            n = n5;
            l5 -= 1023L;
            if (n != 0) {
                ++l5;
            }
        }
        stringBuilder.append(Long.toString(l5));
        return stringBuilder.toString();
    }

    public static final Double valueOf(double d) {
        return new Double(d);
    }

    public static final Double valueOf(String string) {
        return new Double(Double.parseDouble(string));
    }

    public static final double parseDouble(String string) {
        return VMDouble.parseDouble(string);
    }

    public static final boolean isNaN(double d) {
        boolean bl = false;
        if (d != d) {
            bl = true;
        }
        return bl;
    }

    public static final boolean isInfinite(double d) {
        boolean bl = false;
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            bl = true;
        }
        return bl;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public final String toString() {
        return Double.toString(this.value);
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return (long)this.value;
    }

    public final float floatValue() {
        return (float)this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = ((Double)object).value;
        if (this.value == d) {
            boolean bl = false;
            if (this.value != 0.0 || 1.0 / this.value == 1.0 / d) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (Double.isNaN(this.value) && Double.isNaN(d)) {
            bl = true;
        }
        return bl;
    }

    public static final long doubleToLongBits(double d) {
        return VMDouble.doubleToLongBits(d);
    }

    public static final long doubleToRawLongBits(double d) {
        return VMDouble.doubleToRawLongBits(d);
    }

    public static final double longBitsToDouble(long l) {
        return VMDouble.longBitsToDouble(l);
    }

    public final int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public final int compareTo(Object object) {
        return Double.compare(this.value, ((Double)object).value);
    }

    public static final int compare(double d, double d2) {
        if (Double.isNaN(d)) {
            return 1 - Double.isNaN(d2);
        }
        if (Double.isNaN(d2)) {
            return -1;
        }
        if (d == 0.0 && d2 == 0.0) {
            return (int)(1.0 / d - 1.0 / d2);
        }
        if (d == d2) {
            return 0;
        }
        return d > d2 ? 1 : -1;
    }

    public Double(double d) {
        this.value = d;
    }

    public Double(String string) {
        this.value = Double.parseDouble(string);
    }
}

