// This file is generated by TableGen. Do not edit.

#ifndef LLVM_CLANG_ATTR_CLASSES_INC
#define LLVM_CLANG_ATTR_CLASSES_INC

class AliasAttr : public Attr {
unsigned aliaseeLength;
char *aliasee;


 public:
  AliasAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Aliasee
             )
    : Attr(attr::Alias, L)
              , aliaseeLength(Aliasee.size()),aliasee(new (Ctx, 1) char[aliaseeLength])
  {
      std::memcpy(aliasee, Aliasee.data(), aliaseeLength);
  }

  virtual AliasAttr *clone (ASTContext &C) const;
  llvm::StringRef getAliasee() const {
    return llvm::StringRef(aliasee, aliaseeLength);
  }
  unsigned getAliaseeLength() const {
    return aliaseeLength;
  }
  void setAliasee(ASTContext &C, llvm::StringRef S) {
    aliaseeLength = S.size();
    this->aliasee = new (C, 1) char [aliaseeLength];
    std::memcpy(this->aliasee, S.data(), aliaseeLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Alias; }
  static bool classof(const AliasAttr *) { return true; }
};

class AlignMac68kAttr : public Attr {

 public:
  AlignMac68kAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::AlignMac68k, L)
  {
  }

  virtual AlignMac68kAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlignMac68k; }
  static bool classof(const AlignMac68kAttr *) { return true; }
};

class AlignedAttr : public Attr {
bool isalignmentExpr;
union {
Expr *alignmentExpr;
TypeSourceInfo *alignmentType;
};


 public:
  AlignedAttr(SourceLocation L, ASTContext &Ctx
              , bool IsAlignmentExpr, void *Alignment
             )
    : Attr(attr::Aligned, L)
              , isalignmentExpr(IsAlignmentExpr)
  {
    if (isalignmentExpr)
       alignmentExpr = reinterpret_cast<Expr *>(Alignment);
    else
       alignmentType = reinterpret_cast<TypeSourceInfo *>(Alignment);
  }

  virtual AlignedAttr *clone (ASTContext &C) const;
  bool isAlignmentDependent() const;
  unsigned getAlignment(ASTContext &Ctx) const;
  bool isAlignmentExpr() const {
    return isalignmentExpr;
  }
  Expr *getAlignmentExpr() const {
    assert(isalignmentExpr);
    return alignmentExpr;
  }
  TypeSourceInfo *getAlignmentType() const {
    assert(!isalignmentExpr);
    return alignmentType;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Aligned; }
  static bool classof(const AlignedAttr *) { return true; }
};

class AlwaysInlineAttr : public Attr {

 public:
  AlwaysInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::AlwaysInline, L)
  {
  }

  virtual AlwaysInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AlwaysInline; }
  static bool classof(const AlwaysInlineAttr *) { return true; }
};

class AnalyzerNoReturnAttr : public Attr {

 public:
  AnalyzerNoReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::AnalyzerNoReturn, L)
  {
  }

  virtual AnalyzerNoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::AnalyzerNoReturn; }
  static bool classof(const AnalyzerNoReturnAttr *) { return true; }
};

class AnnotateAttr : public Attr {
unsigned annotationLength;
char *annotation;


 public:
  AnnotateAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Annotation
             )
    : Attr(attr::Annotate, L)
              , annotationLength(Annotation.size()),annotation(new (Ctx, 1) char[annotationLength])
  {
      std::memcpy(annotation, Annotation.data(), annotationLength);
  }

  virtual AnnotateAttr *clone (ASTContext &C) const;
  llvm::StringRef getAnnotation() const {
    return llvm::StringRef(annotation, annotationLength);
  }
  unsigned getAnnotationLength() const {
    return annotationLength;
  }
  void setAnnotation(ASTContext &C, llvm::StringRef S) {
    annotationLength = S.size();
    this->annotation = new (C, 1) char [annotationLength];
    std::memcpy(this->annotation, S.data(), annotationLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Annotate; }
  static bool classof(const AnnotateAttr *) { return true; }
};

class AsmLabelAttr : public Attr {
unsigned labelLength;
char *label;


 public:
  AsmLabelAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Label
             )
    : Attr(attr::AsmLabel, L)
              , labelLength(Label.size()),label(new (Ctx, 1) char[labelLength])
  {
      std::memcpy(label, Label.data(), labelLength);
  }

  virtual AsmLabelAttr *clone (ASTContext &C) const;
  llvm::StringRef getLabel() const {
    return llvm::StringRef(label, labelLength);
  }
  unsigned getLabelLength() const {
    return labelLength;
  }
  void setLabel(ASTContext &C, llvm::StringRef S) {
    labelLength = S.size();
    this->label = new (C, 1) char [labelLength];
    std::memcpy(this->label, S.data(), labelLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::AsmLabel; }
  static bool classof(const AsmLabelAttr *) { return true; }
};

class BaseCheckAttr : public Attr {

 public:
  BaseCheckAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::BaseCheck, L)
  {
  }

  virtual BaseCheckAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::BaseCheck; }
  static bool classof(const BaseCheckAttr *) { return true; }
};

class BlocksAttr : public Attr {
public:
  enum BlockType {
    ByRef
  };
private:
  BlockType type;


 public:
  BlocksAttr(SourceLocation L, ASTContext &Ctx
              , BlockType Type
             )
    : Attr(attr::Blocks, L)
              , type(Type)
  {

  }

  virtual BlocksAttr *clone (ASTContext &C) const;
  BlockType getType() const {
    return type;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Blocks; }
  static bool classof(const BlocksAttr *) { return true; }
};

class CDeclAttr : public Attr {

 public:
  CDeclAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CDecl, L)
  {
  }

  virtual CDeclAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CDecl; }
  static bool classof(const CDeclAttr *) { return true; }
};

class CFReturnsNotRetainedAttr : public Attr {

 public:
  CFReturnsNotRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CFReturnsNotRetained, L)
  {
  }

  virtual CFReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsNotRetained; }
  static bool classof(const CFReturnsNotRetainedAttr *) { return true; }
};

class CFReturnsRetainedAttr : public Attr {

 public:
  CFReturnsRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CFReturnsRetained, L)
  {
  }

  virtual CFReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CFReturnsRetained; }
  static bool classof(const CFReturnsRetainedAttr *) { return true; }
};

class CarriesDependencyAttr : public Attr {

 public:
  CarriesDependencyAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::CarriesDependency, L)
  {
  }

  virtual CarriesDependencyAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::CarriesDependency; }
  static bool classof(const CarriesDependencyAttr *) { return true; }
};

class CleanupAttr : public Attr {
FunctionDecl * functionDecl;


 public:
  CleanupAttr(SourceLocation L, ASTContext &Ctx
              , FunctionDecl * FunctionDecl
             )
    : Attr(attr::Cleanup, L)
              , functionDecl(FunctionDecl)
  {

  }

  virtual CleanupAttr *clone (ASTContext &C) const;
  FunctionDecl * getFunctionDecl() const {
    return functionDecl;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Cleanup; }
  static bool classof(const CleanupAttr *) { return true; }
};

class ConstAttr : public Attr {

 public:
  ConstAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Const, L)
  {
  }

  virtual ConstAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Const; }
  static bool classof(const ConstAttr *) { return true; }
};

class ConstructorAttr : public Attr {
int priority;


 public:
  ConstructorAttr(SourceLocation L, ASTContext &Ctx
              , int Priority
             )
    : Attr(attr::Constructor, L)
              , priority(Priority)
  {

  }

  virtual ConstructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Constructor; }
  static bool classof(const ConstructorAttr *) { return true; }
};

class DLLExportAttr : public Attr {

 public:
  DLLExportAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::DLLExport, L)
  {
  }

  virtual DLLExportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLExport; }
  static bool classof(const DLLExportAttr *) { return true; }
};

class DLLImportAttr : public Attr {

 public:
  DLLImportAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::DLLImport, L)
  {
  }

  virtual DLLImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::DLLImport; }
  static bool classof(const DLLImportAttr *) { return true; }
};

class DeprecatedAttr : public Attr {

 public:
  DeprecatedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Deprecated, L)
  {
  }

  virtual DeprecatedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Deprecated; }
  static bool classof(const DeprecatedAttr *) { return true; }
};

class DestructorAttr : public Attr {
int priority;


 public:
  DestructorAttr(SourceLocation L, ASTContext &Ctx
              , int Priority
             )
    : Attr(attr::Destructor, L)
              , priority(Priority)
  {

  }

  virtual DestructorAttr *clone (ASTContext &C) const;
  int getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Destructor; }
  static bool classof(const DestructorAttr *) { return true; }
};

class FastCallAttr : public Attr {

 public:
  FastCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::FastCall, L)
  {
  }

  virtual FastCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::FastCall; }
  static bool classof(const FastCallAttr *) { return true; }
};

class FinalAttr : public Attr {

 public:
  FinalAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Final, L)
  {
  }

  virtual FinalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Final; }
  static bool classof(const FinalAttr *) { return true; }
};

class FormatAttr : public Attr {
unsigned typeLength;
char *type;

int formatIdx;

int firstArg;


 public:
  FormatAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Type
              , int FormatIdx
              , int FirstArg
             )
    : Attr(attr::Format, L)
              , typeLength(Type.size()),type(new (Ctx, 1) char[typeLength])
              , formatIdx(FormatIdx)
              , firstArg(FirstArg)
  {
      std::memcpy(type, Type.data(), typeLength);


  }

  virtual FormatAttr *clone (ASTContext &C) const;
  llvm::StringRef getType() const {
    return llvm::StringRef(type, typeLength);
  }
  unsigned getTypeLength() const {
    return typeLength;
  }
  void setType(ASTContext &C, llvm::StringRef S) {
    typeLength = S.size();
    this->type = new (C, 1) char [typeLength];
    std::memcpy(this->type, S.data(), typeLength);
  }

  int getFormatIdx() const {
    return formatIdx;
  }

  int getFirstArg() const {
    return firstArg;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Format; }
  static bool classof(const FormatAttr *) { return true; }
};

class FormatArgAttr : public Attr {
int formatIdx;


 public:
  FormatArgAttr(SourceLocation L, ASTContext &Ctx
              , int FormatIdx
             )
    : Attr(attr::FormatArg, L)
              , formatIdx(FormatIdx)
  {

  }

  virtual FormatArgAttr *clone (ASTContext &C) const;
  int getFormatIdx() const {
    return formatIdx;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::FormatArg; }
  static bool classof(const FormatArgAttr *) { return true; }
};

class GNUInlineAttr : public Attr {

 public:
  GNUInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::GNUInline, L)
  {
  }

  virtual GNUInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::GNUInline; }
  static bool classof(const GNUInlineAttr *) { return true; }
};

class HidingAttr : public Attr {

 public:
  HidingAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Hiding, L)
  {
  }

  virtual HidingAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Hiding; }
  static bool classof(const HidingAttr *) { return true; }
};

class IBActionAttr : public Attr {

 public:
  IBActionAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::IBAction, L)
  {
  }

  virtual IBActionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBAction; }
  static bool classof(const IBActionAttr *) { return true; }
};

class IBOutletAttr : public Attr {

 public:
  IBOutletAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::IBOutlet, L)
  {
  }

  virtual IBOutletAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutlet; }
  static bool classof(const IBOutletAttr *) { return true; }
};

class IBOutletCollectionAttr : public Attr {
QualType interface;


 public:
  IBOutletCollectionAttr(SourceLocation L, ASTContext &Ctx
              , QualType Interface
             )
    : Attr(attr::IBOutletCollection, L)
              , interface(Interface)
  {

  }

  virtual IBOutletCollectionAttr *clone (ASTContext &C) const;
  QualType getInterface() const {
    return interface;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::IBOutletCollection; }
  static bool classof(const IBOutletCollectionAttr *) { return true; }
};

class InitPriorityAttr : public Attr {
unsigned priority;


 public:
  InitPriorityAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Priority
             )
    : Attr(attr::InitPriority, L)
              , priority(Priority)
  {

  }

  virtual InitPriorityAttr *clone (ASTContext &C) const;
  unsigned getPriority() const {
    return priority;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::InitPriority; }
  static bool classof(const InitPriorityAttr *) { return true; }
};

class MSP430InterruptAttr : public Attr {
unsigned number;


 public:
  MSP430InterruptAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Number
             )
    : Attr(attr::MSP430Interrupt, L)
              , number(Number)
  {

  }

  virtual MSP430InterruptAttr *clone (ASTContext &C) const;
  unsigned getNumber() const {
    return number;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MSP430Interrupt; }
  static bool classof(const MSP430InterruptAttr *) { return true; }
};

class MallocAttr : public Attr {

 public:
  MallocAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Malloc, L)
  {
  }

  virtual MallocAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Malloc; }
  static bool classof(const MallocAttr *) { return true; }
};

class MaxFieldAlignmentAttr : public Attr {
unsigned alignment;


 public:
  MaxFieldAlignmentAttr(SourceLocation L, ASTContext &Ctx
              , unsigned Alignment
             )
    : Attr(attr::MaxFieldAlignment, L)
              , alignment(Alignment)
  {

  }

  virtual MaxFieldAlignmentAttr *clone (ASTContext &C) const;
  unsigned getAlignment() const {
    return alignment;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::MaxFieldAlignment; }
  static bool classof(const MaxFieldAlignmentAttr *) { return true; }
};

class NSReturnsNotRetainedAttr : public Attr {

 public:
  NSReturnsNotRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NSReturnsNotRetained, L)
  {
  }

  virtual NSReturnsNotRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsNotRetained; }
  static bool classof(const NSReturnsNotRetainedAttr *) { return true; }
};

class NSReturnsRetainedAttr : public Attr {

 public:
  NSReturnsRetainedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NSReturnsRetained, L)
  {
  }

  virtual NSReturnsRetainedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NSReturnsRetained; }
  static bool classof(const NSReturnsRetainedAttr *) { return true; }
};

class NoDebugAttr : public Attr {

 public:
  NoDebugAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NoDebug, L)
  {
  }

  virtual NoDebugAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoDebug; }
  static bool classof(const NoDebugAttr *) { return true; }
};

class NoInlineAttr : public Attr {

 public:
  NoInlineAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NoInline, L)
  {
  }

  virtual NoInlineAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInline; }
  static bool classof(const NoInlineAttr *) { return true; }
};

class NoInstrumentFunctionAttr : public Attr {

 public:
  NoInstrumentFunctionAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NoInstrumentFunction, L)
  {
  }

  virtual NoInstrumentFunctionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoInstrumentFunction; }
  static bool classof(const NoInstrumentFunctionAttr *) { return true; }
};

class NoReturnAttr : public Attr {

 public:
  NoReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NoReturn, L)
  {
  }

  virtual NoReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoReturn; }
  static bool classof(const NoReturnAttr *) { return true; }
};

class NoThrowAttr : public Attr {

 public:
  NoThrowAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::NoThrow, L)
  {
  }

  virtual NoThrowAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::NoThrow; }
  static bool classof(const NoThrowAttr *) { return true; }
};

class NonNullAttr : public Attr {
  unsigned argsSize;
  unsigned *args;


 public:
  NonNullAttr(SourceLocation L, ASTContext &Ctx
              , unsigned *Args, unsigned ArgsSize
             )
    : Attr(attr::NonNull, L)
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual NonNullAttr *clone (ASTContext &C) const;
  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }

bool isNonNull(unsigned idx) const {
    for (args_iterator i = args_begin(), e = args_end();
         i != e; ++i)
      if (*i == idx)
        return true;
    return false;
  } 

  static bool classof(const Attr *A) { return A->getKind() == attr::NonNull; }
  static bool classof(const NonNullAttr *) { return true; }
};

class ObjCExceptionAttr : public Attr {

 public:
  ObjCExceptionAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::ObjCException, L)
  {
  }

  virtual ObjCExceptionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCException; }
  static bool classof(const ObjCExceptionAttr *) { return true; }
};

class ObjCNSObjectAttr : public Attr {

 public:
  ObjCNSObjectAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::ObjCNSObject, L)
  {
  }

  virtual ObjCNSObjectAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ObjCNSObject; }
  static bool classof(const ObjCNSObjectAttr *) { return true; }
};

class OverloadableAttr : public Attr {

 public:
  OverloadableAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Overloadable, L)
  {
  }

  virtual OverloadableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Overloadable; }
  static bool classof(const OverloadableAttr *) { return true; }
};

class OverrideAttr : public Attr {

 public:
  OverrideAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Override, L)
  {
  }

  virtual OverrideAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Override; }
  static bool classof(const OverrideAttr *) { return true; }
};

class OwnershipAttr : public Attr {
public:
  enum OwnershipKind {
    Holds,
    Returns,
    Takes
  };
private:
  OwnershipKind ownKind;

unsigned moduleLength;
char *module;

  unsigned argsSize;
  unsigned *args;


 public:
  OwnershipAttr(SourceLocation L, ASTContext &Ctx
              , OwnershipKind OwnKind
              , llvm::StringRef Module
              , unsigned *Args, unsigned ArgsSize
             )
    : Attr(attr::Ownership, L)
              , ownKind(OwnKind)
              , moduleLength(Module.size()),module(new (Ctx, 1) char[moduleLength])
              , argsSize(ArgsSize), args(new (Ctx, 16) unsigned[argsSize])
  {

      std::memcpy(module, Module.data(), moduleLength);
    std::memcpy(args, Args, argsSize * sizeof(unsigned));

  }

  virtual OwnershipAttr *clone (ASTContext &C) const;
  OwnershipKind getOwnKind() const {
    return ownKind;
  }

  llvm::StringRef getModule() const {
    return llvm::StringRef(module, moduleLength);
  }
  unsigned getModuleLength() const {
    return moduleLength;
  }
  void setModule(ASTContext &C, llvm::StringRef S) {
    moduleLength = S.size();
    this->module = new (C, 1) char [moduleLength];
    std::memcpy(this->module, S.data(), moduleLength);
  }

  typedef unsigned* args_iterator;
  args_iterator args_begin() const {
    return args;
  }
  args_iterator args_end() const {
    return args + argsSize;
  }
  unsigned args_size() const {
    return argsSize;
;  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Ownership; }
  static bool classof(const OwnershipAttr *) { return true; }
};

class PackedAttr : public Attr {

 public:
  PackedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Packed, L)
  {
  }

  virtual PackedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Packed; }
  static bool classof(const PackedAttr *) { return true; }
};

class PascalAttr : public Attr {

 public:
  PascalAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Pascal, L)
  {
  }

  virtual PascalAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pascal; }
  static bool classof(const PascalAttr *) { return true; }
};

class PureAttr : public Attr {

 public:
  PureAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Pure, L)
  {
  }

  virtual PureAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Pure; }
  static bool classof(const PureAttr *) { return true; }
};

class RegparmAttr : public Attr {
unsigned numParams;


 public:
  RegparmAttr(SourceLocation L, ASTContext &Ctx
              , unsigned NumParams
             )
    : Attr(attr::Regparm, L)
              , numParams(NumParams)
  {

  }

  virtual RegparmAttr *clone (ASTContext &C) const;
  unsigned getNumParams() const {
    return numParams;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Regparm; }
  static bool classof(const RegparmAttr *) { return true; }
};

class ReqdWorkGroupSizeAttr : public Attr {
unsigned xDim;

unsigned yDim;

unsigned zDim;


 public:
  ReqdWorkGroupSizeAttr(SourceLocation L, ASTContext &Ctx
              , unsigned XDim
              , unsigned YDim
              , unsigned ZDim
             )
    : Attr(attr::ReqdWorkGroupSize, L)
              , xDim(XDim)
              , yDim(YDim)
              , zDim(ZDim)
  {



  }

  virtual ReqdWorkGroupSizeAttr *clone (ASTContext &C) const;
  unsigned getXDim() const {
    return xDim;
  }

  unsigned getYDim() const {
    return yDim;
  }

  unsigned getZDim() const {
    return zDim;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::ReqdWorkGroupSize; }
  static bool classof(const ReqdWorkGroupSizeAttr *) { return true; }
};

class SectionAttr : public Attr {
unsigned nameLength;
char *name;


 public:
  SectionAttr(SourceLocation L, ASTContext &Ctx
              , llvm::StringRef Name
             )
    : Attr(attr::Section, L)
              , nameLength(Name.size()),name(new (Ctx, 1) char[nameLength])
  {
      std::memcpy(name, Name.data(), nameLength);
  }

  virtual SectionAttr *clone (ASTContext &C) const;
  llvm::StringRef getName() const {
    return llvm::StringRef(name, nameLength);
  }
  unsigned getNameLength() const {
    return nameLength;
  }
  void setName(ASTContext &C, llvm::StringRef S) {
    nameLength = S.size();
    this->name = new (C, 1) char [nameLength];
    std::memcpy(this->name, S.data(), nameLength);
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Section; }
  static bool classof(const SectionAttr *) { return true; }
};

class SentinelAttr : public Attr {
int sentinel;

int nullPos;


 public:
  SentinelAttr(SourceLocation L, ASTContext &Ctx
              , int Sentinel
              , int NullPos
             )
    : Attr(attr::Sentinel, L)
              , sentinel(Sentinel)
              , nullPos(NullPos)
  {


  }

  virtual SentinelAttr *clone (ASTContext &C) const;
  int getSentinel() const {
    return sentinel;
  }

  int getNullPos() const {
    return nullPos;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Sentinel; }
  static bool classof(const SentinelAttr *) { return true; }
};

class StdCallAttr : public Attr {

 public:
  StdCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::StdCall, L)
  {
  }

  virtual StdCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::StdCall; }
  static bool classof(const StdCallAttr *) { return true; }
};

class ThisCallAttr : public Attr {

 public:
  ThisCallAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::ThisCall, L)
  {
  }

  virtual ThisCallAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::ThisCall; }
  static bool classof(const ThisCallAttr *) { return true; }
};

class TransparentUnionAttr : public Attr {

 public:
  TransparentUnionAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::TransparentUnion, L)
  {
  }

  virtual TransparentUnionAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::TransparentUnion; }
  static bool classof(const TransparentUnionAttr *) { return true; }
};

class UnavailableAttr : public Attr {

 public:
  UnavailableAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Unavailable, L)
  {
  }

  virtual UnavailableAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Unavailable; }
  static bool classof(const UnavailableAttr *) { return true; }
};

class UnusedAttr : public Attr {

 public:
  UnusedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Unused, L)
  {
  }

  virtual UnusedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Unused; }
  static bool classof(const UnusedAttr *) { return true; }
};

class UsedAttr : public Attr {

 public:
  UsedAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Used, L)
  {
  }

  virtual UsedAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Used; }
  static bool classof(const UsedAttr *) { return true; }
};

class VecReturnAttr : public Attr {

 public:
  VecReturnAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::VecReturn, L)
  {
  }

  virtual VecReturnAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::VecReturn; }
  static bool classof(const VecReturnAttr *) { return true; }
};

class VisibilityAttr : public Attr {
public:
  enum VisibilityType {
    Default,
    Hidden,
    Protected
  };
private:
  VisibilityType visibility;


 public:
  VisibilityAttr(SourceLocation L, ASTContext &Ctx
              , VisibilityType Visibility
             )
    : Attr(attr::Visibility, L)
              , visibility(Visibility)
  {

  }

  virtual VisibilityAttr *clone (ASTContext &C) const;
  VisibilityType getVisibility() const {
    return visibility;
  }



  static bool classof(const Attr *A) { return A->getKind() == attr::Visibility; }
  static bool classof(const VisibilityAttr *) { return true; }
};

class WarnUnusedResultAttr : public Attr {

 public:
  WarnUnusedResultAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::WarnUnusedResult, L)
  {
  }

  virtual WarnUnusedResultAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WarnUnusedResult; }
  static bool classof(const WarnUnusedResultAttr *) { return true; }
};

class WeakAttr : public Attr {

 public:
  WeakAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::Weak, L)
  {
  }

  virtual WeakAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::Weak; }
  static bool classof(const WeakAttr *) { return true; }
};

class WeakImportAttr : public Attr {

 public:
  WeakImportAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::WeakImport, L)
  {
  }

  virtual WeakImportAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakImport; }
  static bool classof(const WeakImportAttr *) { return true; }
};

class WeakRefAttr : public Attr {

 public:
  WeakRefAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::WeakRef, L)
  {
  }

  virtual WeakRefAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::WeakRef; }
  static bool classof(const WeakRefAttr *) { return true; }
};

class X86ForceAlignArgPointerAttr : public Attr {

 public:
  X86ForceAlignArgPointerAttr(SourceLocation L, ASTContext &Ctx
             )
    : Attr(attr::X86ForceAlignArgPointer, L)
  {
  }

  virtual X86ForceAlignArgPointerAttr *clone (ASTContext &C) const;


  static bool classof(const Attr *A) { return A->getKind() == attr::X86ForceAlignArgPointer; }
  static bool classof(const X86ForceAlignArgPointerAttr *) { return true; }
};

#endif
