/***************************************************************************
                    qgspluginlayerregistry.cpp - class for
                    registering plugin layer creators
                             -------------------
    begin                : Mon Nov 30 2009
    copyright            : (C) 2009 by Mathias Walker, Sourcepole
    email                : mwa at sourcepole.ch
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgspluginlayerregistry.h 13380 2010-04-25 12:51:49Z jef $ */

#ifndef QGSPLUGINLAYERREGSITRY_H
#define QGSPLUGINLAYERREGSITRY_H

#include <QMap>
#include <QDomNode>

class QgsPluginLayer;

/** \ingroup core
    class for creating plugin specific layers

  \note added in v1.5
*/
class CORE_EXPORT QgsPluginLayerType
{
  public:

    QgsPluginLayerType( QString name );
    virtual ~QgsPluginLayerType();

    QString name();

    /** return new layer of this type. Return NULL on error */
    virtual QgsPluginLayer* createLayer();

    /** show plugin layer properties dialog. Return false if the dialog cannot be shown. */
    virtual bool showLayerProperties( QgsPluginLayer* layer );

  protected:
    QString mName;
};

//=============================================================================

/** \ingroup core
    a registry of plugin layers types

  \note added in v1.5
*/
class CORE_EXPORT QgsPluginLayerRegistry
{
  public:

    /** means of accessing canonical single instance  */
    static QgsPluginLayerRegistry* instance();

    ~QgsPluginLayerRegistry();

    /** add plugin layer type (take ownership) and return true on success */
    bool addPluginLayerType( QgsPluginLayerType* pluginLayerType );

    /** remove plugin layer type and return true on success */
    bool removePluginLayerType( QString typeName );

    /** return plugin layer type metadata or NULL if doesn't exist */
    QgsPluginLayerType* pluginLayerType( QString typeName );

    /** return new layer if corresponding plugin has been found, else return NULL */
    QgsPluginLayer* createLayer( QString typeName );

  private:

    typedef QMap<QString, QgsPluginLayerType*> PluginLayerTypes;

    /** private since instance() creates it */
    QgsPluginLayerRegistry();

    /** pointer to canonical Singleton object */
    static QgsPluginLayerRegistry* _instance;

    PluginLayerTypes mPluginLayerTypes;
};

#endif // QGSPLUGINLAYERREGSITRY_H
