"""
$RCSfile: alltests.py,v $

Run all ZopeXMLMethods unit tests

Author: Ariel Partners LLC <support@arielpartners.com>
Modified by Philipp "philiKON" von Weitershausen <philikon@philikon.de>

$Id: alltests.py,v 1.5 2003/03/30 20:51:59 cstrong Exp $
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 20:51:59 $'[6:-2]
__version__ = '$Revision: 1.5 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

# Import the TestCase from each module
from TestCacheManager import CacheManagerTestCase
from TestXSLTMethod import XSLTMethodTestCase
from TestXSLTProcessor import XSLTProcessorTestCase
from Products.ZopeXMLMethods import ProcessorChooser

# Add the TestCase class to this list
unitTests = (
    CacheManagerTestCase,
    XSLTMethodTestCase,
    XSLTProcessorTestCase
    )

################################################################
# The rest is boilerplate: don't touch
################################################################
import unittest, os

masterSuite = unittest.TestSuite(map(lambda x: unittest.makeSuite(x, 'test'),
                                     unitTests))

runner = unittest.TextTestRunner()

if __name__ == '__main__':

    # Specify which processor to use
    # ProcessorChooser.default = '4Suite-0.11.1'
        
    # report which processor we are using
    print "Using processor:", \
          ProcessorChooser.ProcessorChooser().defaultProcessor()
    
    runner.run(masterSuite)
