<?php
/**
 * This file contains a mapping of common file extensions to
 * MIME types. It has been automatically generated from the
 * framework/devtools/mime_mapping directory.
 *
 * ALL changes should be made to framework/devtools/mime_mapping/mime.types.horde
 * or else they will be lost when this file is regenerated.
 *
 * Any unknown file extensions will automatically be mapped to
 * 'x-extension/<ext>' where <ext> is the unknown file extension.
 *
 * @package Horde_MIME
 *
 * $Horde: framework/MIME/MIME/mime.mapping.php,v 1.11.2.7 2010-09-21 13:32:10 jan Exp $
 *
 * Generated: 11/05/08 23:30:23 by chuck on technest.org
 */
$mime_extension_map = array(
    '__MAXPERIOD__' => '1',
    'ez'            => 'application/andrew-inset',
    'atom'          => 'application/atom+xml',
    'atomcat'       => 'application/atomcat+xml',
    'atomsvc'       => 'application/atomsvc+xml',
    'ccxml'         => 'application/ccxml+xml',
    'davmount'      => 'application/davmount+xml',
    'ecma'          => 'application/ecmascript',
    'pfr'           => 'application/font-tdpfr',
    'stk'           => 'application/hyperstudio',
    'js'            => 'application/x-javascript',
    'json'          => 'application/json',
    'hqx'           => 'application/mac-binhex40',
    'cpt'           => 'application/mac-compactpro',
    'mrc'           => 'application/marc',
    'ma'            => 'application/mathematica',
    'nb'            => 'application/mathematica',
    'mb'            => 'application/mathematica',
    'mathml'        => 'application/mathml+xml',
    'mbox'          => 'application/mbox',
    'mscml'         => 'application/mediaservercontrol+xml',
    'mp4s'          => 'application/mp4',
    'doc'           => 'application/msword',
    'dot'           => 'application/msword',
    'mxf'           => 'application/mxf',
    'bin'           => 'application/octet-stream',
    'dms'           => 'application/octet-stream',
    'lha'           => 'application/x-lha',
    'lzh'           => 'application/x-lha',
    'class'         => 'application/x-java',
    'so'            => 'application/x-sharedlib',
    'iso'           => 'application/x-cd-image',
    'dmg'           => 'application/octet-stream',
    'dist'          => 'application/octet-stream',
    'distz'         => 'application/octet-stream',
    'pkg'           => 'application/octet-stream',
    'bpk'           => 'application/octet-stream',
    'dump'          => 'application/octet-stream',
    'elc'           => 'application/octet-stream',
    'oda'           => 'application/oda',
    'ogg'           => 'application/ogg',
    'pdf'           => 'application/pdf',
    'pgp'           => 'application/pgp',
    'asc'           => 'text/plain',
    'sig'           => 'application/pgp-signature',
    'prf'           => 'application/pics-rules',
    'p10'           => 'application/pkcs10',
    'p7m'           => 'application/pkcs7-mime',
    'p7c'           => 'application/pkcs7-mime',
    'p7s'           => 'application/pkcs7-signature',
    'cer'           => 'application/x-x509-ca-cert',
    'crl'           => 'application/pkix-crl',
    'pkipath'       => 'application/pkix-pkipath',
    'pki'           => 'application/pkixcmp',
    'pls'           => 'audio/x-scpls',
    'ai'            => 'application/illustrator',
    'eps'           => 'image/x-eps',
    'ps'            => 'application/postscript',
    'cww'           => 'application/prs.cww',
    'rdf'           => 'text/rdf',
    'rif'           => 'application/reginfo+xml',
    'rnc'           => 'application/relax-ng-compact-syntax',
    'rl'            => 'application/resource-lists+xml',
    'rs'            => 'application/rls-services+xml',
    'rsd'           => 'application/rsd+xml',
    'rss'           => 'text/rss',
    'rtf'           => 'application/rtf',
    'sbml'          => 'application/sbml+xml',
    'scq'           => 'application/scvp-cv-request',
    'scs'           => 'application/scvp-cv-response',
    'spq'           => 'application/scvp-vp-request',
    'spp'           => 'application/scvp-vp-response',
    'sdp'           => 'application/vnd.stardivision.impress',
    'setpay'        => 'application/set-payment-initiation',
    'setreg'        => 'application/set-registration-initiation',
    'shf'           => 'application/shf+xml',
    'smi'           => 'application/smil',
    'smil'          => 'application/smil',
    'rq'            => 'application/sparql-query',
    'srx'           => 'application/sparql-results+xml',
    'gram'          => 'application/srgs',
    'grxml'         => 'application/srgs+xml',
    'ssml'          => 'application/ssml+xml',
    'plb'           => 'application/vnd.3gpp.pic-bw-large',
    'psb'           => 'application/vnd.3gpp.pic-bw-small',
    'pvb'           => 'application/vnd.3gpp.pic-bw-var',
    'tcap'          => 'application/vnd.3gpp2.tcap',
    'pwn'           => 'application/vnd.3m.post-it-notes',
    'aso'           => 'application/vnd.accpac.simply.aso',
    'imp'           => 'application/vnd.accpac.simply.imp',
    'acu'           => 'application/vnd.acucobol',
    'atc'           => 'application/vnd.acucorp',
    'acutc'         => 'application/vnd.acucorp',
    'xdp'           => 'application/vnd.adobe.xdp+xml',
    'xfdf'          => 'application/vnd.adobe.xfdf',
    'ami'           => 'application/vnd.amiga.ami',
    'cii'           => 'application/vnd.anser-web-certificate-issue-initiation',
    'fti'           => 'application/vnd.anser-web-funds-transfer-initiation',
    'atx'           => 'application/vnd.antix.game-component',
    'mpkg'          => 'application/vnd.apple.installer+xml',
    'aep'           => 'application/vnd.audiograph',
    'mpm'           => 'application/vnd.blueice.multipass',
    'bmi'           => 'application/vnd.bmi',
    'rep'           => 'application/vnd.businessobjects',
    'cdxml'         => 'application/vnd.chemdraw+xml',
    'mmd'           => 'application/vnd.chipnuts.karaoke-mmd',
    'cdy'           => 'application/vnd.cinderella',
    'cla'           => 'application/vnd.claymore',
    'c4g'           => 'application/vnd.clonk.c4group',
    'c4d'           => 'application/vnd.clonk.c4group',
    'c4f'           => 'application/vnd.clonk.c4group',
    'c4p'           => 'application/vnd.clonk.c4group',
    'c4u'           => 'application/vnd.clonk.c4group',
    'csp'           => 'application/vnd.commonspace',
    'cst'           => 'application/vnd.commonspace',
    'cdbcmsg'       => 'application/vnd.contact.cmsg',
    'cmc'           => 'application/vnd.cosmocaller',
    'clkx'          => 'application/vnd.crick.clicker',
    'clkk'          => 'application/vnd.crick.clicker.keyboard',
    'clkp'          => 'application/vnd.crick.clicker.palette',
    'clkt'          => 'application/vnd.crick.clicker.template',
    'clkw'          => 'application/vnd.crick.clicker.wordbank',
    'wbs'           => 'application/vnd.criticaltools.wbs+xml',
    'pml'           => 'application/vnd.ctc-posml',
    'ppd'           => 'application/vnd.cups-ppd',
    'curl'          => 'application/vnd.curl',
    'rdz'           => 'application/vnd.data-vision.rdz',
    'fe_launch'     => 'application/vnd.denovo.fcselayout-link',
    'dna'           => 'application/vnd.dna',
    'mlp'           => 'application/vnd.dolby.mlp',
    'dpg'           => 'application/vnd.dpgraph',
    'dfac'          => 'application/vnd.dreamfactory',
    'mag'           => 'application/vnd.ecowin.chart',
    'nml'           => 'application/vnd.enliven',
    'esf'           => 'application/vnd.epson.esf',
    'msf'           => 'application/vnd.epson.msf',
    'qam'           => 'application/vnd.epson.quickanime',
    'slt'           => 'application/vnd.epson.salt',
    'ssf'           => 'application/vnd.epson.ssf',
    'es3'           => 'application/vnd.eszigno3+xml',
    'et3'           => 'application/vnd.eszigno3+xml',
    'ez2'           => 'application/vnd.ezpix-album',
    'ez3'           => 'application/vnd.ezpix-package',
    'fdf'           => 'application/vnd.fdf',
    'gph'           => 'application/vnd.flographit',
    'ftc'           => 'application/vnd.fluxtime.clip',
    'fm'            => 'application/vnd.framemaker',
    'frame'         => 'application/vnd.framemaker',
    'maker'         => 'application/vnd.framemaker',
    'fnc'           => 'application/vnd.frogans.fnc',
    'ltf'           => 'application/vnd.frogans.ltf',
    'fsc'           => 'application/vnd.fsc.weblaunch',
    'oas'           => 'application/vnd.fujitsu.oasys',
    'oa2'           => 'application/vnd.fujitsu.oasys2',
    'oa3'           => 'application/vnd.fujitsu.oasys3',
    'fg5'           => 'application/vnd.fujitsu.oasysgp',
    'bh2'           => 'application/vnd.fujitsu.oasysprs',
    'ddd'           => 'application/vnd.fujixerox.ddd',
    'xdw'           => 'application/vnd.fujixerox.docuworks',
    'xbd'           => 'application/vnd.fujixerox.docuworks.binder',
    'fzs'           => 'application/vnd.fuzzysheet',
    'txd'           => 'application/vnd.genomatix.tuxedo',
    'kml'           => 'application/vnd.google-earth.kml+xml',
    'kmz'           => 'application/vnd.google-earth.kmz',
    'gqf'           => 'application/vnd.grafeq',
    'gqs'           => 'application/vnd.grafeq',
    'gac'           => 'application/vnd.groove-account',
    'ghf'           => 'application/vnd.groove-help',
    'gim'           => 'application/vnd.groove-identity-message',
    'grv'           => 'application/vnd.groove-injector',
    'gtm'           => 'application/vnd.groove-tool-message',
    'tpl'           => 'application/vnd.groove-tool-template',
    'vcg'           => 'application/vnd.groove-vcard',
    'zmm'           => 'application/vnd.handheld-entertainment+xml',
    'hbci'          => 'application/vnd.hbci',
    'les'           => 'application/vnd.hhe.lesson-player',
    'hpgl'          => 'application/vnd.hp-hpgl',
    'hpid'          => 'application/vnd.hp-hpid',
    'hps'           => 'application/vnd.hp-hps',
    'jlt'           => 'application/vnd.hp-jlyt',
    'pcl'           => 'application/vnd.hp-pcl',
    'pclxl'         => 'application/vnd.hp-pclxl',
    'x3d'           => 'application/vnd.hzn-3d-crossword',
    'mpy'           => 'application/vnd.ibm.minipay',
    'afp'           => 'application/vnd.ibm.modcap',
    'listafp'       => 'application/vnd.ibm.modcap',
    'list3820'      => 'application/vnd.ibm.modcap',
    'irm'           => 'application/vnd.ibm.rights-management',
    'sc'            => 'application/vnd.ibm.secure-container',
    'igl'           => 'application/vnd.igloader',
    'ivp'           => 'application/vnd.immervision-ivp',
    'ivu'           => 'application/vnd.immervision-ivu',
    'xpw'           => 'application/vnd.intercon.formnet',
    'xpx'           => 'application/vnd.intercon.formnet',
    'qbo'           => 'application/vnd.intu.qbo',
    'qfx'           => 'application/vnd.intu.qfx',
    'rcprofile'     => 'application/vnd.ipunplugged.rcprofile',
    'irp'           => 'application/vnd.irepository.package+xml',
    'xpr'           => 'application/vnd.is-xpr',
    'jam'           => 'application/vnd.jam',
    'rms'           => 'application/vnd.jcp.javame.midlet-rms',
    'jisp'          => 'application/vnd.jisp',
    'joda'          => 'application/vnd.joost.joda-archive',
    'ktz'           => 'application/vnd.kahootz',
    'ktr'           => 'application/vnd.kahootz',
    'karbon'        => 'application/x-karbon',
    'chrt'          => 'application/x-kchart',
    'kfo'           => 'application/x-kformula',
    'flw'           => 'application/x-kivio',
    'kon'           => 'application/x-kontour',
    'kpr'           => 'application/x-kpresenter',
    'kpt'           => 'application/x-kpresenter',
    'ksp'           => 'application/x-kspread',
    'kwd'           => 'application/x-kword',
    'kwt'           => 'application/x-kword',
    'htke'          => 'application/vnd.kenameaapp',
    'kia'           => 'application/vnd.kidspiration',
    'kne'           => 'application/vnd.kinar',
    'knp'           => 'application/vnd.kinar',
    'skp'           => 'application/vnd.koan',
    'skd'           => 'application/vnd.koan',
    'skt'           => 'application/vnd.koan',
    'skm'           => 'application/vnd.koan',
    'lbd'           => 'application/vnd.llamagraphics.life-balance.desktop',
    'lbe'           => 'application/vnd.llamagraphics.life-balance.exchange+xml',
    '123'           => 'application/vnd.lotus-1-2-3',
    'apr'           => 'application/vnd.lotus-approach',
    'pre'           => 'application/vnd.lotus-freelance',
    'nsf'           => 'application/vnd.lotus-notes',
    'org'           => 'application/vnd.lotus-organizer',
    'scm'           => 'text/x-scheme',
    'lwp'           => 'application/vnd.lotus-wordpro',
    'portpkg'       => 'application/vnd.macports.portpkg',
    'mcd'           => 'application/vnd.mcd',
    'mc1'           => 'application/vnd.medcalcdata',
    'cdkey'         => 'application/vnd.mediastation.cdkey',
    'mwf'           => 'application/vnd.mfer',
    'mfm'           => 'application/vnd.mfmp',
    'flo'           => 'application/vnd.micrografx.flo',
    'igx'           => 'application/vnd.micrografx.igx',
    'mif'           => 'application/x-mif',
    'daf'           => 'application/vnd.mobius.daf',
    'dis'           => 'application/vnd.mobius.dis',
    'mbk'           => 'application/vnd.mobius.mbk',
    'mqy'           => 'application/vnd.mobius.mqy',
    'msl'           => 'application/vnd.mobius.msl',
    'plc'           => 'application/vnd.mobius.plc',
    'txf'           => 'application/vnd.mobius.txf',
    'mpn'           => 'application/vnd.mophun.application',
    'mpc'           => 'application/vnd.mophun.certificate',
    'xul'           => 'application/vnd.mozilla.xul+xml',
    'cil'           => 'application/vnd.ms-artgalry',
    'asf'           => 'video/x-ms-asf',
    'cab'           => 'application/vnd.ms-cab-compressed',
    'xls'           => 'application/vnd.ms-excel',
    'xlm'           => 'application/vnd.ms-excel',
    'xla'           => 'application/vnd.ms-excel',
    'xlc'           => 'application/vnd.ms-excel',
    'xlt'           => 'application/vnd.ms-excel',
    'xlw'           => 'application/vnd.ms-excel',
    'eot'           => 'application/vnd.ms-fontobject',
    'chm'           => 'application/x-chm',
    'ims'           => 'application/vnd.ms-ims',
    'lrm'           => 'application/vnd.ms-lrm',
    'ppt'           => 'application/vnd.ms-powerpoint',
    'pps'           => 'application/vnd.ms-powerpoint',
    'pot'           => 'text/x-gettext-translation-template',
    'mpp'           => 'application/vnd.ms-project',
    'mpt'           => 'application/vnd.ms-project',
    'wps'           => 'application/vnd.ms-works',
    'wks'           => 'application/vnd.lotus-1-2-3',
    'wcm'           => 'application/vnd.ms-works',
    'wdb'           => 'application/vnd.ms-works',
    'wpl'           => 'application/vnd.ms-wpl',
    'xps'           => 'application/vnd.ms-xpsdocument',
    'mseq'          => 'application/vnd.mseq',
    'mus'           => 'application/vnd.musician',
    'msty'          => 'application/vnd.muvee.style',
    'nlu'           => 'application/vnd.neurolanguage.nlu',
    'nnd'           => 'application/vnd.noblenet-directory',
    'nns'           => 'application/vnd.noblenet-sealer',
    'nnw'           => 'application/vnd.noblenet-web',
    'ngdat'         => 'application/vnd.nokia.n-gage.data',
    'n-gage'        => 'application/vnd.nokia.n-gage.symbian.install',
    'rpst'          => 'application/vnd.nokia.radio-preset',
    'rpss'          => 'application/vnd.nokia.radio-presets',
    'edm'           => 'application/vnd.novadigm.edm',
    'edx'           => 'application/vnd.novadigm.edx',
    'ext'           => 'application/vnd.novadigm.ext',
    'odc'           => 'application/vnd.oasis.opendocument.chart',
    'otc'           => 'application/vnd.oasis.opendocument.chart-template',
    'odf'           => 'application/vnd.oasis.opendocument.formula',
    'otf'           => 'application/vnd.oasis.opendocument.formula-template',
    'odg'           => 'application/vnd.oasis.opendocument.graphics',
    'otg'           => 'application/vnd.oasis.opendocument.graphics-template',
    'odi'           => 'application/vnd.oasis.opendocument.image',
    'oti'           => 'application/vnd.oasis.opendocument.image-template',
    'odp'           => 'application/vnd.oasis.opendocument.presentation',
    'otp'           => 'application/vnd.oasis.opendocument.presentation-template',
    'ods'           => 'application/vnd.oasis.opendocument.spreadsheet',
    'ots'           => 'application/vnd.oasis.opendocument.spreadsheet-template',
    'odt'           => 'application/vnd.oasis.opendocument.text',
    'otm'           => 'application/vnd.oasis.opendocument.text-master',
    'ott'           => 'application/vnd.oasis.opendocument.text-template',
    'oth'           => 'application/vnd.oasis.opendocument.text-web',
    'xo'            => 'application/vnd.olpc-sugar',
    'dd2'           => 'application/vnd.oma.dd2+xml',
    'oxt'           => 'application/vnd.openofficeorg.extension',
    'dp'            => 'application/vnd.osgi.dp',
    'prc'           => 'application/vnd.palm',
    'pdb'           => 'application/vnd.palm',
    'pqa'           => 'application/vnd.palm',
    'oprc'          => 'application/vnd.palm',
    'str'           => 'application/vnd.pg.format',
    'ei6'           => 'application/vnd.pg.osasli',
    'efif'          => 'application/vnd.picsel',
    'plf'           => 'application/vnd.pocketlearn',
    'pbd'           => 'application/vnd.powerbuilder6',
    'box'           => 'application/vnd.previewsystems.box',
    'mgz'           => 'application/vnd.proteus.magazine',
    'qps'           => 'application/vnd.publishare-delta-tree',
    'ptid'          => 'application/vnd.pvi.ptid1',
    'qxd'           => 'application/vnd.quark.quarkxpress',
    'qxt'           => 'application/vnd.quark.quarkxpress',
    'qwd'           => 'application/vnd.quark.quarkxpress',
    'qwt'           => 'application/vnd.quark.quarkxpress',
    'qxl'           => 'application/vnd.quark.quarkxpress',
    'qxb'           => 'application/vnd.quark.quarkxpress',
    'mxl'           => 'application/vnd.recordare.musicxml',
    'rm'            => 'audio/x-pn-realaudio',
    'see'           => 'application/vnd.seemail',
    'sema'          => 'application/vnd.sema',
    'semd'          => 'application/vnd.semd',
    'semf'          => 'application/vnd.semf',
    'ifm'           => 'application/vnd.shana.informed.formdata',
    'itp'           => 'application/vnd.shana.informed.formtemplate',
    'iif'           => 'application/vnd.shana.informed.interchange',
    'ipk'           => 'application/vnd.shana.informed.package',
    'twd'           => 'application/vnd.simtech-mindmapper',
    'twds'          => 'application/vnd.simtech-mindmapper',
    'mmf'           => 'application/vnd.smaf',
    'sdkm'          => 'application/vnd.solent.sdkm+xml',
    'sdkd'          => 'application/vnd.solent.sdkm+xml',
    'dxp'           => 'application/vnd.spotfire.dxp',
    'sfs'           => 'application/vnd.spotfire.sfs',
    'sus'           => 'application/vnd.sus-calendar',
    'susp'          => 'application/vnd.sus-calendar',
    'svd'           => 'application/vnd.svd',
    'xsm'           => 'application/vnd.syncml+xml',
    'bdm'           => 'application/vnd.syncml.dm+wbxml',
    'xdm'           => 'application/vnd.syncml.dm+xml',
    'tao'           => 'application/vnd.tao.intent-module-archive',
    'tmo'           => 'application/vnd.tmobile-livetv',
    'tpt'           => 'application/vnd.trid.tpt',
    'mxs'           => 'application/vnd.triscape.mxs',
    'tra'           => 'application/vnd.trueapp',
    'ufd'           => 'application/vnd.ufdl',
    'ufdl'          => 'application/vnd.ufdl',
    'utz'           => 'application/vnd.uiq.theme',
    'umj'           => 'application/vnd.umajin',
    'unityweb'      => 'application/vnd.unity',
    'uoml'          => 'application/vnd.uoml+xml',
    'vcx'           => 'application/vnd.vcx',
    'vsd'           => 'application/vnd.visio',
    'vst'           => 'application/vnd.visio',
    'vss'           => 'application/vnd.visio',
    'vsw'           => 'application/vnd.visio',
    'vis'           => 'application/vnd.visionary',
    'vsf'           => 'application/vnd.vsf',
    'wbxml'         => 'application/vnd.wap.wbxml',
    'wmlc'          => 'application/vnd.wap.wmlc',
    'wmlsc'         => 'application/vnd.wap.wmlscriptc',
    'wtb'           => 'application/vnd.webturbo',
    'wpd'           => 'application/vnd.wordperfect',
    'wqd'           => 'application/vnd.wqd',
    'stf'           => 'application/vnd.wt.stf',
    'xar'           => 'application/vnd.xara',
    'xfdl'          => 'application/vnd.xfdl',
    'hvd'           => 'application/vnd.yamaha.hv-dic',
    'hvs'           => 'application/vnd.yamaha.hv-script',
    'hvp'           => 'application/vnd.yamaha.hv-voice',
    'saf'           => 'application/vnd.yamaha.smaf-audio',
    'spf'           => 'application/vnd.yamaha.smaf-phrase',
    'cmp'           => 'application/vnd.yellowriver-custom-menu',
    'zaz'           => 'application/vnd.zzazz.deck+xml',
    'vxml'          => 'application/voicexml+xml',
    'hlp'           => 'application/winhlp',
    'wsdl'          => 'application/wsdl+xml',
    'wspolicy'      => 'application/wspolicy+xml',
    'ace'           => 'application/x-ace-compressed',
    'bcpio'         => 'application/x-bcpio',
    'torrent'       => 'application/x-bittorrent',
    'bz'            => 'application/x-bzip',
    'bz2'           => 'application/x-bzip',
    'boz'           => 'application/x-bzip2',
    'vcd'           => 'application/x-cdlink',
    'chat'          => 'application/x-chat',
    'pgn'           => 'application/x-chess-pgn',
    'cpio'          => 'application/x-cpio',
    'csh'           => 'application/x-csh',
    'dcr'           => 'application/x-director',
    'dir'           => 'application/x-director',
    'dxr'           => 'application/x-director',
    'fgd'           => 'application/x-director',
    'dvi'           => 'application/x-dvi',
    'spl'           => 'application/x-futuresplash',
    'gtar'          => 'application/x-gtar',
    'hdf'           => 'application/x-hdf',
    'latex'         => 'application/x-latex',
    'wmd'           => 'application/x-ms-wmd',
    'wmz'           => 'application/x-ms-wmz',
    'mdb'           => 'application/x-msaccess',
    'obd'           => 'application/x-msbinder',
    'crd'           => 'application/x-mscardfile',
    'clp'           => 'application/x-msclip',
    'exe'           => 'application/x-ms-dos-executable',
    'dll'           => 'application/x-msdownload',
    'com'           => 'application/x-msdownload',
    'bat'           => 'application/x-msdownload',
    'msi'           => 'application/x-msdownload',
    'mvb'           => 'application/x-msmediaview',
    'm13'           => 'application/x-msmediaview',
    'm14'           => 'application/x-msmediaview',
    'wmf'           => 'image/x-wmf',
    'mny'           => 'application/x-msmoney',
    'pub'           => 'application/x-mspublisher',
    'scd'           => 'application/x-msschedule',
    'trm'           => 'application/x-msterminal',
    'wri'           => 'application/x-mswrite',
    'nc'            => 'application/x-netcdf',
    'cdf'           => 'application/x-netcdf',
    'p12'           => 'application/x-pkcs12',
    'pfx'           => 'application/x-pkcs12',
    'p7b'           => 'application/x-pkcs7-certificates',
    'spc'           => 'application/x-pkcs7-certificates',
    'p7r'           => 'application/x-pkcs7-certreqresp',
    'rar'           => 'application/x-rar',
    'sh'            => 'application/x-shellscript',
    'shar'          => 'application/x-shar',
    'swf'           => 'application/x-shockwave-flash',
    'sit'           => 'application/stuffit',
    'sitx'          => 'application/x-stuffitx',
    'sv4cpio'       => 'application/x-sv4cpio',
    'sv4crc'        => 'application/x-sv4crc',
    'tar'           => 'application/x-tar',
    'tcl'           => 'text/x-tcl',
    'tex'           => 'text/x-tex',
    'texinfo'       => 'text/x-texinfo',
    'texi'          => 'text/x-texinfo',
    'ustar'         => 'application/x-ustar',
    'src'           => 'application/x-wais-source',
    'der'           => 'application/x-x509-ca-cert',
    'crt'           => 'application/x-x509-ca-cert',
    'xenc'          => 'application/xenc+xml',
    'xhtml'         => 'application/xhtml+xml',
    'xht'           => 'application/xhtml+xml',
    'xml'           => 'text/xml',
    'xsl'           => 'text/x-xslt',
    'dtd'           => 'text/x-dtd',
    'xop'           => 'application/xop+xml',
    'xslt'          => 'text/x-xslt',
    'xspf'          => 'application/xspf+xml',
    'mxml'          => 'application/xv+xml',
    'xhvml'         => 'application/xv+xml',
    'xvml'          => 'application/xv+xml',
    'xvm'           => 'application/xv+xml',
    'zip'           => 'application/zip',
    'au'            => 'audio/basic',
    'snd'           => 'audio/basic',
    'mid'           => 'audio/midi',
    'midi'          => 'audio/midi',
    'kar'           => 'audio/midi',
    'rmi'           => 'audio/midi',
    'mp4a'          => 'audio/mp4',
    'mpga'          => 'audio/mpeg',
    'mp2'           => 'video/mpeg',
    'mp2a'          => 'audio/mpeg',
    'mp3'           => 'audio/mpeg',
    'm2a'           => 'audio/mpeg',
    'm3a'           => 'audio/mpeg',
    'eol'           => 'audio/vnd.digital-winds',
    'lvp'           => 'audio/vnd.lucent.voice',
    'ecelp4800'     => 'audio/vnd.nuera.ecelp4800',
    'ecelp7470'     => 'audio/vnd.nuera.ecelp7470',
    'ecelp9600'     => 'audio/vnd.nuera.ecelp9600',
    'wav'           => 'audio/x-wav',
    'aif'           => 'audio/x-aiff',
    'aiff'          => 'audio/x-aiff',
    'aifc'          => 'audio/x-aiff',
    'm3u'           => 'audio/x-mpegurl',
    'wax'           => 'audio/x-ms-wax',
    'wma'           => 'audio/x-ms-wma',
    'ram'           => 'audio/x-pn-realaudio',
    'ra'            => 'audio/x-pn-realaudio',
    'rmp'           => 'audio/x-pn-realaudio-plugin',
    'cdx'           => 'chemical/x-cdx',
    'cif'           => 'chemical/x-cif',
    'cmdf'          => 'chemical/x-cmdf',
    'cml'           => 'chemical/x-cml',
    'csml'          => 'chemical/x-csml',
    'xyz'           => 'chemical/x-xyz',
    'bmp'           => 'image/bmp',
    'cgm'           => 'image/cgm',
    'g3'            => 'image/fax-g3',
    'gif'           => 'image/gif',
    'ief'           => 'image/ief',
    'jpg'           => 'image/jpeg',
    'jpeg'          => 'image/jpeg',
    'jpe'           => 'image/jpeg',
    'png'           => 'image/png',
    'btif'          => 'image/prs.btif',
    'svg'           => 'image/svg+xml',
    'svgz'          => 'image/svg+xml',
    'tiff'          => 'image/tiff',
    'tif'           => 'image/tiff',
    'psd'           => 'image/x-psd',
    'djvu'          => 'image/vnd.djvu',
    'djv'           => 'image/vnd.djvu',
    'dwg'           => 'image/vnd.dwg',
    'dxf'           => 'image/vnd.dxf',
    'fbs'           => 'image/vnd.fastbidsheet',
    'fpx'           => 'image/vnd.fpx',
    'fst'           => 'image/vnd.fst',
    'mmr'           => 'image/vnd.fujixerox.edmics-mmr',
    'rlc'           => 'image/vnd.fujixerox.edmics-rlc',
    'mdi'           => 'image/vnd.ms-modi',
    'npx'           => 'image/vnd.net-fpx',
    'wbmp'          => 'image/vnd.wap.wbmp',
    'xif'           => 'image/vnd.xiff',
    'ras'           => 'image/x-cmu-raster',
    'cmx'           => 'image/x-cmx',
    'ico'           => 'image/x-ico',
    'pcx'           => 'image/x-pcx',
    'pic'           => 'image/x-pict',
    'pct'           => 'image/x-pict',
    'pnm'           => 'image/x-portable-anymap',
    'pbm'           => 'image/x-portable-bitmap',
    'pgm'           => 'image/x-portable-graymap',
    'ppm'           => 'image/x-portable-pixmap',
    'rgb'           => 'image/x-rgb',
    'xbm'           => 'image/x-xbitmap',
    'xpm'           => 'image/x-xpixmap',
    'xwd'           => 'image/x-xwindowdump',
    'eml'           => 'message/rfc822',
    'mime'          => 'message/rfc822',
    'igs'           => 'model/iges',
    'iges'          => 'model/iges',
    'msh'           => 'model/mesh',
    'mesh'          => 'model/mesh',
    'silo'          => 'model/mesh',
    'dwf'           => 'model/vnd.dwf',
    'gdl'           => 'model/vnd.gdl',
    'gtw'           => 'model/vnd.gtw',
    'mts'           => 'model/vnd.mts',
    'vtu'           => 'model/vnd.vtu',
    'wrl'           => 'model/vrml',
    'vrml'          => 'model/vrml',
    'ics'           => 'text/calendar',
    'ifb'           => 'text/calendar',
    'css'           => 'text/css',
    'csv'           => 'text/x-comma-separated-values',
    'html'          => 'text/html',
    'htm'           => 'text/html',
    'txt'           => 'text/plain',
    'text'          => 'text/plain',
    'conf'          => 'text/plain',
    'def'           => 'text/plain',
    'list'          => 'text/plain',
    'log'           => 'text/x-log',
    'in'            => 'text/plain',
    'dsc'           => 'text/prs.lines.tag',
    'rtx'           => 'text/richtext',
    'sgml'          => 'text/sgml',
    'sgm'           => 'text/sgml',
    'tsv'           => 'text/tab-separated-values',
    't'             => 'application/x-troff',
    'tr'            => 'application/x-troff',
    'roff'          => 'application/x-troff',
    'man'           => 'application/x-troff-man',
    'me'            => 'text/x-troff-me',
    'ms'            => 'text/x-troff-ms',
    'uri'           => 'text/x-uri',
    'uris'          => 'text/uri-list',
    'urls'          => 'text/uri-list',
    'fly'           => 'text/vnd.fly',
    'flx'           => 'text/vnd.fmi.flexstor',
    '3dml'          => 'text/vnd.in3d.3dml',
    'spot'          => 'text/vnd.in3d.spot',
    'jad'           => 'text/vnd.sun.j2me.app-descriptor',
    'wml'           => 'text/vnd.wap.wml',
    'wmls'          => 'text/vnd.wap.wmlscript',
    's'             => 'text/x-asm',
    'asm'           => 'text/x-asm',
    'c'             => 'text/x-csrc',
    'cc'            => 'text/x-c++src',
    'cxx'           => 'text/x-c++src',
    'cpp'           => 'text/x-c++src',
    'h'             => 'text/x-chdr',
    'hh'            => 'text/x-c++hdr',
    'dic'           => 'text/x-c',
    'f'             => 'text/x-fortran',
    'for'           => 'text/x-fortran',
    'f77'           => 'text/x-fortran',
    'f90'           => 'text/x-fortran',
    'p'             => 'text/x-pascal',
    'pas'           => 'text/x-pascal',
    'java'          => 'text/x-java',
    'etx'           => 'text/x-setext',
    'uu'            => 'text/x-uuencode',
    'vcs'           => 'text/calendar',
    'vcf'           => 'text/directory',
    '3gp'           => 'video/3gpp',
    '3g2'           => 'video/3gpp2',
    'h261'          => 'video/h261',
    'h263'          => 'video/h263',
    'h264'          => 'video/h264',
    'jpgv'          => 'video/jpeg',
    'jpm'           => 'video/jpm',
    'jpgm'          => 'video/jpm',
    'mj2'           => 'video/mj2',
    'mjp2'          => 'video/mj2',
    'mp4'           => 'video/mp4',
    'mp4v'          => 'video/mp4',
    'mpg4'          => 'video/mp4',
    'mpeg'          => 'video/mpeg',
    'mpg'           => 'video/mpeg',
    'mpe'           => 'video/mpeg',
    'm1v'           => 'video/mpeg',
    'm2v'           => 'video/mpeg',
    'qt'            => 'video/quicktime',
    'mov'           => 'video/quicktime',
    'fvt'           => 'video/vnd.fvt',
    'mxu'           => 'video/vnd.mpegurl',
    'm4u'           => 'video/vnd.mpegurl',
    'viv'           => 'video/vnd.vivo',
    'fli'           => 'video/x-flic',
    'asx'           => 'video/x-ms-asf',
    'wm'            => 'video/x-ms-wm',
    'wmv'           => 'video/x-ms-wmv',
    'wmx'           => 'video/x-ms-wmx',
    'wvx'           => 'video/x-ms-wvx',
    'avi'           => 'video/x-msvideo',
    'movie'         => 'video/x-sgi-movie',
    'ice'           => 'x-conference/x-cooltalk',
    'odb'           => 'application/vnd.oasis.opendocument.database',
    'oot'           => 'application/vnd.oasis.opendocument.text',
    'odm'           => 'application/vnd.oasis.opendocument.text-master',
    'sxc'           => 'application/vnd.sun.xml.calc',
    'stc'           => 'application/vnd.sun.xml.calc.template',
    'sxd'           => 'application/vnd.sun.xml.draw',
    'std'           => 'application/vnd.sun.xml.draw.template',
    'sxg'           => 'application/vnd.sun.xml.writer.global',
    'sxm'           => 'application/vnd.sun.xml.math',
    'sxi'           => 'application/vnd.sun.xml.impress',
    'sti'           => 'application/vnd.sun.xml.impress.template',
    'sxw'           => 'application/vnd.sun.xml.writer',
    'stw'           => 'application/vnd.sun.xml.writer.template',
    'Z'             => 'application/x-compress',
    'gz'            => 'application/x-gzip',
    'tgz'           => 'application/x-compressed-tar',
    'php'           => 'application/x-php',
    'php3'          => 'application/x-php',
    'pl'            => 'application/x-perl',
    'pm'            => 'application/x-perl',
    'gsm'           => 'audio/x-gsm',
    'vfb'           => 'text/calendar',
    'diff'          => 'text/x-patch',
    'patch'         => 'text/x-patch',
    'shtml'         => 'text/html',
    'po'            => 'text/x-gettext-translation',
    'sgl'           => 'application/vnd.stardivision.writer',
    'wk4'           => 'application/vnd.lotus-1-2-3',
    'pict2'         => 'image/x-pict',
    'lhz'           => 'application/x-lhz',
    'tar.bz2'       => 'application/x-bzip-compressed-tar',
    'rle'           => 'image/rle',
    'pcf.Z'         => 'application/x-font-type1',
    'm15'           => 'audio/x-mod',
    'flac'          => 'audio/x-flac',
    'dc'            => 'application/x-dc-rom',
    'm'             => 'text/x-objcsrc',
    'o'             => 'application/x-object',
    'fits'          => 'image/x-fits',
    'pfa'           => 'application/x-font-type1',
    'jnlp'          => 'application/x-java-jnlp-file',
    'pfb'           => 'application/x-font-type1',
    'smd'           => 'application/vnd.stardivision.mail',
    'it'            => 'audio/x-it',
    'bib'           => 'text/x-bibtex',
    'moc'           => 'text/x-moc',
    'theme'         => 'application/x-theme',
    'mod'           => 'audio/x-mod',
    'smf'           => 'application/vnd.stardivision.math',
    'uni'           => 'audio/x-mod',
    'mtm'           => 'audio/x-mod',
    'ppz'           => 'application/vnd.ms-powerpoint',
    's3m'           => 'audio/x-s3m',
    'deb'           => 'application/x-deb',
    'tk'            => 'text/x-tcl',
    'cdr'           => 'application/vnd.corel-draw',
    'lwob'          => 'image/x-lwo',
    'sml'           => 'application/smil',
    'etheme'        => 'application/x-e-theme',
    '3ds'           => 'image/x-3ds',
    'vob'           => 'video/mpeg',
    'voc'           => 'audio/x-voc',
    'bdf'           => 'application/x-font-bdf',
    'ps.gz'         => 'application/x-gzpostscript',
    'uil'           => 'text/x-uil',
    'ts'            => 'application/x-linguist',
    'asp'           => 'application/x-asp',
    'nes'           => 'application/x-nes-rom',
    'sms'           => 'application/x-sms-rom',
    'BLEND'         => 'application/x-blender',
    'kil'           => 'application/x-killustrator',
    'icb'           => 'image/x-icb',
    'lyx'           => 'application/x-lyx',
    'jng'           => 'image/x-jng',
    'vor'           => 'application/vnd.stardivision.writer',
    'adb'           => 'text/x-adasrc',
    'flc'           => 'video/x-flic',
    'wpg'           => 'application/x-wpg',
    'wb1'           => 'application/x-quattropro',
    'gra'           => 'application/x-graphite',
    'wb2'           => 'application/x-quattropro',
    'ltx'           => 'text/x-tex',
    'xac'           => 'application/x-gnucash',
    'wb3'           => 'application/x-quattropro',
    'epsf'          => 'image/x-eps',
    'el'            => 'text/x-emacs-lisp',
    'jp2'           => 'image/jpeg2000',
    'tar.gz'        => 'application/x-compressed-tar',
    'epsi'          => 'image/x-eps',
    'ui'            => 'application/x-designer',
    'old'           => 'application/x-trash',
    'tar.Z'         => 'application/x-tarz',
    'ttf'           => 'application/x-font-ttf',
    'siag'          => 'application/x-siag',
    'sid'           => 'audio/prs.sid',
    'msod'          => 'image/x-msod',
    'h++'           => 'text/x-chdr',
    'tar.lzo'       => 'application/x-tzo',
    'tar.bz'        => 'application/x-bzip-compressed-tar',
    'ads'           => 'text/x-adasrc',
    'sda'           => 'application/vnd.stardivision.draw',
    'lzo'           => 'application/x-lzop',
    'cur'           => 'image/x-win-bitmap',
    'sdc'           => 'application/vnd.stardivision.calc',
    'sik'           => 'application/x-trash',
    'sdd'           => 'application/vnd.stardivision.impress',
    'xld'           => 'application/vnd.ms-excel',
    'gmo'           => 'application/x-gettext-translation',
    'xll'           => 'application/vnd.ms-excel',
    'blend'         => 'application/x-blender',
    'pw'            => 'application/x-pw',
    'kud'           => 'application/x-kugar',
    'mkv'           => 'application/x-matroska',
    'obj'           => 'application/x-tgif',
    'py'            => 'text/x-python',
    'sds'           => 'application/vnd.stardivision.chart',
    'idl'           => 'text/x-idl',
    'dat'           => 'video/mpeg',
    'stm'           => 'audio/x-stm',
    'PAR2'          => 'application/x-par2',
    'xcf.bz2'       => 'image/x-compressed-xcf',
    'psid'          => 'audio/prs.sid',
    'pict'          => 'image/x-pict',
    'ag'            => 'image/x-applix-graphics',
    'fo'            => 'text/x-xslfo',
    'sdw'           => 'application/vnd.stardivision.writer',
    'abw.CRASHED'   => 'application/x-abiword',
    'gsf'           => 'application/x-font-type1',
    'xcf.gz'        => 'image/x-compressed-xcf',
    'pcd'           => 'image/x-photo-cd',
    'egon'          => 'application/x-egon',
    'pcf'           => 'application/x-font-pcf',
    'al'            => 'application/x-perl',
    'gnc'           => 'application/x-gnucash',
    'tzo'           => 'application/x-tzo',
    'la'            => 'application/x-shared-library-la',
    'kpm'           => 'application/x-kpovmodeler',
    'qif'           => 'application/x-qw',
    'sty'           => 'text/x-tex',
    'psf'           => 'application/x-font-linux-psf',
    'as'            => 'application/x-applix-spreadsheet',
    'dbf'           => 'application/x-dbase',
    'ilbm'          => 'image/x-ilbm',
    'aw'            => 'application/x-applix-word',
    'gb'            => 'application/x-gameboy-rom',
    'xmi'           => 'text/x-xmi',
    'abw.gz'        => 'application/x-abiword',
    'XM'            => 'audio/x-mod',
    'gnumeric'      => 'application/x-gnumeric',
    'bak'           => 'application/x-trash',
    'xslfo'         => 'text/x-xslfo',
    'gg'            => 'application/x-sms-rom',
    'cgi'           => 'application/x-cgi',
    'mgp'           => 'application/x-magicpoint',
    'spd'           => 'application/x-font-speedo',
    'gnucash'       => 'application/x-gnucash',
    'cls'           => 'text/x-tex',
    'php4'          => 'application/x-php',
    'sun'           => 'image/x-sun-raster',
    'pyc'           => 'application/x-python-bytecode',
    'xcf'           => 'image/x-xcf',
    'xbel'          => 'application/x-xbel',
    'jpr'           => 'application/x-jbuilder-project',
    'afm'           => 'application/x-font-afm',
    'fig'           => 'image/x-xfig',
    'perl'          => 'application/x-perl',
    'rej'           => 'application/x-reject',
    'qtvr'          => 'video/quicktime',
    'jpx'           => 'application/x-jbuilder-project',
    '669'           => 'audio/x-mod',
    'kdelnk'        => 'application/x-desktop',
    'md'            => 'application/x-genesis-rom',
    'pyo'           => 'application/x-python-bytecode',
    'oleo'          => 'application/x-oleo',
    'ac3'           => 'audio/ac3',
    'mml'           => 'text/mathml',
    'par2'          => 'application/x-par2',
    'sylk'          => 'text/spreadsheet',
    'C'             => 'text/x-c++src',
    'cert'          => 'application/x-x509-ca-cert',
    'ult'           => 'audio/x-mod',
    'lwo'           => 'image/x-lwo',
    'dcl'           => 'text/x-dcl',
    'zoo'           => 'application/x-zoo',
    'dcm'           => 'application/dicom',
    'mm'            => 'text/x-troff-mm',
    'iff'           => 'image/x-iff',
    'lws'           => 'image/x-lws',
    'zabw'          => 'application/x-abiword',
    'blender'       => 'application/x-blender',
    'glade'         => 'application/x-glade',
    'rpm'           => 'application/x-rpm',
    'tga'           => 'image/x-tga',
    'jar'           => 'application/x-jar',
    'cpio.gz'       => 'application/x-cpio-compressed',
    'dsl'           => 'text/x-dsl',
    'kra'           => 'application/x-krita',
    'n64'           => 'application/x-n64-rom',
    'm4a'           => 'audio/x-m4a',
    'c++'           => 'text/x-c++src',
    'moov'          => 'video/quicktime',
    'sam'           => 'application/x-amipro',
    'nsv'           => 'video/x-nsv',
    'dia'           => 'application/x-dia-diagram',
    'xi'            => 'audio/x-xi',
    'hp'            => 'text/x-chdr',
    'gen'           => 'application/x-genesis-rom',
    'url'           => 'text/x-uri',
    'hs'            => 'text/x-haskell',
    'xm'            => 'audio/x-xm',
    'sql'           => 'text/x-sql',
    'NSV'           => 'video/x-nsv',
    'desktop'       => 'application/x-desktop',
    'mng'           => 'video/x-mng',
    'pem'           => 'application/x-x509-ca-cert',
    'slk'           => 'text/spreadsheet',
    'cs'            => 'text/x-csharp',
    'arj'           => 'application/x-arj',
    'a'             => 'application/x-archive',
    'lhs'           => 'text/x-literate-haskell',
    'gcrd'          => 'text/directory',
    'vct'           => 'text/directory',
    'wk1'           => 'application/vnd.lotus-1-2-3',
    'msx'           => 'application/x-msx-rom',
    'sgi'           => 'image/x-sgi',
    'd'             => 'text/x-dsrc',
    'CSSL'          => 'text/css',
    'wk3'           => 'application/vnd.lotus-1-2-3',
    'abw'           => 'application/x-abiword',
    'pict1'         => 'image/x-pict',
    'xlam'          => 'application/vnd.ms-excel.addin.macroEnabled.12',
    'xlsb'          => 'application/vnd.ms-excel.sheet.binary.macroEnabled.12',
    'xlsm'          => 'application/vnd.ms-excel.sheet.macroEnabled.12',
    'xltm'          => 'application/vnd.ms-excel.template.macroEnabled.12',
    'docm'          => 'application/vnd.ms-word.document.macroEnabled.12',
    'dotm'          => 'application/vnd.ms-word.template.macroEnabled.12',
    'ppam'          => 'application/vnd.ms-powerpoint.addin.macroEnabled.12',
    'pptm'          => 'application/vnd.ms-powerpoint.presentation.macroEnabled.12',
    'ppsm'          => 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12',
    'potm'          => 'application/vnd.ms-powerpoint.template.macroEnabled.12',
    'potx'          => 'application/vnd.openxmlformats-officedocument.presentationml.template',
    'ppsx'          => 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
    'pptx'          => 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
    'xlsx'          => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
    'xltx'          => 'application/vnd.openxmlformats-officedocument.spreadsheetml.template',
    'docx'          => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
    'dotx'          => 'application/vnd.openxmlformats-officedocument.wordprocessingml.template'
);
