{
  Copyright (c) 2007, The Jam Warehouse Software (Pty) Ltd.

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

     i) Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
    ii) Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.
   iii) Neither the name of the The Jam Warehouse Software (Pty) Ltd nor the
        names of its contributors may be used to endorse or promote products
        derived from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES ( INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT ( INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
}

{*
   Unit auto-generated by delphi's wsdl imported

   @Author Bjarte Kalstveit Vebjrnsen <bjarte@macaos.com>
   @Version 1.0  BKV 24.09.2007  Initial revision
*}

// ************************************************************************ //
// The types declared in this file were generated from data read from the
// WSDL File described below:
// WSDL     : http://ktdms.trunk/ktwebservice/webservice.php?wsdl
// Codegen  : [wfDebug,wfGenerateWarnings,wfUseSerializerClassForAttrs]
// Version  : 1.0
// (23.09.2007 21:20:12 - 1.33.2.6)
// ************************************************************************ //

unit uwebservice;

interface

uses InvokeRegistry, SOAPHTTPClient, Types, XSBuiltIns;

type

  // ************************************************************************ //
  // The following types, referred to in the WSDL document are not being represented
  // in this file. They are either aliases[@] of other types represented or were referred
  // to but never[!] declared in the document. The types from the latter category
  // typically map to predefined/known XML or Borland types; however, they could also 
  // indicate incorrect WSDL documents that failed to declare or import a schema type.
  // ************************************************************************ //
  // !:int             - "http://www.w3.org/2001/XMLSchema"
  // !:string          - "http://www.w3.org/2001/XMLSchema"
  // !:boolean         - "http://www.w3.org/2001/XMLSchema"

  kt_response          = class;                 { "urn:KnowledgeTree" }
  kt_folder_detail     = class;                 { "urn:KnowledgeTree" }
  kt_folder_item       = class;                 { "urn:KnowledgeTree" }
  kt_folder_contents   = class;                 { "urn:KnowledgeTree" }
  kt_document_detail   = class;                 { "urn:KnowledgeTree" }
  kt_metadata_selection_item = class;           { "urn:KnowledgeTree" }
  kt_metadata_field    = class;                 { "urn:KnowledgeTree" }
  kt_metadata_fieldset = class;                 { "urn:KnowledgeTree" }
  kt_metadata_response = class;                 { "urn:KnowledgeTree" }
  kt_document_transitions_response = class;     { "urn:KnowledgeTree" }
  kt_document_transaction_history_item = class;   { "urn:KnowledgeTree" }
  kt_linked_document   = class;                 { "urn:KnowledgeTree" }
  kt_linked_document_response = class;          { "urn:KnowledgeTree" }
  kt_document_transaction_history_response = class;   { "urn:KnowledgeTree" }
  kt_document_version_history_item = class;     { "urn:KnowledgeTree" }
  kt_document_version_history_response = class;   { "urn:KnowledgeTree" }
  kt_document_types_response = class;           { "urn:KnowledgeTree" }



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_folder_detail = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fid: Integer;
    Ffolder_name: WideString;
    Fparent_id: Integer;
    Ffull_path: WideString;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property id: Integer read Fid write Fid;
    property folder_name: WideString read Ffolder_name write Ffolder_name;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property full_path: WideString read Ffull_path write Ffull_path;
  end;

  kt_folder_items = array of kt_folder_item;    { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_folder_item = class(TRemotable)
  private
    Fid: Integer;
    Fitem_type: WideString;
    Ftitle: WideString;
    Fcreator: WideString;
    Fchecked_out_by: WideString;
    Fmodified_by: WideString;
    Ffilename: WideString;
    Fsize: WideString;
    Fmajor_version: WideString;
    Fminor_version: WideString;
    Fstorage_path: WideString;
    Fmime_type: WideString;
    Fmime_icon_path: WideString;
    Fmime_display: WideString;
    Fworkflow: WideString;
    Fworkflow_state: WideString;
    Fitems: kt_folder_items;
  public
    destructor Destroy; override;
  published
    property id: Integer read Fid write Fid;
    property item_type: WideString read Fitem_type write Fitem_type;
    property title: WideString read Ftitle write Ftitle;
    property creator: WideString read Fcreator write Fcreator;
    property checked_out_by: WideString read Fchecked_out_by write Fchecked_out_by;
    property modified_by: WideString read Fmodified_by write Fmodified_by;
    property filename: WideString read Ffilename write Ffilename;
    property size: WideString read Fsize write Fsize;
    property major_version: WideString read Fmajor_version write Fmajor_version;
    property minor_version: WideString read Fminor_version write Fminor_version;
    property storage_path: WideString read Fstorage_path write Fstorage_path;
    property mime_type: WideString read Fmime_type write Fmime_type;
    property mime_icon_path: WideString read Fmime_icon_path write Fmime_icon_path;
    property mime_display: WideString read Fmime_display write Fmime_display;
    property workflow: WideString read Fworkflow write Fworkflow;
    property workflow_state: WideString read Fworkflow_state write Fworkflow_state;
    property items: kt_folder_items read Fitems write Fitems;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_folder_contents = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Ffolder_id: Integer;
    Ffolder_name: WideString;
    Ffull_path: WideString;
    Fitems: kt_folder_items;
  public
    destructor Destroy; override;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property folder_id: Integer read Ffolder_id write Ffolder_id;
    property folder_name: WideString read Ffolder_name write Ffolder_name;
    property full_path: WideString read Ffull_path write Ffull_path;
    property items: kt_folder_items read Fitems write Fitems;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_detail = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Ftitle: WideString;
    Fdocument_type: WideString;
    Fversion: WideString;
    Ffilename: WideString;
    Fcreated_date: WideString;
    Fcreated_by: WideString;
    Fupdated_date: WideString;
    Fupdated_by: WideString;
    Fdocument_id: Integer;
    Ffolder_id: Integer;
    Fworkflow: WideString;
    Fworkflow_state: WideString;
    Fcheckout_by: WideString;
    Ffull_path: WideString;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property title: WideString read Ftitle write Ftitle;
    property document_type: WideString read Fdocument_type write Fdocument_type;
    property version: WideString read Fversion write Fversion;
    property filename: WideString read Ffilename write Ffilename;
    property created_date: WideString read Fcreated_date write Fcreated_date;
    property created_by: WideString read Fcreated_by write Fcreated_by;
    property updated_date: WideString read Fupdated_date write Fupdated_date;
    property updated_by: WideString read Fupdated_by write Fupdated_by;
    property document_id: Integer read Fdocument_id write Fdocument_id;
    property folder_id: Integer read Ffolder_id write Ffolder_id;
    property workflow: WideString read Fworkflow write Fworkflow;
    property workflow_state: WideString read Fworkflow_state write Fworkflow_state;
    property checkout_by: WideString read Fcheckout_by write Fcheckout_by;
    property full_path: WideString read Ffull_path write Ffull_path;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_metadata_selection_item = class(TRemotable)
  private
    Fid: Integer;
    Fname_: WideString;
    Fvalue: WideString;
    Fparent_id: Integer;
  published
    property id: Integer read Fid write Fid;
    property name_: WideString read Fname_ write Fname_;
    property value: WideString read Fvalue write Fvalue;
    property parent_id: Integer read Fparent_id write Fparent_id;
  end;

  kt_metadata_selection = array of kt_metadata_selection_item;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_metadata_field = class(TRemotable)
  private
    Fname_: WideString;
    Frequired: Boolean;
    Fvalue: WideString;
    Fdescription: WideString;
    Fcontrol_type: WideString;
    Fselection: kt_metadata_selection;
  public
    destructor Destroy; override;
  published
    property name_: WideString read Fname_ write Fname_;
    property required: Boolean read Frequired write Frequired;
    property value: WideString read Fvalue write Fvalue;
    property description: WideString read Fdescription write Fdescription;
    property control_type: WideString read Fcontrol_type write Fcontrol_type;
    property selection: kt_metadata_selection read Fselection write Fselection;
  end;

  kt_metadata_fields = array of kt_metadata_field;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_metadata_fieldset = class(TRemotable)
  private
    Ffieldset: WideString;
    Fdescription: WideString;
    Ffields: kt_metadata_fields;
  public
    destructor Destroy; override;
  published
    property fieldset: WideString read Ffieldset write Ffieldset;
    property description: WideString read Fdescription write Fdescription;
    property fields: kt_metadata_fields read Ffields write Ffields;
  end;

  kt_metadata_fieldsets = array of kt_metadata_fieldset;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_metadata_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fmetadata: kt_metadata_fieldsets;
  public
    destructor Destroy; override;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property metadata: kt_metadata_fieldsets read Fmetadata write Fmetadata;
  end;

  kt_document_transitions = array of WideString;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_transitions_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fmetadata: kt_document_transitions;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property metadata: kt_document_transitions read Fmetadata write Fmetadata;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_transaction_history_item = class(TRemotable)
  private
    Ftransaction_name: WideString;
    Fusername: WideString;
    Fversion: WideString;
    Fcomment: WideString;
    Fdatetime: WideString;
  published
    property transaction_name: WideString read Ftransaction_name write Ftransaction_name;
    property username: WideString read Fusername write Fusername;
    property version: WideString read Fversion write Fversion;
    property comment: WideString read Fcomment write Fcomment;
    property datetime: WideString read Fdatetime write Fdatetime;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_linked_document = class(TRemotable)
  private
    Fdocument_id: Integer;
    Ftitle: WideString;
    Fsize: Integer;
    Fworkflow: WideString;
    Fworkflow_state: WideString;
    Flink_type: WideString;
  published
    property document_id: Integer read Fdocument_id write Fdocument_id;
    property title: WideString read Ftitle write Ftitle;
    property size: Integer read Fsize write Fsize;
    property workflow: WideString read Fworkflow write Fworkflow;
    property workflow_state: WideString read Fworkflow_state write Fworkflow_state;
    property link_type: WideString read Flink_type write Flink_type;
  end;

  kt_linked_documents = array of kt_linked_document;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_linked_document_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fparent_document_id: WideString;
    Flinks: kt_linked_documents;
  public
    destructor Destroy; override;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property parent_document_id: WideString read Fparent_document_id write Fparent_document_id;
    property links: kt_linked_documents read Flinks write Flinks;
  end;

  kt_document_transaction_history = array of kt_document_transaction_history_item;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_transaction_history_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fhistory: kt_document_transaction_history;
  public
    destructor Destroy; override;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property history: kt_document_transaction_history read Fhistory write Fhistory;
  end;



  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_version_history_item = class(TRemotable)
  private
    Fuser: Integer;
    Fmetadata_version: WideString;
    Fcontent_version: WideString;
  published
    property user: Integer read Fuser write Fuser;
    property metadata_version: WideString read Fmetadata_version write Fmetadata_version;
    property content_version: WideString read Fcontent_version write Fcontent_version;
  end;

  kt_document_version_history = array of kt_document_version_history_item;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_version_history_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fhistory: kt_document_version_history;
  public
    destructor Destroy; override;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property history: kt_document_version_history read Fhistory write Fhistory;
  end;

  kt_document_types_array = array of WideString;   { "urn:KnowledgeTree" }


  // ************************************************************************ //
  // Namespace : urn:KnowledgeTree
  // ************************************************************************ //
  kt_document_types_response = class(TRemotable)
  private
    Fstatus_code: Integer;
    Fmessage_: WideString;
    Fdocument_types: kt_document_types_array;
  published
    property status_code: Integer read Fstatus_code write Fstatus_code;
    property message_: WideString read Fmessage_ write Fmessage_;
    property document_types: kt_document_types_array read Fdocument_types write Fdocument_types;
  end;


  // ************************************************************************ //
  // Namespace : http://schemas.xmlsoap.org/soap/envelope/
  // soapAction: http://schemas.xmlsoap.org/soap/envelope/#KTWebService#%operationName%
  // transport : http://schemas.xmlsoap.org/soap/http
  // style     : rpc
  // binding   : KnowledgeTreeBinding
  // service   : KnowledgeTreeService
  // port      : KnowledgeTreePort
  // URL       : http://ktdms.trunk/ktwebservice/webservice.php
  // ************************************************************************ //
  KnowledgeTreePort = interface(IInvokable)
  ['{FA35CA60-1DC3-B3C7-6C65-BE4E3A6A8A22}']
    function  login(const username: WideString; const password: WideString; const ip: WideString): kt_response; stdcall;
    function  anonymous_login(const ip: WideString): kt_response; stdcall;
    function  logout(const session_id: WideString): kt_response; stdcall;
    function  get_folder_detail(const session_id: WideString; const folder_id: Integer): kt_folder_detail; stdcall;
    function  get_folder_detail_by_name(const session_id: WideString; const folder_name: WideString): kt_folder_detail; stdcall;
    function  get_folder_contents(const session_id: WideString; const folder_id: Integer; const depth: Integer; const what: WideString): kt_folder_contents; stdcall;
    function  create_folder(const session_id: WideString; const folder_id: Integer; const folder_name: WideString): kt_folder_detail; stdcall;
    function  delete_folder(const session_id: WideString; const folder_id: Integer; const reason: WideString): kt_response; stdcall;
    function  rename_folder(const session_id: WideString; const folder_id: Integer; const newname: WideString): kt_response; stdcall;
    function  get_document_links(const session_id: WideString; const document_id: Integer): kt_linked_document_response; stdcall;
    function  link_documents(const session_id: WideString; const parent_document_id: Integer; const child_document_id: Integer; const type_: WideString): kt_response; stdcall;
    function  unlink_documents(const session_id: WideString; const parent_document_id: Integer; const child_document_id: Integer): kt_response; stdcall;
    function  copy_folder(const session_id: WideString; const source_id: Integer; const target_id: Integer; const reason: WideString): kt_response; stdcall;
    function  move_folder(const session_id: WideString; const source_id: Integer; const target_id: Integer; const reason: WideString): kt_response; stdcall;
    function  get_document_detail(const session_id: WideString; const document_id: Integer): kt_document_detail; stdcall;
    function  checkin_document(const session_id: WideString; const document_id: Integer; const filename: WideString; const reason: WideString; const tempfilename: WideString; const major_update: Boolean): kt_response; stdcall;
    function  checkin_small_document(const session_id: WideString; const document_id: Integer; const filename: WideString; const reason: WideString; const base64: WideString; const major_update: Boolean): kt_response; stdcall;
    function  checkin_base64_document(const session_id: WideString; const document_id: Integer; const filename: WideString; const reason: WideString; const base64: WideString; const major_update: Boolean): kt_response; stdcall;
    function  add_document(const session_id: WideString; const folder_id: Integer; const title: WideString; const filename: WideString; const documentype: WideString; const tempfilename: WideString): kt_document_detail; stdcall;
    function  add_small_document(const session_id: WideString; const folder_id: Integer; const title: WideString; const filename: WideString; const documentype: WideString; const base64: WideString): kt_document_detail; stdcall;
    function  add_base64_document(const session_id: WideString; const folder_id: Integer; const title: WideString; const filename: WideString; const documentype: WideString; const base64: WideString): kt_document_detail; stdcall;
    function  get_document_detail_by_name(const session_id: WideString; const document_name: WideString; const what: WideString): kt_document_detail; stdcall;
    function  checkout_document(const session_id: WideString; const document_id: Integer; const reason: WideString): kt_response; stdcall;
    function  checkout_small_document(const session_id: WideString; const document_id: Integer; const reason: WideString; const download: Boolean): kt_response; stdcall;
    function  checkout_base64_document(const session_id: WideString; const document_id: Integer; const reason: WideString; const download: Boolean): kt_response; stdcall;
    function  undo_document_checkout(const session_id: WideString; const document_id: Integer; const reason: WideString): kt_response; stdcall;
    function  download_document(const session_id: WideString; const document_id: Integer): kt_response; stdcall;
    function  download_small_document(const session_id: WideString; const document_id: Integer): kt_response; stdcall;
    function  download_base64_document(const session_id: WideString; const document_id: Integer): kt_response; stdcall;
    function  delete_document(const session_id: WideString; const document_id: Integer; const reason: WideString): kt_response; stdcall;
    function  change_document_owner(const session_id: WideString; const document_id: Integer; const username: WideString; const reason: WideString): kt_response; stdcall;
    function  copy_document(const session_id: WideString; const document_id: Integer; const folder_id: Integer; const reason: WideString; const newtitle: WideString; const newfilename: WideString): kt_response; stdcall;
    function  move_document(const session_id: WideString; const document_id: Integer; const folder_id: Integer; const reason: WideString; const newtitle: WideString; const newfilename: WideString): kt_response; stdcall;
    function  rename_document_title(const session_id: WideString; const document_id: Integer; const newtitle: WideString): kt_response; stdcall;
    function  rename_document_filename(const session_id: WideString; const document_id: Integer; const newfilename: WideString): kt_response; stdcall;
    function  change_document_type(const session_id: WideString; const document_id: Integer; const documenttype: WideString): kt_response; stdcall;
    function  start_document_workflow(const session_id: WideString; const document_id: Integer; const workflow: WideString): kt_response; stdcall;
    function  delete_document_workflow(const session_id: WideString; const document_id: Integer): kt_response; stdcall;
    function  perform_document_workflow_transition(const session_id: WideString; const document_id: Integer; const transition: WideString; const reason: WideString): kt_response; stdcall;
    function  get_document_metadata(const session_id: WideString; const document_id: Integer): kt_metadata_response; stdcall;
    function  get_document_type_metadata(const session_id: WideString; const document_type: WideString): kt_metadata_response; stdcall;
    function  update_document_metadata(const session_id: WideString; const document_id: Integer; const metadata: kt_metadata_fieldsets): kt_response; stdcall;
    function  get_document_workflow_transitions(const session_id: WideString; const document_id: Integer): kt_document_transitions_response; stdcall;
    function  get_document_workflow_state(const session_id: WideString; const document_id: Integer): kt_response; stdcall;
    function  get_document_transaction_history(const session_id: WideString; const document_id: Integer): kt_document_transaction_history_response; stdcall;
    function  get_document_version_history(const session_id: WideString; const document_id: Integer): kt_document_version_history_response; stdcall;
    function  get_document_types(const session_id: WideString): kt_document_types_response; stdcall;
    function  get_document_link_types(const session_id: WideString): kt_document_types_response; stdcall;
  end;

function GetKnowledgeTreePort(UseWSDL: Boolean=System.False; Addr: string=''; HTTPRIO: THTTPRIO = nil): KnowledgeTreePort;


implementation

function GetKnowledgeTreePort(UseWSDL: Boolean; Addr: string; HTTPRIO: THTTPRIO): KnowledgeTreePort;
const
  defWSDL = 'http://ktdms.trunk/ktwebservice/webservice.php?wsdl';
  defURL  = 'http://ktdms.trunk/ktwebservice/webservice.php';
  defSvc  = 'KnowledgeTreeService';
  defPrt  = 'KnowledgeTreePort';
var
  RIO: THTTPRIO;
begin
  Result := nil;
  if (Addr = '') then
  begin
    if UseWSDL then
      Addr := defWSDL
    else
      Addr := defURL;
  end;
  if HTTPRIO = nil then
    RIO := THTTPRIO.Create(nil)
  else
    RIO := HTTPRIO;
  try
    Result := (RIO as KnowledgeTreePort);
    if UseWSDL then
    begin
      RIO.WSDLLocation := Addr;
      RIO.Service := defSvc;
      RIO.Port := defPrt;
    end else
      RIO.URL := Addr;
  finally
    if (Result = nil) and (HTTPRIO = nil) then
      RIO.Free;
  end;
end;


destructor kt_folder_item.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fitems)-1 do
    if Assigned(Fitems[I]) then
      Fitems[I].Free;
  SetLength(Fitems, 0);
  inherited Destroy;
end;

destructor kt_folder_contents.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fitems)-1 do
    if Assigned(Fitems[I]) then
      Fitems[I].Free;
  SetLength(Fitems, 0);
  inherited Destroy;
end;

destructor kt_metadata_field.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fselection)-1 do
    if Assigned(Fselection[I]) then
      Fselection[I].Free;
  SetLength(Fselection, 0);
  inherited Destroy;
end;

destructor kt_metadata_fieldset.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Ffields)-1 do
    if Assigned(Ffields[I]) then
      Ffields[I].Free;
  SetLength(Ffields, 0);
  inherited Destroy;
end;

destructor kt_metadata_response.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fmetadata)-1 do
    if Assigned(Fmetadata[I]) then
      Fmetadata[I].Free;
  SetLength(Fmetadata, 0);
  inherited Destroy;
end;

destructor kt_linked_document_response.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Flinks)-1 do
    if Assigned(Flinks[I]) then
      Flinks[I].Free;
  SetLength(Flinks, 0);
  inherited Destroy;
end;

destructor kt_document_transaction_history_response.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fhistory)-1 do
    if Assigned(Fhistory[I]) then
      Fhistory[I].Free;
  SetLength(Fhistory, 0);
  inherited Destroy;
end;

destructor kt_document_version_history_response.Destroy;
var
  I: Integer;
begin
  for I := 0 to Length(Fhistory)-1 do
    if Assigned(Fhistory[I]) then
      Fhistory[I].Free;
  SetLength(Fhistory, 0);
  inherited Destroy;
end;

initialization
  InvRegistry.RegisterInterface(TypeInfo(KnowledgeTreePort), 'http://schemas.xmlsoap.org/soap/envelope/', '');
  InvRegistry.RegisterDefaultSOAPAction(TypeInfo(KnowledgeTreePort), 'http://schemas.xmlsoap.org/soap/envelope/#KTWebService#%operationName%');
  InvRegistry.RegisterExternalParamName(TypeInfo(KnowledgeTreePort), 'link_documents', 'type_', 'type');
  RemClassRegistry.RegisterXSClass(kt_response, 'urn:KnowledgeTree', 'kt_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_response), 'message_', 'message');
  RemClassRegistry.RegisterXSClass(kt_folder_detail, 'urn:KnowledgeTree', 'kt_folder_detail');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_folder_detail), 'message_', 'message');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_folder_items), 'urn:KnowledgeTree', 'kt_folder_items');
  RemClassRegistry.RegisterXSClass(kt_folder_item, 'urn:KnowledgeTree', 'kt_folder_item');
  RemClassRegistry.RegisterXSClass(kt_folder_contents, 'urn:KnowledgeTree', 'kt_folder_contents');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_folder_contents), 'message_', 'message');
  RemClassRegistry.RegisterXSClass(kt_document_detail, 'urn:KnowledgeTree', 'kt_document_detail');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_document_detail), 'message_', 'message');
  RemClassRegistry.RegisterXSClass(kt_metadata_selection_item, 'urn:KnowledgeTree', 'kt_metadata_selection_item');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_metadata_selection_item), 'name_', 'name');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_metadata_selection), 'urn:KnowledgeTree', 'kt_metadata_selection');
  RemClassRegistry.RegisterXSClass(kt_metadata_field, 'urn:KnowledgeTree', 'kt_metadata_field');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_metadata_field), 'name_', 'name');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_metadata_fields), 'urn:KnowledgeTree', 'kt_metadata_fields');
  RemClassRegistry.RegisterXSClass(kt_metadata_fieldset, 'urn:KnowledgeTree', 'kt_metadata_fieldset');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_metadata_fieldsets), 'urn:KnowledgeTree', 'kt_metadata_fieldsets');
  RemClassRegistry.RegisterXSClass(kt_metadata_response, 'urn:KnowledgeTree', 'kt_metadata_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_metadata_response), 'message_', 'message');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_document_transitions), 'urn:KnowledgeTree', 'kt_document_transitions');
  RemClassRegistry.RegisterXSClass(kt_document_transitions_response, 'urn:KnowledgeTree', 'kt_document_transitions_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_document_transitions_response), 'message_', 'message');
  RemClassRegistry.RegisterXSClass(kt_document_transaction_history_item, 'urn:KnowledgeTree', 'kt_document_transaction_history_item');
  RemClassRegistry.RegisterXSClass(kt_linked_document, 'urn:KnowledgeTree', 'kt_linked_document');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_linked_documents), 'urn:KnowledgeTree', 'kt_linked_documents');
  RemClassRegistry.RegisterXSClass(kt_linked_document_response, 'urn:KnowledgeTree', 'kt_linked_document_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_linked_document_response), 'message_', 'message');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_document_transaction_history), 'urn:KnowledgeTree', 'kt_document_transaction_history');
  RemClassRegistry.RegisterXSClass(kt_document_transaction_history_response, 'urn:KnowledgeTree', 'kt_document_transaction_history_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_document_transaction_history_response), 'message_', 'message');
  RemClassRegistry.RegisterXSClass(kt_document_version_history_item, 'urn:KnowledgeTree', 'kt_document_version_history_item');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_document_version_history), 'urn:KnowledgeTree', 'kt_document_version_history');
  RemClassRegistry.RegisterXSClass(kt_document_version_history_response, 'urn:KnowledgeTree', 'kt_document_version_history_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_document_version_history_response), 'message_', 'message');
  RemClassRegistry.RegisterXSInfo(TypeInfo(kt_document_types_array), 'urn:KnowledgeTree', 'kt_document_types_array');
  RemClassRegistry.RegisterXSClass(kt_document_types_response, 'urn:KnowledgeTree', 'kt_document_types_response');
  RemClassRegistry.RegisterExternalPropName(TypeInfo(kt_document_types_response), 'message_', 'message');

end.
