'''OpenGL extension EXT.texture_lod_bias

Overview (from the spec)
	
	OpenGL computes a texture level-of-detail parameter, called lambda
	in the GL specification, that determines which mipmap levels and
	their relative mipmap weights for use in mipmapped texture filtering.
	
	This extension provides a means to bias the lambda computation
	by a constant (signed) value.  This bias can provide a way to blur
	or pseudo-sharpen OpenGL's standard texture filtering.
	
	This blurring or pseudo-sharpening may be useful for special effects
	(such as depth-of-field effects) or image processing techniques
	(where the mipmap levels act as pre-downsampled image versions).
	On some implementations, increasing the texture lod bias may improve
	texture filtering performance (at the cost of texture bluriness).
	
	The extension mimics functionality found in Direct3D.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/texture_lod_bias.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_texture_lod_bias'
GL_MAX_TEXTURE_LOD_BIAS_EXT = constant.Constant( 'GL_MAX_TEXTURE_LOD_BIAS_EXT', 0x84FD )
glget.addGLGetConstant( GL_MAX_TEXTURE_LOD_BIAS_EXT, (1,) )
GL_TEXTURE_FILTER_CONTROL_EXT = constant.Constant( 'GL_TEXTURE_FILTER_CONTROL_EXT', 0x8500 )
GL_TEXTURE_LOD_BIAS_EXT = constant.Constant( 'GL_TEXTURE_LOD_BIAS_EXT', 0x8501 )


def glInitTextureLodBiasEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
